/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.maven.SpringApplicationAdminClient;

@Mojo(name="stop", requiresProject=true, defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="spring-boot.stop.fork")
    private Boolean fork;
    @Parameter
    private String jmxName = "org.springframework.boot:type=Admin,name=SpringApplication";
    @Parameter
    private int jmxPort = 9001;
    @Parameter(property="spring-boot.stop.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping stop as per configuration.");
            return;
        }
        this.getLog().info((CharSequence)"Stopping application...");
        try {
            if (this.isForked()) {
                this.stopForkedProcess();
            } else {
                this.stop();
            }
        }
        catch (IOException ex) {
            this.getLog().debug((CharSequence)("Service is not reachable anymore (" + ex.getMessage() + ")"));
        }
    }

    private boolean isForked() {
        if (this.fork != null) {
            return this.fork;
        }
        String property = this.project.getProperties().getProperty("_spring.boot.fork.enabled");
        return Boolean.parseBoolean(property);
    }

    private void stopForkedProcess() throws IOException, MojoFailureException, MojoExecutionException {
        try (JMXConnector connector = SpringApplicationAdminClient.connect(this.jmxPort);){
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            this.doStop(connection);
        }
    }

    private void stop() throws IOException, MojoFailureException, MojoExecutionException {
        this.doStop(ManagementFactory.getPlatformMBeanServer());
    }

    private void doStop(MBeanServerConnection connection) throws IOException, MojoExecutionException {
        try {
            new SpringApplicationAdminClient(connection, this.jmxName).stop();
        }
        catch (InstanceNotFoundException ex) {
            throw new MojoExecutionException("Spring application lifecycle JMX bean not found (fork is " + this.fork + "). Could not stop application gracefully", (Exception)ex);
        }
    }
}

