/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.BindConverter;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.DataObjectBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyName;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

class ValueObjectBinder
implements DataObjectBinder {
    ValueObjectBinder() {
    }

    @Override
    public <T> T bind(ConfigurationPropertyName name, Bindable<T> target, Binder.Context context, DataObjectPropertyBinder propertyBinder) {
        ValueObject<T> valueObject = ValueObject.get(target);
        if (valueObject == null) {
            return null;
        }
        List<ConstructorParameter> parameters = valueObject.getConstructorParameters();
        ArrayList<Object> args = new ArrayList<Object>(parameters.size());
        boolean bound = false;
        for (ConstructorParameter parameter : parameters) {
            Object arg = parameter.bind(propertyBinder);
            bound = bound || arg != null;
            arg = arg != null ? arg : parameter.getDefaultValue(context.getConverter());
            args.add(arg);
        }
        return bound ? (T)valueObject.instantiate(args) : null;
    }

    @Override
    public <T> T create(Bindable<T> target, Binder.Context context) {
        ValueObject<T> valueObject = ValueObject.get(target);
        if (valueObject == null) {
            return null;
        }
        List<ConstructorParameter> parameters = valueObject.getConstructorParameters();
        ArrayList<Object> args = new ArrayList<Object>(parameters.size());
        for (ConstructorParameter parameter : parameters) {
            args.add(parameter.getDefaultValue(context.getConverter()));
        }
        return valueObject.instantiate(args);
    }

    private static class ConstructorParameter {
        private final String name;
        private final ResolvableType type;
        private final Annotation[] annotations;

        ConstructorParameter(String name, ResolvableType type, Annotation[] annotations) {
            this.name = DataObjectPropertyName.toDashedForm(name);
            this.type = type;
            this.annotations = annotations;
        }

        Object getDefaultValue(BindConverter converter) {
            for (Annotation annotation : this.annotations) {
                if (!(annotation instanceof DefaultValue)) continue;
                return converter.convert(((DefaultValue)annotation).value(), this.type, this.annotations);
            }
            return null;
        }

        Object bind(DataObjectPropertyBinder propertyBinder) {
            return propertyBinder.bindProperty(this.name, Bindable.of(this.type).withAnnotations(this.annotations));
        }
    }

    private static final class DefaultValueObject<T>
    extends ValueObject<T> {
        private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
        private final List<ConstructorParameter> constructorParameters;

        private DefaultValueObject(Constructor<T> constructor) {
            super(constructor);
            this.constructorParameters = DefaultValueObject.parseConstructorParameters(constructor);
        }

        private static List<ConstructorParameter> parseConstructorParameters(Constructor<?> constructor) {
            String[] names = PARAMETER_NAME_DISCOVERER.getParameterNames(constructor);
            Assert.state((names != null ? 1 : 0) != 0, () -> "Failed to extract parameter names for " + constructor);
            Parameter[] parameters = constructor.getParameters();
            ArrayList<ConstructorParameter> result = new ArrayList<ConstructorParameter>(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                String name = names[i];
                ResolvableType type = ResolvableType.forConstructorParameter(constructor, (int)i);
                Annotation[] annotations = parameters[i].getDeclaredAnnotations();
                result.add(new ConstructorParameter(name, type, annotations));
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        List<ConstructorParameter> getConstructorParameters() {
            return this.constructorParameters;
        }

        static <T> ValueObject<T> get(Class<T> type, Predicate<Constructor<?>> constructorFilter) {
            Constructor<?> constructor = null;
            for (Constructor<?> candidate : type.getDeclaredConstructors()) {
                if (!DefaultValueObject.isCandidateConstructor(candidate, constructorFilter)) continue;
                if (constructor != null) {
                    return null;
                }
                constructor = candidate;
            }
            return DefaultValueObject.get(constructor);
        }

        private static boolean isCandidateConstructor(Constructor<?> candidate, Predicate<Constructor<?>> filter) {
            int modifiers = candidate.getModifiers();
            return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && filter.test(candidate);
        }

        static <T> DefaultValueObject<T> get(Constructor<T> constructor) {
            if (constructor == null || constructor.getParameterCount() == 0) {
                return null;
            }
            return new DefaultValueObject<T>(constructor);
        }
    }

    private static final class KotlinValueObject<T>
    extends ValueObject<T> {
        private final List<ConstructorParameter> constructorParameters;

        private KotlinValueObject(Constructor<T> primaryConstructor, KFunction<T> kotlinConstructor) {
            super(primaryConstructor);
            this.constructorParameters = this.parseConstructorParameters(kotlinConstructor);
        }

        private List<ConstructorParameter> parseConstructorParameters(KFunction<T> kotlinConstructor) {
            List parameters = kotlinConstructor.getParameters();
            ArrayList<ConstructorParameter> result = new ArrayList<ConstructorParameter>(parameters.size());
            for (KParameter parameter : parameters) {
                String name = parameter.getName();
                ResolvableType type = ResolvableType.forType((Type)ReflectJvmMapping.getJavaType((KType)parameter.getType()));
                Annotation[] annotations = parameter.getAnnotations().toArray(new Annotation[0]);
                result.add(new ConstructorParameter(name, type, annotations));
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        List<ConstructorParameter> getConstructorParameters() {
            return this.constructorParameters;
        }

        static <T> ValueObject<T> get(Class<T> type, Predicate<Constructor<?>> constructorFilter) {
            Constructor primaryConstructor = BeanUtils.findPrimaryConstructor(type);
            if (primaryConstructor == null || primaryConstructor.getParameterCount() == 0 || !constructorFilter.test(primaryConstructor)) {
                return null;
            }
            KFunction kotlinConstructor = ReflectJvmMapping.getKotlinFunction((Constructor)primaryConstructor);
            if (kotlinConstructor != null) {
                return new KotlinValueObject<T>(primaryConstructor, kotlinConstructor);
            }
            return DefaultValueObject.get(primaryConstructor);
        }
    }

    private static abstract class ValueObject<T> {
        private final Constructor<T> constructor;

        protected ValueObject(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        T instantiate(List<Object> args) {
            return (T)BeanUtils.instantiateClass(this.constructor, (Object[])args.toArray());
        }

        abstract List<ConstructorParameter> getConstructorParameters();

        static <T> ValueObject<T> get(Bindable<T> bindable) {
            if (bindable.getValue() != null) {
                return null;
            }
            Class type = bindable.getType().resolve();
            if (type == null || type.isEnum() || Modifier.isAbstract(type.getModifiers())) {
                return null;
            }
            if (KotlinDetector.isKotlinType((Class)type)) {
                return KotlinValueObject.get(type, bindable.getConstructorFilter());
            }
            return DefaultValueObject.get(type, bindable.getConstructorFilter());
        }
    }
}

