/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.mustache.SearchTemplateRequestBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.data.elasticsearch.core.query.AbstractQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.lang.Nullable;

public class NativeSearchQuery
extends AbstractQuery {
    @Nullable
    private final QueryBuilder query;
    @Nullable
    private QueryBuilder filter;
    @Nullable
    private List<SortBuilder<?>> sorts;
    private final List<ScriptField> scriptFields = new ArrayList<ScriptField>();
    @Nullable
    private CollapseBuilder collapseBuilder;
    @Nullable
    private List<AbstractAggregationBuilder<?>> aggregations;
    @Nullable
    private HighlightBuilder highlightBuilder;
    @Nullable
    private HighlightBuilder.Field[] highlightFields;
    @Nullable
    private List<IndexBoost> indicesBoost;
    @Nullable
    private SearchTemplateRequestBuilder searchTemplate;

    public NativeSearchQuery(@Nullable QueryBuilder query) {
        this.query = query;
    }

    public NativeSearchQuery(@Nullable QueryBuilder query, @Nullable QueryBuilder filter) {
        this.query = query;
        this.filter = filter;
    }

    public NativeSearchQuery(@Nullable QueryBuilder query, @Nullable QueryBuilder filter, @Nullable List<SortBuilder<?>> sorts) {
        this.query = query;
        this.filter = filter;
        this.sorts = sorts;
    }

    public NativeSearchQuery(@Nullable QueryBuilder query, @Nullable QueryBuilder filter, @Nullable List<SortBuilder<?>> sorts, @Nullable HighlightBuilder.Field[] highlightFields) {
        this.query = query;
        this.filter = filter;
        this.sorts = sorts;
        this.highlightFields = highlightFields;
    }

    public NativeSearchQuery(@Nullable QueryBuilder query, @Nullable QueryBuilder filter, @Nullable List<SortBuilder<?>> sorts, @Nullable HighlightBuilder highlightBuilder, @Nullable HighlightBuilder.Field[] highlightFields) {
        this.query = query;
        this.filter = filter;
        this.sorts = sorts;
        this.highlightBuilder = highlightBuilder;
        this.highlightFields = highlightFields;
    }

    @Nullable
    public QueryBuilder getQuery() {
        return this.query;
    }

    @Nullable
    public QueryBuilder getFilter() {
        return this.filter;
    }

    @Nullable
    public List<SortBuilder<?>> getElasticsearchSorts() {
        return this.sorts;
    }

    @Nullable
    public HighlightBuilder getHighlightBuilder() {
        return this.highlightBuilder;
    }

    @Nullable
    public HighlightBuilder.Field[] getHighlightFields() {
        return this.highlightFields;
    }

    public List<ScriptField> getScriptFields() {
        return this.scriptFields;
    }

    public void setScriptFields(List<ScriptField> scriptFields) {
        this.scriptFields.addAll(scriptFields);
    }

    public void addScriptField(ScriptField ... scriptField) {
        this.scriptFields.addAll(Arrays.asList(scriptField));
    }

    @Nullable
    public CollapseBuilder getCollapseBuilder() {
        return this.collapseBuilder;
    }

    public void setCollapseBuilder(CollapseBuilder collapseBuilder) {
        this.collapseBuilder = collapseBuilder;
    }

    @Nullable
    public List<AbstractAggregationBuilder<?>> getAggregations() {
        return this.aggregations;
    }

    public void addAggregation(AbstractAggregationBuilder<?> aggregationBuilder) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList();
        }
        this.aggregations.add(aggregationBuilder);
    }

    public void setAggregations(List<AbstractAggregationBuilder<?>> aggregations) {
        this.aggregations = aggregations;
    }

    @Nullable
    public List<IndexBoost> getIndicesBoost() {
        return this.indicesBoost;
    }

    public void setIndicesBoost(List<IndexBoost> indicesBoost) {
        this.indicesBoost = indicesBoost;
    }

    @Nullable
    public SearchTemplateRequestBuilder getSearchTemplate() {
        return this.searchTemplate;
    }

    public void setSearchTemplate(@Nullable SearchTemplateRequestBuilder searchTemplate) {
        this.searchTemplate = searchTemplate;
    }
}

