/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.lang.Nullable;

class DefaultLettuceClientConfiguration
implements LettuceClientConfiguration {
    private final boolean useSsl;
    private final boolean verifyPeer;
    private final boolean startTls;
    private final Optional<ClientResources> clientResources;
    private final Optional<ClientOptions> clientOptions;
    private final Duration timeout;
    private final Duration shutdownTimeout;

    DefaultLettuceClientConfiguration(boolean useSsl, boolean verifyPeer, boolean startTls, @Nullable ClientResources clientResources, @Nullable ClientOptions clientOptions, Duration timeout, Duration shutdownTimeout) {
        this.useSsl = useSsl;
        this.verifyPeer = verifyPeer;
        this.startTls = startTls;
        this.clientResources = Optional.ofNullable(clientResources);
        this.clientOptions = Optional.ofNullable(clientOptions);
        this.timeout = timeout;
        this.shutdownTimeout = shutdownTimeout;
    }

    @Override
    public boolean isUseSsl() {
        return this.useSsl;
    }

    @Override
    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    @Override
    public boolean isStartTls() {
        return this.startTls;
    }

    @Override
    public Optional<ClientResources> getClientResources() {
        return this.clientResources;
    }

    @Override
    public Optional<ClientOptions> getClientOptions() {
        return this.clientOptions;
    }

    @Override
    public Duration getCommandTimeout() {
        return this.timeout;
    }

    @Override
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }
}

