/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.time.Duration;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.CacheStatisticsProvider;
import org.springframework.data.redis.cache.DefaultRedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisCacheWriter
extends CacheStatisticsProvider {
    public static RedisCacheWriter nonLockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        return RedisCacheWriter.nonLockingRedisCacheWriter(connectionFactory, BatchStrategies.keys());
    }

    public static RedisCacheWriter nonLockingRedisCacheWriter(RedisConnectionFactory connectionFactory, BatchStrategy batchStrategy) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        Assert.notNull((Object)batchStrategy, (String)"BatchStrategy must not be null!");
        return new DefaultRedisCacheWriter(connectionFactory, batchStrategy);
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        return RedisCacheWriter.lockingRedisCacheWriter(connectionFactory, BatchStrategies.keys());
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory, BatchStrategy batchStrategy) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return new DefaultRedisCacheWriter(connectionFactory, Duration.ofMillis(50L), batchStrategy);
    }

    public void put(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    @Nullable
    public byte[] get(String var1, byte[] var2);

    @Nullable
    public byte[] putIfAbsent(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    public void remove(String var1, byte[] var2);

    public void clean(String var1, byte[] var2);

    public void clearStatistics(String var1);

    public RedisCacheWriter withStatisticsCollector(CacheStatisticsCollector var1);
}

