/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterNode;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveClusterCommands {
    public Flux<RedisClusterNode> clusterGetNodes();

    public Flux<RedisClusterNode> clusterGetSlaves(RedisClusterNode var1);

    public Mono<Map<RedisClusterNode, Collection<RedisClusterNode>>> clusterGetMasterSlaveMap();

    public Mono<Integer> clusterGetSlotForKey(ByteBuffer var1);

    public Mono<RedisClusterNode> clusterGetNodeForSlot(int var1);

    public Mono<RedisClusterNode> clusterGetNodeForKey(ByteBuffer var1);

    public Mono<ClusterInfo> clusterGetClusterInfo();

    public Mono<Void> clusterAddSlots(RedisClusterNode var1, int ... var2);

    public Mono<Void> clusterAddSlots(RedisClusterNode var1, RedisClusterNode.SlotRange var2);

    public Mono<Long> clusterCountKeysInSlot(int var1);

    public Mono<Void> clusterDeleteSlots(RedisClusterNode var1, int ... var2);

    public Mono<Void> clusterDeleteSlotsInRange(RedisClusterNode var1, RedisClusterNode.SlotRange var2);

    public Mono<Void> clusterForget(RedisClusterNode var1);

    public Mono<Void> clusterMeet(RedisClusterNode var1);

    public Mono<Void> clusterSetSlot(RedisClusterNode var1, int var2, AddSlots var3);

    public Flux<ByteBuffer> clusterGetKeysInSlot(int var1, int var2);

    public Mono<Void> clusterReplicate(RedisClusterNode var1, RedisClusterNode var2);

    public static enum AddSlots {
        MIGRATING,
        IMPORTING,
        STABLE,
        NODE;

    }
}

