/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.TimestampedException;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;

public class DefaultDestinationTopicResolver
implements DestinationTopicResolver,
ApplicationListener<ContextRefreshedEvent> {
    private static final String NO_OPS_SUFFIX = "-noOps";
    private static final List<Class<? extends Throwable>> FRAMEWORK_EXCEPTIONS = Arrays.asList(ListenerExecutionFailedException.class, TimestampedException.class);
    private final Map<String, DestinationTopicHolder> sourceDestinationsHolderMap;
    private final Map<String, DestinationTopic> destinationsTopicMap;
    private final Clock clock;
    private final ApplicationContext applicationContext;
    private boolean contextRefreshed;

    public DefaultDestinationTopicResolver(Clock clock, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.clock = clock;
        this.sourceDestinationsHolderMap = new HashMap<String, DestinationTopicHolder>();
        this.destinationsTopicMap = new HashMap<String, DestinationTopic>();
        this.contextRefreshed = false;
    }

    @Override
    public DestinationTopic resolveDestinationTopic(String topic, Integer attempt, Exception e, long originalTimestamp) {
        DestinationTopicHolder destinationTopicHolder = this.getDestinationHolderFor(topic);
        return destinationTopicHolder.getSourceDestination().isDltTopic() ? this.handleDltProcessingFailure(destinationTopicHolder) : (destinationTopicHolder.getSourceDestination().shouldRetryOn(attempt, this.maybeUnwrapException(e)) && !this.isPastTimout(originalTimestamp, destinationTopicHolder) ? this.resolveRetryDestination(destinationTopicHolder) : this.resolveDltOrNoOpsDestination(topic));
    }

    private Throwable maybeUnwrapException(Throwable e) {
        return FRAMEWORK_EXCEPTIONS.stream().filter(frameworkException -> frameworkException.isAssignableFrom(e.getClass())).map(frameworkException -> this.maybeUnwrapException(e.getCause())).findFirst().orElse(e);
    }

    private boolean isPastTimout(long originalTimestamp, DestinationTopicHolder destinationTopicHolder) {
        long timeout = destinationTopicHolder.getNextDestination().getDestinationTimeout();
        return timeout != -1L && Instant.now(this.clock).toEpochMilli() > originalTimestamp + timeout;
    }

    private DestinationTopic handleDltProcessingFailure(DestinationTopicHolder destinationTopicHolder) {
        return destinationTopicHolder.getSourceDestination().isAlwaysRetryOnDltFailure() ? destinationTopicHolder.getSourceDestination() : destinationTopicHolder.getNextDestination();
    }

    private DestinationTopic resolveRetryDestination(DestinationTopicHolder destinationTopicHolder) {
        return destinationTopicHolder.getSourceDestination().isSingleTopicRetry() ? destinationTopicHolder.getSourceDestination() : destinationTopicHolder.getNextDestination();
    }

    @Override
    public DestinationTopic getDestinationTopicByName(String topic) {
        return Objects.requireNonNull(this.destinationsTopicMap.get(topic), () -> "No topic found for " + topic);
    }

    private DestinationTopic resolveDltOrNoOpsDestination(String topic) {
        DestinationTopic destination = this.getDestinationFor(topic);
        return destination.isDltTopic() || destination.isNoOpsTopic() ? destination : this.resolveDltOrNoOpsDestination(destination.getDestinationName());
    }

    private DestinationTopic getDestinationFor(String topic) {
        return this.getDestinationHolderFor(topic).getNextDestination();
    }

    private DestinationTopicHolder getDestinationHolderFor(String topic) {
        return this.contextRefreshed ? this.doGetDestinationFor(topic) : this.getDestinationTopicSynchronized(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationTopicHolder getDestinationTopicSynchronized(String topic) {
        Map<String, DestinationTopicHolder> map = this.sourceDestinationsHolderMap;
        synchronized (map) {
            return this.doGetDestinationFor(topic);
        }
    }

    private DestinationTopicHolder doGetDestinationFor(String topic) {
        return Objects.requireNonNull(this.sourceDestinationsHolderMap.get(topic), () -> "No destination found for topic: " + topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDestinationTopics(List<DestinationTopic> destinationsToAdd) {
        if (this.contextRefreshed) {
            throw new IllegalStateException("Cannot add new destinations, " + DefaultDestinationTopicResolver.class.getSimpleName() + " is already refreshed.");
        }
        Map<String, DestinationTopicHolder> map = this.sourceDestinationsHolderMap;
        synchronized (map) {
            this.destinationsTopicMap.putAll(destinationsToAdd.stream().collect(Collectors.toMap(destination -> destination.getDestinationName(), destination -> destination)));
            this.sourceDestinationsHolderMap.putAll(this.correlatePairSourceAndDestinationValues(destinationsToAdd));
        }
    }

    private Map<String, DestinationTopicHolder> correlatePairSourceAndDestinationValues(List<DestinationTopic> destinationList) {
        return IntStream.range(0, destinationList.size()).boxed().collect(Collectors.toMap(index -> ((DestinationTopic)destinationList.get((int)index)).getDestinationName(), index -> new DestinationTopicHolder((DestinationTopic)destinationList.get((int)index), this.getNextDestinationTopic(destinationList, (int)index))));
    }

    private DestinationTopic getNextDestinationTopic(List<DestinationTopic> destinationList, int index) {
        return index != destinationList.size() - 1 ? destinationList.get(index + 1) : new DestinationTopic(destinationList.get(index).getDestinationName() + NO_OPS_SUFFIX, destinationList.get(index), NO_OPS_SUFFIX, DestinationTopic.Type.NO_OPS);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (Objects.equals(event.getApplicationContext(), this.applicationContext)) {
            this.contextRefreshed = true;
        }
    }

    public boolean isContextRefreshed() {
        return this.contextRefreshed;
    }

    public static class DestinationTopicHolder {
        private final DestinationTopic sourceDestination;
        private final DestinationTopic nextDestination;

        DestinationTopicHolder(DestinationTopic sourceDestination, DestinationTopic nextDestination) {
            this.sourceDestination = sourceDestination;
            this.nextDestination = nextDestination;
        }

        protected DestinationTopic getNextDestination() {
            return this.nextDestination;
        }

        protected DestinationTopic getSourceDestination() {
            return this.sourceDestination;
        }
    }
}

