/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypeConverter;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.AbstractStandardConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringStandardConversionService
extends AbstractStandardConversionService {
    private static final TypeDescriptor TYPE_STRING = TypeDescriptor.valueOf(String.class);

    protected String convertToString(Configuration configuration, IProcessingContext processingContext, Object object) {
        if (object == null) {
            return null;
        }
        TypeDescriptor objectTypeDescriptor = TypeDescriptor.forObject((Object)object);
        TypeConverter typeConverter = SpringStandardConversionService.getSpringConversionService(processingContext);
        if (typeConverter == null || !typeConverter.canConvert(objectTypeDescriptor, TYPE_STRING)) {
            return super.convertToString(configuration, processingContext, object);
        }
        return (String)typeConverter.convertValue(object, objectTypeDescriptor, TYPE_STRING);
    }

    protected <T> T convertOther(Configuration configuration, IProcessingContext processingContext, Object object, Class<T> targetClass) {
        if (object == null) {
            return null;
        }
        TypeDescriptor objectTypeDescriptor = TypeDescriptor.forObject((Object)object);
        TypeDescriptor targetTypeDescriptor = TypeDescriptor.valueOf(targetClass);
        TypeConverter typeConverter = SpringStandardConversionService.getSpringConversionService(processingContext);
        if (typeConverter == null || !typeConverter.canConvert(objectTypeDescriptor, targetTypeDescriptor)) {
            return (T)super.convertOther(configuration, processingContext, object, targetClass);
        }
        return (T)typeConverter.convertValue(object, objectTypeDescriptor, targetTypeDescriptor);
    }

    private static TypeConverter getSpringConversionService(IProcessingContext processingContext) {
        EvaluationContext evaluationContext = (EvaluationContext)processingContext.getContext().getVariables().get((Object)"thymeleafEvaluationContext");
        if (evaluationContext != null) {
            return evaluationContext.getTypeConverter();
        }
        return null;
    }
}

