/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.FileFilter;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassScaner {
    private static FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return ClassScaner.isClass(pathname.getName()) || pathname.isDirectory() || ClassScaner.isJarFile(pathname);
        }
    };

    private ClassScaner() {
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, final Class<? extends Annotation> annotationClass) {
        return ClassScaner.scanPackage(packageName, new Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> clazz) {
                return clazz.isAnnotationPresent(annotationClass);
            }
        });
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, final Class<?> superClass) {
        return ClassScaner.scanPackage(packageName, new Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> clazz) {
                return superClass.isAssignableFrom(clazz) && !superClass.equals(clazz);
            }
        });
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScaner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScaner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        if (StrUtil.isBlank(packageName)) {
            packageName = "";
        }
        packageName = ClassScaner.getWellFormedPackageName(packageName);
        HashSet classes = new HashSet();
        Set<String> classPaths = ClassUtil.getClassPaths(packageName);
        for (String classPath : classPaths) {
            classPath = URLUtil.decode(classPath, CharsetUtil.systemCharsetName());
            ClassScaner.fillClasses(classPath, packageName, classFilter, classes);
        }
        if (classes.isEmpty()) {
            String[] javaClassPaths;
            for (String classPath : javaClassPaths = ClassUtil.getJavaClassPaths()) {
                classPath = URLUtil.decode(classPath, CharsetUtil.systemCharsetName());
                ClassScaner.fillClasses(classPath, new File(classPath), packageName, classFilter, classes);
            }
        }
        return classes;
    }

    private static String getWellFormedPackageName(String packageName) {
        return packageName.lastIndexOf(".") != packageName.length() - 1 ? packageName + "." : packageName;
    }

    private static void fillClasses(String path, String packageName, Filter<Class<?>> classFilter, Set<Class<?>> classes) {
        int index = path.lastIndexOf(".jar!");
        if (index != -1) {
            path = path.substring(0, index + ".jar".length());
            path = StrUtil.removePrefix(path, "file:");
            ClassScaner.processJarFile(new File(path), packageName, classFilter, classes);
        } else {
            ClassScaner.fillClasses(path, new File(path), packageName, classFilter, classes);
        }
    }

    private static void fillClasses(String classPath, File file, String packageName, Filter<Class<?>> classFilter, Set<Class<?>> classes) {
        if (file.isDirectory()) {
            ClassScaner.processDirectory(classPath, file, packageName, classFilter, classes);
        } else if (ClassScaner.isClassFile(file)) {
            ClassScaner.processClassFile(classPath, file, packageName, classFilter, classes);
        } else if (ClassScaner.isJarFile(file)) {
            ClassScaner.processJarFile(file, packageName, classFilter, classes);
        }
    }

    private static void processDirectory(String classPath, File directory, String packageName, Filter<Class<?>> classFilter, Set<Class<?>> classes) {
        for (File file : directory.listFiles(fileFilter)) {
            ClassScaner.fillClasses(classPath, file, packageName, classFilter, classes);
        }
    }

    private static void processClassFile(String classPath, File file, String packageName, Filter<Class<?>> classFilter, Set<Class<?>> classes) {
        if (!classPath.endsWith(File.separator)) {
            classPath = classPath + File.separator;
        }
        String path = file.getAbsolutePath();
        if (StrUtil.isEmpty(packageName)) {
            path = StrUtil.removePrefix(path, classPath);
        }
        String filePathWithDot = path.replace(File.separator, ".");
        int subIndex = -1;
        subIndex = filePathWithDot.indexOf(packageName);
        if (subIndex != -1) {
            int endIndex = filePathWithDot.lastIndexOf(".class");
            String className = filePathWithDot.substring(subIndex, endIndex);
            ClassScaner.fillClass(className, packageName, classes, classFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJarFile(File file, String packageName, Filter<Class<?>> classFilter, Set<Class<?>> classes) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            for (JarEntry entry : Collections.list(jarFile.entries())) {
                if (!ClassScaner.isClass(entry.getName())) continue;
                String className = entry.getName().replace("/", ".").replace(".class", "");
                ClassScaner.fillClass(className, packageName, classes, classFilter);
            }
        }
        catch (Exception ex) {
            try {
                Console.error(ex, ex.getMessage(), new Object[0]);
            }
            catch (Throwable throwable) {
                IoUtil.close(jarFile);
                throw throwable;
            }
            IoUtil.close(jarFile);
        }
        IoUtil.close(jarFile);
    }

    private static void fillClass(String className, String packageName, Set<Class<?>> classes, Filter<Class<?>> classFilter) {
        if (className.startsWith(packageName)) {
            try {
                Class<?> clazz = Class.forName(className, false, ClassUtil.getClassLoader());
                if (classFilter == null || classFilter.accept(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    private static boolean isClassFile(File file) {
        return ClassScaner.isClass(file.getName());
    }

    private static boolean isClass(String fileName) {
        return fileName.endsWith(".class");
    }

    private static boolean isJarFile(File file) {
        return file.getName().endsWith(".jar");
    }
}

