/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.WorkbookUtil;
import java.io.File;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BigExcelWriter
extends ExcelWriter {
    public static final int DEFAULT_WINDOW_SIZE = 100;

    public BigExcelWriter() {
        this(100);
    }

    public BigExcelWriter(int rowAccessWindowSize) {
        this(WorkbookUtil.createSXSSFBook(rowAccessWindowSize), null);
    }

    public BigExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public BigExcelWriter(int rowAccessWindowSize, String sheetName) {
        this(WorkbookUtil.createSXSSFBook(rowAccessWindowSize), sheetName);
    }

    public BigExcelWriter(String destFilePath, String sheetName) {
        this(FileUtil.file((String)destFilePath), sheetName);
    }

    public BigExcelWriter(File destFile) {
        this(destFile, null);
    }

    public BigExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? WorkbookUtil.createSXSSFBook(destFile) : WorkbookUtil.createSXSSFBook(), sheetName);
        this.destFile = destFile;
    }

    public BigExcelWriter(SXSSFWorkbook workbook, String sheetName) {
        this(WorkbookUtil.getOrCreateSheet((Workbook)workbook, sheetName));
    }

    public BigExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        ((SXSSFWorkbook)this.workbook).dispose();
        super.closeWithoutFlush();
    }
}

