/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.audience;

import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.push.model.audience.AudienceTarget;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Audience
implements PushModel {
    private static final String ALL = "all";
    private final boolean all;
    private final Set<AudienceTarget> targets;

    private Audience(boolean all, Set<AudienceTarget> targets) {
        this.all = all;
        this.targets = targets;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Audience all() {
        return Audience.newBuilder().setAll(true).build();
    }

    public static Audience tag(String ... tagValue) {
        AudienceTarget target = AudienceTarget.tag(tagValue);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag(Collection<String> tagValues) {
        AudienceTarget target = AudienceTarget.tag(tagValues);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag_and(String ... tagValue) {
        AudienceTarget target = AudienceTarget.tag_and(tagValue);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag_and(Collection<String> tagValues) {
        AudienceTarget target = AudienceTarget.tag_and(tagValues);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag_not(String ... tagValue) {
        AudienceTarget target = AudienceTarget.tag_not(tagValue);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag_not(Collection<String> tagValues) {
        AudienceTarget target = AudienceTarget.tag_not(tagValues);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience alias(String ... alias) {
        AudienceTarget target = AudienceTarget.alias(alias);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience alias(Collection<String> aliases) {
        AudienceTarget target = AudienceTarget.alias(aliases);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience segment(String ... segment) {
        AudienceTarget target = AudienceTarget.segment(segment);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience segment(Collection<String> segments) {
        AudienceTarget target = AudienceTarget.segment(segments);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience registrationId(String ... registrationId) {
        AudienceTarget target = AudienceTarget.registrationId(registrationId);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience registrationId(Collection<String> registrationIds) {
        AudienceTarget target = AudienceTarget.registrationId(registrationIds);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience abTest(String ... abTestId) {
        AudienceTarget target = AudienceTarget.abTest(abTestId);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience abTest(Collection<String> abTestIds) {
        AudienceTarget target = AudienceTarget.abTest(abTestIds);
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public boolean isAll() {
        return this.all;
    }

    @Override
    public JsonElement toJSON() {
        if (this.all) {
            return new JsonPrimitive(ALL);
        }
        JsonObject json = new JsonObject();
        if (null != this.targets) {
            for (AudienceTarget target : this.targets) {
                json.add(target.getAudienceTypeValue(), target.toJSON());
            }
        }
        return json;
    }

    public static class Builder {
        private boolean all = false;
        private Set<AudienceTarget> audienceBuilder = null;

        public Builder setAll(boolean all) {
            this.all = all;
            return this;
        }

        public Builder addAudienceTarget(AudienceTarget target) {
            if (null == this.audienceBuilder) {
                this.audienceBuilder = new HashSet<AudienceTarget>();
            }
            this.audienceBuilder.add(target);
            return this;
        }

        public Audience build() {
            Preconditions.checkArgument((!this.all || null == this.audienceBuilder ? 1 : 0) != 0, (Object)"If audience is all, no any other audience may be set.");
            Preconditions.checkArgument((this.all || null != this.audienceBuilder ? 1 : 0) != 0, (Object)"No any audience target is set.");
            return new Audience(this.all, this.audienceBuilder);
        }
    }
}

