/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.loadbalancer;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.balancer.NacosBalancer;
import com.alibaba.cloud.nacos.util.InetIPv6Utils;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class NacosLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(NacosLoadBalancer.class);
    private final String serviceId;
    private ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private static final String IPV4_REGEX = "((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}";
    private static final String IPV6_KEY = "IPv6";
    public static String ipv6;
    @Autowired
    private InetIPv6Utils inetIPv6Utils;

    @PostConstruct
    public void init() {
        String ip = this.nacosDiscoveryProperties.getIp();
        ipv6 = StringUtils.isNotEmpty((CharSequence)ip) ? (Pattern.matches(IPV4_REGEX, ip) ? this.nacosDiscoveryProperties.getMetadata().get(IPV6_KEY) : ip) : this.inetIPv6Utils.findIPv6Address();
    }

    private List<ServiceInstance> filterInstanceByIpType(List<ServiceInstance> instances) {
        if (StringUtils.isNotEmpty((CharSequence)ipv6)) {
            ArrayList<ServiceInstance> ipv6InstanceList = new ArrayList<ServiceInstance>();
            for (ServiceInstance instance2 : instances) {
                if (Pattern.matches(IPV4_REGEX, instance2.getHost())) {
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)instance2.getMetadata().get(IPV6_KEY)))) continue;
                    ipv6InstanceList.add(instance2);
                    continue;
                }
                ipv6InstanceList.add(instance2);
            }
            if (ipv6InstanceList.size() == 0) {
                return instances.stream().filter(instance -> Pattern.matches(IPV4_REGEX, instance.getHost())).collect(Collectors.toList());
            }
            return ipv6InstanceList;
        }
        return instances.stream().filter(instance -> Pattern.matches(IPV4_REGEX, instance.getHost())).collect(Collectors.toList());
    }

    public NacosLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.serviceId = serviceId;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(this::getInstanceResponse);
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            log.warn("No servers available for service: " + this.serviceId);
            return new EmptyResponse();
        }
        try {
            String clusterName = this.nacosDiscoveryProperties.getClusterName();
            List<Object> instancesToChoose = serviceInstances;
            if (StringUtils.isNotBlank((CharSequence)clusterName)) {
                List sameClusterInstances = serviceInstances.stream().filter(serviceInstance -> {
                    String cluster = (String)serviceInstance.getMetadata().get("nacos.cluster");
                    return StringUtils.equals((CharSequence)cluster, (CharSequence)clusterName);
                }).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sameClusterInstances)) {
                    instancesToChoose = sameClusterInstances;
                }
            } else {
                log.warn("A cross-cluster call occurs\uff0cname = {}, clusterName = {}, instance = {}", new Object[]{this.serviceId, clusterName, serviceInstances});
            }
            instancesToChoose = this.filterInstanceByIpType(instancesToChoose);
            ServiceInstance instance = NacosBalancer.getHostByRandomWeight3(instancesToChoose);
            return new DefaultResponse(instance);
        }
        catch (Exception e) {
            log.warn("NacosLoadBalancer error", (Throwable)e);
            return null;
        }
    }
}

