/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec;

import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.codec.request.RequestEntityDecoder;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.server.codec.registry.RequestDataDecodeRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;

public class DefaultRequestEntityDecoder
implements RequestEntityDecoder<ByteBuf, ClusterRequest> {
    public ClusterRequest decode(ByteBuf source) {
        if (source.readableBytes() >= 5) {
            int xid = source.readInt();
            byte type = source.readByte();
            EntityDecoder<ByteBuf, Object> dataDecoder = RequestDataDecodeRegistry.getDecoder(type);
            if (dataDecoder == null) {
                RecordLog.warn((String)"Unknown type of request data decoder: {}", (Object[])new Object[]{(int)type});
                return null;
            }
            Object data = source.readableBytes() == 0 ? null : dataDecoder.decode((Object)source);
            return new ClusterRequest(xid, (int)type, data);
        }
        return null;
    }
}

