/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.cache.ConcurrentDiskUtil;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DiskCache {
    public static void write(ServiceInfo dom, String dir) {
        try {
            DiskCache.makeSureCacheDirExists(dir);
            File file = new File(dir, dom.getKeyEncoded());
            if (!(file.exists() || file.createNewFile() || file.exists())) {
                throw new IllegalStateException("failed to create cache file");
            }
            StringBuilder keyContentBuffer = new StringBuilder("");
            String json = dom.getJsonFromServer();
            if (StringUtils.isEmpty(json)) {
                json = JSON.toJSONString((Object)dom);
            }
            keyContentBuffer.append(json);
            ConcurrentDiskUtil.writeFileContent(file, keyContentBuffer.toString(), Charset.defaultCharset().toString());
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to write cache for dom:" + dom.getName(), e);
        }
    }

    public static String getLineSeperator() {
        String lineSeparator = System.getProperty("line.separator");
        return lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ServiceInfo> read(String cacheDir) {
        HashMap<String, ServiceInfo> domMap = new HashMap<String, ServiceInfo>(16);
        BufferedReader reader = null;
        try {
            File[] files = DiskCache.makeSureCacheDirExists(cacheDir).listFiles();
            if (files == null) {
                return domMap;
            }
            for (File file : files) {
                String fileName;
                if (!file.isFile() || (fileName = URLDecoder.decode(file.getName(), "UTF-8")).endsWith("@@meta") || fileName.endsWith("@@special-url")) continue;
                ServiceInfo dom = new ServiceInfo(fileName);
                ArrayList<Object> ips = new ArrayList<Object>();
                dom.setHosts(ips);
                ServiceInfo newFormat = null;
                try {
                    String json;
                    String dataString = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
                    reader = new BufferedReader(new StringReader(dataString));
                    while ((json = reader.readLine()) != null) {
                        try {
                            if (!json.startsWith("{") || !StringUtils.isEmpty((newFormat = (ServiceInfo)JSON.parseObject((String)json, ServiceInfo.class)).getName())) continue;
                            ips.add(JSON.parseObject((String)json, Instance.class));
                        }
                        catch (Throwable e) {
                            LogUtils.NAMING_LOGGER.error("[NA] error while parsing cache file: " + json, e);
                        }
                    }
                }
                catch (Exception e) {
                    LogUtils.NAMING_LOGGER.error("[NA] failed to read cache for dom: " + file.getName(), (Throwable)e);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                if (newFormat != null && !StringUtils.isEmpty(newFormat.getName()) && !CollectionUtils.isEmpty(newFormat.getHosts())) {
                    domMap.put(dom.getKey(), newFormat);
                    continue;
                }
                if (CollectionUtils.isEmpty(dom.getHosts())) continue;
                domMap.put(dom.getKey(), dom);
            }
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to read cache file", e);
        }
        return domMap;
    }

    private static File makeSureCacheDirExists(String dir) {
        File cacheDir = new File(dir);
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IllegalStateException("failed to create cache dir: " + dir);
        }
        return cacheDir;
    }
}

