/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.util.ObjectUtils;

public abstract class AnnotatedBeanDefinitionRegistryUtils {
    private static final Log logger = LogFactory.getLog(AnnotatedBeanDefinitionRegistryUtils.class);

    public static void registerBeans(BeanDefinitionRegistry registry, Class<?> ... annotatedClasses) {
        if (ObjectUtils.isEmpty((Object[])annotatedClasses)) {
            return;
        }
        boolean debugEnabled = logger.isDebugEnabled();
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        if (debugEnabled) {
            logger.debug((Object)(registry.getClass().getSimpleName() + " will register annotated classes : " + Arrays.asList(annotatedClasses) + " ."));
        }
        reader.register((Class[])annotatedClasses);
    }

    public static int scanBasePackages(BeanDefinitionRegistry registry, String ... basePackages) {
        int count = 0;
        if (!ObjectUtils.isEmpty((Object[])basePackages)) {
            boolean debugEnabled = logger.isDebugEnabled();
            if (debugEnabled) {
                logger.debug((Object)(registry.getClass().getSimpleName() + " will scan base packages " + Arrays.asList(basePackages) + "."));
            }
            List<String> registeredBeanNames = Arrays.asList(registry.getBeanDefinitionNames());
            ClassPathBeanDefinitionScanner classPathBeanDefinitionScanner = new ClassPathBeanDefinitionScanner(registry);
            count = classPathBeanDefinitionScanner.scan(basePackages);
            ArrayList<String> scannedBeanNames = new ArrayList<String>(count);
            scannedBeanNames.addAll(Arrays.asList(registry.getBeanDefinitionNames()));
            scannedBeanNames.removeAll(registeredBeanNames);
            if (debugEnabled) {
                logger.debug((Object)("The Scanned Components[ count : " + count + "] under base packages " + Arrays.asList(basePackages) + " : "));
            }
            for (String scannedBeanName : scannedBeanNames) {
                BeanDefinition scannedBeanDefinition = registry.getBeanDefinition(scannedBeanName);
                if (!debugEnabled) continue;
                logger.debug((Object)("Component [ name : " + scannedBeanName + " , class : " + scannedBeanDefinition.getBeanClassName() + " ]"));
            }
        }
        return count;
    }
}

