/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.message.DataMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RecordsCache {
    private int maxRecordsCached = 10240;
    private int maxTxnsBatched = 10240;
    private int maxRecordsBatched = 1024;
    private long maxTimeoutBatched = 500L;
    private boolean inTransaction = false;
    private List<DataMessage.Record> readyRecords;
    private long numOfTxnsInReadyRecords;
    long messageId;
    private DataMessage cachedMessage;
    private List<DataMessage.Record> records = new ArrayList<DataMessage.Record>();
    private long lastFetchedTime;

    public RecordsCache(DRCConfig config) {
        this.readyRecords = new ArrayList<DataMessage.Record>();
        this.lastFetchedTime = System.currentTimeMillis();
        this.maxRecordsCached = config.getMaxRecordsPerTxn();
        this.maxRecordsBatched = config.getMaxRecordsBatched();
        this.maxTimeoutBatched = config.getMaxTimeoutBatched();
        this.maxTxnsBatched = config.getMaxTxnsBatched();
        this.messageId = 0L;
        this.numOfTxnsInReadyRecords = 0L;
    }

    public void setMaxRecordsCached(int count) {
        this.maxRecordsCached = count;
    }

    public void setmaxRecordsBatched(int count) {
        this.maxRecordsBatched = count;
    }

    public void setMaxTxnsBatched(int count) {
        this.maxTxnsBatched = count;
    }

    public void setmaxTimeoutBatched(long timeout) {
        this.maxTimeoutBatched = timeout;
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public void setInTransaction(boolean txn) {
        this.inTransaction = txn;
    }

    public boolean isReady() {
        if (this.readyRecords.size() >= this.maxRecordsBatched || this.numOfTxnsInReadyRecords >= (long)this.maxTxnsBatched) {
            return true;
        }
        long now = System.currentTimeMillis();
        return !this.readyRecords.isEmpty() && now - this.lastFetchedTime >= this.maxTimeoutBatched;
    }

    public DataMessage getReadyRecords() {
        this.cachedMessage = new DataMessage();
        this.cachedMessage.setId(this.messageId++);
        for (DataMessage.Record r : this.readyRecords) {
            this.cachedMessage.addRecord(r);
        }
        this.readyRecords.clear();
        this.numOfTxnsInReadyRecords = 0L;
        this.lastFetchedTime = System.currentTimeMillis();
        return this.cachedMessage;
    }

    public void addRecord(DataMessage.Record r) throws IOException {
        switch (r.getOpt()) {
            case HEARTBEAT: {
                if (!this.inTransaction) {
                    this.readyRecords.add(r);
                    break;
                }
                this.records.add(r);
                break;
            }
            case BEGIN: {
                if (this.inTransaction) {
                    this.records.clear();
                }
                this.records.add(r);
                this.inTransaction = true;
                break;
            }
            case COMMIT: 
            case ROLLBACK: {
                if (!this.inTransaction) {
                    this.records.clear();
                    break;
                }
                this.inTransaction = false;
                this.records.add(r);
                this.readyRecords.addAll(this.records);
                ++this.numOfTxnsInReadyRecords;
                this.records.clear();
                break;
            }
            case INSERT: 
            case DELETE: 
            case UPDATE: 
            case REPLACE: {
                if (!this.inTransaction) {
                    this.records.clear();
                    break;
                }
                this.records.add(r);
                if (this.records.size() < this.maxRecordsCached) break;
                this.readyRecords.addAll(this.records);
                this.records.clear();
                break;
            }
            default: {
                if (this.inTransaction) {
                    this.records.add(r);
                    break;
                }
                this.readyRecords.add(r);
            }
        }
    }
}

