/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.enums.ConnType;
import alibaba.drcnet.impl.DRCNETClientImpl;
import alibaba.drcnet.util.DRCNetMessageInfo;
import alibaba.drcnet.util.ServerTokenAuthTool;
import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.HttpBadResponseException;
import com.aliyun.drc.client.impl.Checkpoint;
import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.impl.HttpHandler;
import com.aliyun.drc.client.impl.RegionResp;
import com.aliyun.drc.client.impl.StoreResp;
import com.aliyun.drc.client.impl.TokenResp;
import com.aliyun.drc.client.impl.TopicsResp;
import com.aliyun.drc.client.impl.TypeResp;
import com.aliyun.drc.client.message.Message;
import com.aliyun.drc.utils.DefaultServerAuthTool;
import com.aliyun.drc.utils.NetUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

class ServerProxy {
    private String url;
    private HttpHandler handler;
    private DRCNETClientImpl drcNetHandler = null;
    private DRCNetMessageInfo messageInfo = null;
    private final Queue<Message> priorMessages;
    private DRCConfig drcConfig;
    public static final String DEFAULT_URL_ENCODING = "UTF-8";

    ServerProxy(String url, DRCConfig drcConfig) {
        this.url = url;
        this.drcConfig = drcConfig;
        this.handler = new HttpHandler(this.url, drcConfig.getUseHTTPS());
        this.priorMessages = new LinkedList<Message>();
    }

    void setSocketTimeout(int timeout) {
        this.handler.setSocketTimeout(timeout);
    }

    void setConnectionTimeout(int timeout) {
        this.handler.setConnectionTimeout(timeout);
    }

    final void addParam(String key, String value) {
        this.handler.addFormParam(key, value);
    }

    final void addParams(Map<String, String> props) {
        for (Map.Entry<String, String> kv : props.entrySet()) {
            this.addParam(kv.getKey(), kv.getValue());
        }
    }

    final boolean hasRequired(String parameterName) {
        boolean found = false;
        for (NameValuePair param : this.handler.getFormParams()) {
            if (!param.getName().equalsIgnoreCase(parameterName)) continue;
            found = true;
        }
        return found;
    }

    final String getUrl() {
        return this.url;
    }

    final void sendRequest(boolean decorated) throws HttpBadResponseException, IOException {
        try {
            if (decorated) {
                this.handler.sendEncodedRequest();
            } else {
                this.handler.sendPlainRequest();
            }
        }
        catch (HttpBadResponseException he) {
            throw he;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private boolean needEncodingForDRCNet(String keyName) {
        return StringUtils.equalsIgnoreCase((CharSequence)keyName, (CharSequence)"password") || StringUtils.equalsIgnoreCase((CharSequence)keyName, (CharSequence)"username") || StringUtils.equalsIgnoreCase((CharSequence)keyName, (CharSequence)"group");
    }

    void conncetToDrcNetServer(String ip, String port, int connctionTimeOut) throws IOException, DRCClientException {
        byte[] connectResponse = this.handler.recv();
        if (connectResponse == null) {
            throw new DRCClientException("get drcnet failed from server");
        }
        if (connectResponse.length > 10) {
            throw new DRCClientException("get drcnet failed from server: " + new String(connectResponse));
        }
        this.handler.close();
        int drcNetPort = Integer.parseInt(new String(connectResponse).replaceAll("[^0-9\\.]", ""));
        if (drcNetPort <= 0 || drcNetPort > 65535) {
            throw new DRCClientException("get drcnet failed from server: " + drcNetPort);
        }
        if (this.drcNetHandler == null) {
            this.drcNetHandler = new DRCNETClientImpl();
        } else {
            this.drcNetHandler.stopDRCNet();
            this.drcNetHandler = new DRCNETClientImpl();
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        List<NameValuePair> params = this.handler.getFormParams();
        if (params != null) {
            for (NameValuePair pair : params) {
                if (this.needEncodingForDRCNet(pair.getName())) {
                    userMap.put(pair.getName(), URLEncoder.encode(pair.getValue(), DEFAULT_URL_ENCODING));
                    continue;
                }
                userMap.put(pair.getName(), pair.getValue());
            }
        }
        DRCNetConfig drcNetConfig = new DRCNetConfig();
        ConnType connType = ConnType.OLD_WAY_CONN;
        if (userMap.get("drcnet.encrypt") != null && ((String)userMap.get("drcnet.encrypt")).equalsIgnoreCase("true")) {
            DefaultServerAuthTool authTool = new DefaultServerAuthTool();
            drcNetConfig.setServerTokenAuthTool((ServerTokenAuthTool)authTool);
            drcNetConfig.setClientAuthString(DefaultServerAuthTool.clientAuthToken);
            drcNetConfig.setClientAuthStringLen(DefaultServerAuthTool.clientAuthToken.length);
            drcNetConfig.setExtendString(DefaultServerAuthTool.extendInfo);
            drcNetConfig.setExtendStringLen(DefaultServerAuthTool.extendInfo.length);
            connType = ConnType.SINGLE_WITHID_ENCRYPT_CONN;
        }
        if (this.drcNetHandler.startDRCNet(ip, String.valueOf(drcNetPort), connType, drcNetConfig, userMap, connctionTimeOut) != 0) {
            throw new DRCClientException("start drcnet failed " + ip + ":" + port);
        }
        if (this.messageInfo == null) {
            this.messageInfo = new DRCNetMessageInfo();
        }
        if (this.messageInfo == null) {
            throw new DRCClientException("get drcnet message info failed");
        }
    }

    final Message getDrcNetResponse(boolean usebinary) throws Exception {
        Message priorMessage = this.priorMessages.poll();
        if (priorMessage != null) {
            return priorMessage;
        }
        int readRet = this.drcNetHandler.readMsg(this.messageInfo);
        if (readRet != 0) {
            throw new Exception("read drcnet failed, server shutdown");
        }
        try {
            if (usebinary) {
                if (this.messageInfo.bufLen == 0L) {
                    readRet = this.drcNetHandler.readMsg(this.messageInfo);
                    if (readRet != 0) {
                        throw new Exception("read drcnet failed, server shutdown");
                    }
                    readRet = this.drcNetHandler.readMsg(this.messageInfo);
                    if (readRet != 0) {
                        throw new Exception("read drcnet failed, server shutdown");
                    }
                }
                priorMessage = this.handler.recvDRCNetBinaryResponse(this.messageInfo.buf, this.drcConfig);
            } else {
                priorMessage = this.handler.recvDRCNetTextResponse(this.messageInfo.buf, this.drcConfig);
            }
        }
        catch (Exception e) {
            Exception toThrow = new Exception("raw buf:" + new String(this.messageInfo.buf), e.getCause());
            toThrow.setStackTrace(e.getStackTrace());
            throw toThrow;
        }
        return priorMessage;
    }

    final Message getResponse(boolean useBinary) throws Exception, DRCClientException {
        Message priorMessage = this.priorMessages.poll();
        if (priorMessage != null) {
            return priorMessage;
        }
        priorMessage = useBinary ? this.handler.recvDRCPBinaryResponse(this.drcConfig) : this.handler.recvDRCPResponse(this.drcConfig);
        if (priorMessage == null) {
            throw new DRCClientException("Get null message, server may shutdown.");
        }
        return priorMessage;
    }

    final boolean setResponse(Message message) {
        return this.priorMessages.offer(message);
    }

    public static final boolean askIfCm(String url, DRCConfig drcConfig) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/status.taobao";
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
            String line = reader.readLine();
            client.close();
            if (line.equals("success & ok")) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static final TokenResp askToken(String url, String consumer, String password, DRCConfig drcConfig) throws IOException, HttpBadResponseException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/auth?consumer=" + URLEncoder.encode(consumer, DEFAULT_URL_ENCODING) + "&password=" + URLEncoder.encode(password, DEFAULT_URL_ENCODING);
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
        ObjectMapper mapper = new ObjectMapper();
        TokenResp response = (TokenResp)mapper.readValue(resp.getEntity().getContent(), TokenResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void askRegionInfo(String url, DRCConfig drcConfig, String subTopic) throws UnsupportedEncodingException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/region/id?subTopic=" + URLEncoder.encode(subTopic, DEFAULT_URL_ENCODING);
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            ObjectMapper mapper = new ObjectMapper();
            RegionResp response = (RegionResp)mapper.readValue(resp.getEntity().getContent(), RegionResp.class);
            drcConfig.setRegionId(response.getRegionId());
        }
        catch (IOException e) {
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {}
        }
    }

    public static final TopicsResp askTopics(String url, String db, String token, DRCConfig drcConfig) throws IOException, HttpBadResponseException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/list/" + db;
        HttpPost method = new HttpPost(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("token", token));
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
        ObjectMapper mapper = new ObjectMapper();
        TopicsResp response = (TopicsResp)mapper.readValue(resp.getEntity().getContent(), TopicsResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        if (response.getTopics().size() > 1) {
            throw new DRCClientException(db + " matches subtopics more than 1: " + response.getTopics());
        }
        return response;
    }

    public static final TypeResp askTopicType(String url, String topic, DRCConfig drcConfig) throws ClientProtocolException, IOException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/topic/query" + "?topic=" + URLEncoder.encode(topic, DEFAULT_URL_ENCODING);
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
        ObjectMapper mapper = new ObjectMapper();
        TypeResp response = (TypeResp)mapper.readValue(resp.getEntity().getContent(), TypeResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        return response;
    }

    public static final StoreResp askStore(String url, String subTopic, String token, DRCConfig drcConfig) throws IOException, HttpBadResponseException, DRCClientException {
        Checkpoint checkpoint = new Checkpoint(drcConfig.getCheckpoint());
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url + "/storehost/" + subTopic);
        httpPost.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("token", token));
        String cpStr = checkpoint.toString();
        String[] cpArray = cpStr.split(":", -1);
        String ip = cpArray[0];
        if (!StringUtils.isEmpty((CharSequence)ip) && ip.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+")) {
            long l = NetUtils.ipToLong(ip);
            cpStr = l + ":" + cpArray[1] + ":" + cpArray[2] + ":" + cpArray[3] + ":" + cpArray[4] + ":" + cpArray[5];
        }
        nvps.add(new BasicNameValuePair("checkpoint", cpStr));
        nvps.add(new BasicNameValuePair("filter", URLEncoder.encode(drcConfig.getDataFilter().toString(), "ISO-8859-1").toString()));
        if (drcConfig.isUsePublicIp()) {
            nvps.add(new BasicNameValuePair("publicIp", "true"));
        }
        if (drcConfig.getGuid() != null) {
            nvps.add(new BasicNameValuePair("guid", drcConfig.getGuid()));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF8"));
        CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
        ObjectMapper mapper = new ObjectMapper();
        StoreResp response = (StoreResp)mapper.readValue(resp.getEntity().getContent(), StoreResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new HttpBadResponseException(response.getErrCode(), response.getErrMsg());
        }
        return response;
    }

    final void close() {
        this.handler.close();
        if (this.drcNetHandler != null) {
            this.drcNetHandler.stopDRCNet();
        }
    }
}

