/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.client.message.ErrorMessage;
import com.aliyun.drc.client.message.Message;
import com.aliyun.drc.client.message.MonitorMessage;
import com.aliyun.drc.client.message.RedirectMessage;
import com.aliyun.drc.client.message.drcmessage.TextDecodeStateMachine;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;

public class Builder {
    private long id = 0L;
    private static final String message_id = "message_id";
    private static final String message_type = "message_type";
    private static final int data_type = 100;
    private static final int monitor_type = 200;
    private static final int redirect_type = 300;
    private static final int error_type = 400;
    private TextDecodeStateMachine textDrcodeMachine = new TextDecodeStateMachine();

    public Message buildBinaryBinlog(DataInputStream reader, DRCConfig drcConfig) throws IOException {
        DataMessage message = new DataMessage();
        message.setId(this.id++);
        message.setType(100);
        message.mergeFromBinary(reader, drcConfig);
        return message;
    }

    public Message buildDRCNetBinaryBinlog(byte[] buff, DRCConfig drcConfig) throws Exception {
        DataMessage message = new DataMessage();
        message.setId(this.id++);
        message.setType(100);
        message.mergeFromDrcNETBinary(buff, drcConfig);
        return message;
    }

    public Message buildDRCNetTextBinlog(byte[] buff, DRCConfig drcConfig) throws Exception {
        return this.textDrcodeMachine.runStateMachine(buff, drcConfig);
    }

    public Message build(DataInputStream reader, DRCConfig drcConfig) throws IOException {
        Message message;
        String line;
        HashMap<String, String> attr = new HashMap<String, String>();
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            String[] kv = line.split(":");
            if (kv.length != 2) {
                throw new IOException("Parse message attribute " + line + " error");
            }
            attr.put(kv[0], kv[1]);
        }
        if (line == null) {
            return null;
        }
        long id = Long.parseLong((String)attr.get(message_id));
        int type = Integer.parseInt((String)attr.get(message_type));
        switch (type) {
            case 100: {
                message = this.buildDataMessage(reader, id, type, drcConfig);
                break;
            }
            case 200: {
                message = this.buildMonitorMessage(reader, id, type);
                break;
            }
            case 300: {
                message = this.buildRedirectMessage(reader, id, type);
                break;
            }
            case 400: {
                message = this.buildErrorMessage(reader, id, type);
                break;
            }
            default: {
                throw new IOException("Unexpected message type " + type);
            }
        }
        message.addAttributes(attr);
        return message;
    }

    private ErrorMessage buildErrorMessage(DataInputStream reader, long id, int type) throws IOException {
        ErrorMessage message = new ErrorMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader);
        return message;
    }

    private RedirectMessage buildRedirectMessage(DataInputStream reader, long id, int type) throws IOException {
        RedirectMessage message = new RedirectMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader);
        return message;
    }

    private MonitorMessage buildMonitorMessage(DataInputStream reader, long id, int type) throws IOException {
        MonitorMessage message = new MonitorMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader);
        return message;
    }

    private DataMessage buildDataMessage(DataInputStream reader, long id, int type, DRCConfig drcConfig) throws IOException {
        DataMessage message = new DataMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader, drcConfig);
        return message;
    }
}

