/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import com.aliyun.drc.client.message.Message;
import java.io.DataInputStream;
import java.io.IOException;

public class ErrorMessage
extends Message {
    private String errCode;
    private String errMsg;

    public final String getCode() {
        return this.errCode;
    }

    public String getMessage() {
        return this.errMsg;
    }

    @Override
    void mergeFrom(DataInputStream in) throws IOException {
        String msg = in.readLine();
        if (msg == null || msg.isEmpty()) {
            throw new IOException("NULL or empty error message");
        }
        String[] errors = msg.split(" ");
        this.errCode = errors[0];
        this.errMsg = msg;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(this.errCode + " " + this.errMsg);
        builder.append(System.getProperty("line.separator"));
        return builder.toString();
    }
}

