/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message.drcmessage;

import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.impl.DRCClientRunTimeException;
import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.client.message.drcmessage.CIOUtil;
import com.aliyun.drc.client.message.drcmessage.VarAreaMessage;
import com.aliyun.drc.utils.BinaryMessageUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;

public class BinlogRecord
extends DataMessage.Record {
    private static final String DEFAULT_ENCODING = "ASCII";
    private static final String SEP = System.getProperty("line.separator");
    private static final int OLD_VERSION_2_HEADER_LEN = 88;
    private static final int NEW_VERSION_2_HEADER_LEN = 96;
    private static final int VERSION_3_HEADER_LEN = 104;
    private static final int PREFIX_LENGTH = 12;
    private int m_brVersion = -1;
    private int m_srcType = -1;
    private int m_op = -1;
    private int m_lastInLogevent = -1;
    private long m_srcCategory = -1L;
    private long m_id = -1L;
    private long m_timestamp = -1L;
    private long m_encoding = -1L;
    private long m_instanceOffset = -1L;
    private long m_timemarkOffset = -1L;
    private long m_dbNameOffset = -1L;
    private long m_tbNameOffset = -1L;
    private long m_colNamesOffset = -1L;
    private long m_colTypesOffset = -1L;
    private long m_fileNameOffset = -1L;
    private long m_fileOffset = -1L;
    private long m_oldColsOffset = -1L;
    private long m_newColsOffset = -1L;
    private long m_pkValOffset = -1L;
    private long m_pkKeysOffset = -1L;
    private long m_ukColsOffset = -1L;
    private long m_filterRuleValOffset = -1L;
    private long m_tailOffset = -1L;
    private long m_colsEncsOffset = -1L;
    private VarAreaMessage message = new VarAreaMessage();
    private static final long MAX_LONG = -1L;
    private static final int[] elementArray = new int[]{0, 1, 1, 2, 2, 4, 4, 8, 8};
    private static final int BYTE_SIZE = 1;
    private static final int INT_SIZE = 4;
    private final CRC32 crc32 = new CRC32();
    private boolean isCheckCRC = false;

    public BinlogRecord(boolean crcCheck) {
        this.isCheckCRC = crcCheck;
    }

    @Override
    public byte[] getRawData() {
        return this.message.getRawData();
    }

    @Override
    public void parse(byte[] data) throws IOException {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        this.parse(is);
    }

    public void parse(DataInputStream is) throws IOException {
        boolean idOldVersion2;
        this.message.parse(is);
        List bytes = this.message.getArray(0);
        byte[] bytesArray = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            bytesArray[i] = ((Integer)bytes.get(i)).byteValue();
        }
        switch (bytes.size()) {
            case 88: {
                idOldVersion2 = true;
                break;
            }
            case 96: 
            case 104: {
                idOldVersion2 = false;
                break;
            }
            default: {
                throw new IOException("Parsed bytes header size not recogonized: " + bytes.size());
            }
        }
        DataInputStream hs = new DataInputStream(new ByteArrayInputStream(bytesArray));
        this.m_brVersion = hs.readUnsignedByte();
        this.m_srcType = hs.readUnsignedByte();
        this.m_op = hs.readUnsignedByte();
        this.m_lastInLogevent = hs.readUnsignedByte();
        this.m_srcCategory = CIOUtil.readUnsignedInt(hs);
        this.m_id = CIOUtil.readLong(hs);
        this.m_timestamp = CIOUtil.readLong(hs);
        this.m_encoding = CIOUtil.readUnsignedInt(hs);
        this.m_instanceOffset = CIOUtil.readUnsignedInt(hs);
        this.m_timemarkOffset = CIOUtil.readUnsignedInt(hs);
        this.m_dbNameOffset = CIOUtil.readUnsignedInt(hs);
        this.m_tbNameOffset = CIOUtil.readUnsignedInt(hs);
        this.m_colNamesOffset = CIOUtil.readUnsignedInt(hs);
        this.m_colTypesOffset = CIOUtil.readUnsignedInt(hs);
        if (!idOldVersion2) {
            this.m_pkValOffset = CIOUtil.readUnsignedInt(hs);
            this.m_fileNameOffset = CIOUtil.readLong(hs);
            this.m_fileOffset = CIOUtil.readLong(hs);
            if (this.m_fileNameOffset < -1L || this.m_fileOffset < -1L) {
                throw new IOException("f: " + this.m_fileNameOffset + " and o: " + this.m_fileOffset + " should both be signed integer");
            }
            this.m_oldColsOffset = CIOUtil.readUnsignedInt(hs);
            this.m_newColsOffset = CIOUtil.readUnsignedInt(hs);
        } else {
            this.m_fileNameOffset = CIOUtil.readUnsignedInt(hs);
            this.m_fileOffset = CIOUtil.readUnsignedInt(hs);
            this.m_oldColsOffset = CIOUtil.readUnsignedInt(hs);
            this.m_newColsOffset = CIOUtil.readUnsignedInt(hs);
            this.m_pkValOffset = CIOUtil.readUnsignedInt(hs);
        }
        this.m_pkKeysOffset = CIOUtil.readUnsignedInt(hs);
        this.m_ukColsOffset = CIOUtil.readUnsignedInt(hs);
        if (this.m_brVersion > 1) {
            this.m_colsEncsOffset = CIOUtil.readLong(hs);
        }
        if (this.m_brVersion == 3) {
            this.m_filterRuleValOffset = CIOUtil.readUnsignedInt(hs);
            this.m_tailOffset = CIOUtil.readUnsignedInt(hs);
        }
        this.timestamp = Long.toString(this.m_timestamp);
        DataMessage.Record.Type type = DataMessage.Record.Type.valueOf(this.m_op);
        if (this.getDbType() == DBType.OCEANBASE1) {
            gloalSafeTimestamp.set(String.valueOf(this.m_fileNameOffset));
        } else {
            if (type == DataMessage.Record.Type.BEGIN) {
                gloalSafeTimestamp.set(this.timestamp);
                txEnd.set(false);
            }
            if (((Boolean)txEnd.get()).booleanValue()) {
                gloalSafeTimestamp.set(this.timestamp);
            }
            if (type == DataMessage.Record.Type.COMMIT || type == DataMessage.Record.Type.ROLLBACK) {
                txEnd.set(true);
            }
        }
        this.safeTimestamp = new String((String)gloalSafeTimestamp.get());
        if (this.isCheckCRC) {
            this.checkCRC();
        }
    }

    private void checkCRC() throws IOException {
        long value = this.getCRCValue();
        if (value == 0L) {
            return;
        }
        this.crc32.update(this.getRawData(), 0, this.getRawData().length - 4);
        long actual = this.crc32.getValue();
        this.crc32.reset();
        if (value != actual) {
            throw new IOException("crc 32 check failed,expect:" + value + ",actual:" + actual);
        }
    }

    public int getVersion() {
        return this.m_brVersion;
    }

    @Override
    public DBType getDbType() {
        switch (this.m_srcType) {
            case 0: {
                return DBType.MYSQL;
            }
            case 1: {
                return DBType.OCEANBASE;
            }
            case 2: {
                return DBType.HBASE;
            }
            case 3: {
                return DBType.ORACLE;
            }
            case 4: {
                return DBType.OCEANBASE1;
            }
        }
        return DBType.UNKNOWN;
    }

    @Override
    public boolean isQueryBack() {
        switch ((int)this.m_srcCategory) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isFirstInLogevent() {
        return this.m_lastInLogevent == 1;
    }

    @Override
    public void mergeFrom(DataInputStream is) throws IOException {
        this.parse(is);
    }

    @Override
    public DataMessage.Record.Type getOpt() {
        return DataMessage.Record.Type.valueOf(this.m_op);
    }

    @Override
    public String getId() {
        return Long.toString(this.m_id);
    }

    @Override
    public String getDbname() {
        try {
            if ((int)this.m_dbNameOffset < 0) {
                return null;
            }
            return this.message.getString((int)this.m_dbNameOffset, DEFAULT_ENCODING);
        }
        catch (IOException e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public final String getTablename() {
        try {
            if ((int)this.m_tbNameOffset < 0) {
                return null;
            }
            return this.message.getString((int)this.m_tbNameOffset, DEFAULT_ENCODING);
        }
        catch (IOException e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getCheckpoint() {
        return this.m_fileOffset + "@" + this.m_fileNameOffset;
    }

    @Override
    @Deprecated
    public String getMetadataVersion() {
        return "0";
    }

    @Override
    public String getServerId() {
        try {
            if ((int)this.m_instanceOffset < 0) {
                return null;
            }
            return this.message.getString((int)this.m_instanceOffset, DEFAULT_ENCODING);
        }
        catch (IOException e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    public List<ByteString> getFirstPKValue() {
        try {
            if ((int)this.m_pkValOffset < 0) {
                return null;
            }
            return this.message.getByteStringList((int)this.m_pkValOffset);
        }
        catch (IOException e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getPrimaryKeys() {
        try {
            if ((int)this.m_pkKeysOffset < 0) {
                return "";
            }
            List pks = this.message.getArray((int)this.m_pkKeysOffset);
            List<ByteString> names = this.message.getByteStringList(this.m_colNamesOffset);
            StringBuilder pkKeyName = new StringBuilder();
            if (pks != null) {
                Iterator iterator = pks.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (pkKeyName.length() != 0) {
                        pkKeyName.append(",");
                    }
                    pkKeyName.append(names.get(idx).toString(DEFAULT_ENCODING));
                }
            }
            return pkKeyName.toString();
        }
        catch (IOException e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getUniqueColNames() {
        try {
            if ((int)this.m_ukColsOffset < 0) {
                return "";
            }
            List uks = this.message.getArray((int)this.m_ukColsOffset);
            List<ByteString> names = this.message.getByteStringList(this.m_colNamesOffset);
            StringBuilder ukKeyName = new StringBuilder();
            if (uks != null) {
                Iterator iterator = uks.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (ukKeyName.length() != 0) {
                        ukKeyName.append(",");
                    }
                    ukKeyName.append(names.get(idx).toString(DEFAULT_ENCODING));
                }
            }
            return ukKeyName.toString();
        }
        catch (IOException e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public int getFieldCount() {
        return this.getFieldList().size();
    }

    @Override
    public List<DataMessage.Record.Field> getFieldList() {
        try {
            if (this.fields == null) {
                if (this.m_colNamesOffset < 0L || this.m_colTypesOffset < 0L || this.m_oldColsOffset < 0L || this.m_newColsOffset < 0L) {
                    return this.fields;
                }
                String encodingStr = BinaryMessageUtils.getString(this.getRawData(), (int)this.m_encoding, DEFAULT_ENCODING);
                List pks = null;
                if ((int)this.m_pkKeysOffset > 0) {
                    pks = BinaryMessageUtils.getArray(this.getRawData(), (int)this.m_pkKeysOffset);
                }
                ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])this.getRawData()).order(ByteOrder.LITTLE_ENDIAN);
                wrapByteBuf.readerIndex((int)(12L + this.m_colNamesOffset + 1L));
                int count = wrapByteBuf.readInt();
                this.fields = new ArrayList(count);
                wrapByteBuf.readerIndex(12 + (int)this.m_colTypesOffset);
                byte t = wrapByteBuf.readByte();
                int elementSize = elementArray[t & 0xF];
                int colEncodingsCount = 0;
                int currentEncodingOffset = 0;
                if (this.m_colsEncsOffset > 0L) {
                    wrapByteBuf.readerIndex((int)(12L + this.m_colsEncsOffset + 1L));
                    colEncodingsCount = wrapByteBuf.readInt();
                    currentEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                wrapByteBuf.readerIndex((int)(12L + this.m_colNamesOffset + 1L + 4L));
                int currentColNameOffset = (int)wrapByteBuf.readUnsignedInt();
                wrapByteBuf.readerIndex((int)(12L + this.m_oldColsOffset + 1L));
                int oldColCount = wrapByteBuf.readInt();
                int currentOldColOffset = -1;
                if (0 != oldColCount) {
                    currentOldColOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                wrapByteBuf.readerIndex((int)(12L + this.m_newColsOffset + 1L));
                int newColCount = wrapByteBuf.readInt();
                int currentNewColOffset = -1;
                if (0 != newColCount) {
                    currentNewColOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                for (int i = 0; i < count; ++i) {
                    ByteString value;
                    boolean isPk = false;
                    if (pks != null && pks.contains(i)) {
                        isPk = true;
                    }
                    int type = 0;
                    wrapByteBuf.readerIndex(12 + (int)this.m_colTypesOffset + 1 + 4 + i * elementSize);
                    switch (elementSize) {
                        case 1: {
                            type = wrapByteBuf.readUnsignedByte();
                            break;
                        }
                        case 2: {
                            type = wrapByteBuf.readUnsignedShort();
                            break;
                        }
                        case 4: {
                            type = (int)wrapByteBuf.readUnsignedInt();
                            break;
                        }
                        case 8: {
                            type = (int)wrapByteBuf.readLong();
                        }
                    }
                    String realEncoding = encodingStr;
                    wrapByteBuf.readerIndex((int)(12L + this.m_colsEncsOffset + 1L + 4L + (long)((i + 1) * 4)));
                    if (colEncodingsCount > 0) {
                        int nextEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
                        ByteString encodingByteString = new ByteString(wrapByteBuf.array(), 12 + currentEncodingOffset + 1 + 4 + (count + 1) * 4 + (int)this.m_colsEncsOffset, nextEncodingOffset - currentEncodingOffset - 1);
                        realEncoding = encodingByteString.toString();
                        if (realEncoding.isEmpty()) {
                            realEncoding = (type == 253 || type == 254) && DataMessage.Record.Field.MYSQL_TYPES[type] == DataMessage.Record.Field.Type.STRING ? "binary" : (DataMessage.Record.Field.MYSQL_TYPES[type] == DataMessage.Record.Field.Type.BLOB ? "" : (type == 245 ? "utf8mb4" : DEFAULT_ENCODING));
                        }
                        currentEncodingOffset = nextEncodingOffset;
                    }
                    if (!realEncoding.isEmpty() && type == DataMessage.Record.Field.Type.BLOB.ordinal()) {
                        type = 15;
                    }
                    wrapByteBuf.readerIndex((int)(12L + this.m_colNamesOffset + 1L + 4L + (long)((i + 1) * 4)));
                    int nextColNameOffset = (int)wrapByteBuf.readUnsignedInt();
                    ByteString ColNameByteString = new ByteString(wrapByteBuf.array(), 12 + currentColNameOffset + 1 + 4 + (count + 1) * 4 + (int)this.m_colNamesOffset, nextColNameOffset - currentColNameOffset - 1);
                    String columnName = ColNameByteString.toString();
                    currentColNameOffset = nextColNameOffset;
                    if (oldColCount != 0) {
                        wrapByteBuf.readerIndex((int)(12L + this.m_oldColsOffset + 1L + 4L + (long)((i + 1) * 4)));
                        int nextOldColOffset = (int)wrapByteBuf.readUnsignedInt();
                        value = null;
                        if (nextOldColOffset != currentOldColOffset) {
                            value = new ByteString(wrapByteBuf.array(), 12 + currentOldColOffset + 1 + 4 + (count + 1) * 4 + (int)this.m_oldColsOffset, nextOldColOffset - currentOldColOffset - 1);
                        }
                        this.fields.add(new DataMessage.Record.Field(columnName, type, realEncoding, value, isPk));
                        currentOldColOffset = nextOldColOffset;
                    }
                    if (newColCount == 0) continue;
                    wrapByteBuf.readerIndex((int)(12L + this.m_newColsOffset + 1L + 4L + (long)((i + 1) * 4)));
                    int nextNewColOffset = (int)wrapByteBuf.readUnsignedInt();
                    value = null;
                    if (currentNewColOffset != nextNewColOffset) {
                        value = new ByteString(wrapByteBuf.array(), 12 + currentNewColOffset + 1 + 4 + (count + 1) * 4 + (int)this.m_newColsOffset, nextNewColOffset - currentNewColOffset - 1);
                    }
                    this.fields.add(new DataMessage.Record.Field(columnName, type, realEncoding, value, isPk));
                    currentNewColOffset = nextNewColOffset;
                }
            }
        }
        catch (Exception e) {
            this.fields = null;
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
        return this.fields;
    }

    public List<Long> getTimemarks() throws IOException {
        if (this.m_timemarkOffset != -1L) {
            return this.message.getArray((int)this.m_timemarkOffset);
        }
        return null;
    }

    @Override
    public String getTraceId() throws IOException {
        List<ByteString> list = this.message.getByteStringList(this.m_filterRuleValOffset);
        if (list == null || list.size() == 0 || list.size() < 3) {
            return null;
        }
        ByteString traceId = list.get(2);
        return traceId == null ? null : traceId.toString();
    }

    private long getCRCValue() throws IOException {
        long crcValue = 0L;
        if (this.m_tailOffset == -1L) {
            return 0L;
        }
        List list = this.message.getArray((int)this.m_tailOffset);
        if (list == null || list.size() != 12) {
            return 0L;
        }
        crcValue += (long)((Integer)list.get(8)).intValue();
        crcValue += (long)((Integer)list.get(9)).intValue() << 8;
        crcValue += (long)((Integer)list.get(10)).intValue() << 16;
        return crcValue += (long)((Integer)list.get(11)).intValue() << 24;
    }

    @Override
    public String getThreadId() throws IOException {
        long threadId = 0L;
        if (this.m_tailOffset == -1L) {
            return null;
        }
        List list = this.message.getArray((int)this.m_tailOffset);
        if (list == null || list.size() == 0) {
            return null;
        }
        threadId += (long)((Integer)list.get(0)).intValue();
        threadId += (long)((Integer)list.get(1)).intValue() << 8;
        threadId += (long)((Integer)list.get(2)).intValue() << 16;
        return String.valueOf(threadId += (long)((Integer)list.get(3)).intValue() << 24);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parse(new DataInputStream(in));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type:" + (Object)((Object)this.getOpt())).append(SEP);
        builder.append("record_id:" + this.getId()).append(SEP);
        builder.append("db:" + this.getDbname()).append(SEP);
        builder.append("tb:" + this.getTablename()).append(SEP);
        builder.append("serverId:" + this.getServerId()).append(SEP);
        builder.append("checkpoint:" + this.getCheckpoint()).append(SEP);
        builder.append("primary_value:" + this.getPrimaryKeys()).append(SEP);
        builder.append("unique_keys:" + this.getUniqueColNames()).append(SEP);
        builder.append(SEP);
        this.getFieldList();
        if (null != this.fields) {
            for (DataMessage.Record.Field field : this.fields) {
                builder.append(field.toString());
            }
        }
        builder.append(SEP);
        return builder.toString();
    }
}

