/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message.drcmessage;

import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.message.DataMessage;
import java.util.List;
import java.util.Map;

public class DrcNETTextRecord
extends DataMessage.Record {
    public DrcNETTextRecord(List<DataMessage.Record.Field> listField, Map<String, String> attr) {
        this.attributes = attr;
        this.fields = listField;
    }

    @Override
    public void parse(byte[] data) throws Exception {
        block18: {
            String[] encodings;
            block19: {
                String stype = this.getAttribute("record_type");
                this.type = DataMessage.Record.Type.valueOf(stype.toUpperCase());
                if (this.type == null) {
                    this.type = DataMessage.Record.Type.UNKNOWN;
                }
                this.timestamp = this.getAttribute("timestamp");
                if (this.getDbType() == DBType.OCEANBASE1) {
                    if (this.type == DataMessage.Record.Type.HEARTBEAT) {
                        gloalSafeTimestamp.set(this.timestamp);
                    } else {
                        gloalSafeTimestamp.set(this.getCheckpoint().substring(2));
                    }
                } else {
                    if (this.type == DataMessage.Record.Type.BEGIN) {
                        gloalSafeTimestamp.set(this.timestamp);
                        txEnd.set(false);
                    }
                    if (((Boolean)txEnd.get()).booleanValue()) {
                        gloalSafeTimestamp.set(this.timestamp);
                    }
                    if (this.type == DataMessage.Record.Type.COMMIT || this.type == DataMessage.Record.Type.ROLLBACK) {
                        txEnd.set(true);
                    }
                }
                this.safeTimestamp = new String((String)gloalSafeTimestamp.get());
                String fieldsEncodings = this.getAttribute("fields_enc");
                if (fieldsEncodings == null || fieldsEncodings.isEmpty()) break block18;
                encodings = fieldsEncodings.split(",", -1);
                if (encodings.length != this.fields.size()) break block19;
                for (int i = 0; i < encodings.length; ++i) {
                    String enc = encodings[i];
                    DataMessage.Record.Field field = (DataMessage.Record.Field)this.fields.get(i);
                    if (enc.isEmpty()) {
                        if (field.getType() == DataMessage.Record.Field.Type.STRING) {
                            field.encoding = "binary";
                            continue;
                        }
                        if (field.getType() == DataMessage.Record.Field.Type.JSON) {
                            field.encoding = "utf8mb4";
                            continue;
                        }
                        field.encoding = "";
                        continue;
                    }
                    if (field.getType() == DataMessage.Record.Field.Type.BLOB) {
                        field.type = 15;
                    }
                    field.encoding = enc;
                }
                break block18;
            }
            if (encodings.length * 2 != this.fields.size()) break block18;
            for (int i = 0; i < encodings.length; ++i) {
                String enc = encodings[i];
                DataMessage.Record.Field field1 = (DataMessage.Record.Field)this.fields.get(i * 2);
                DataMessage.Record.Field field2 = (DataMessage.Record.Field)this.fields.get(i * 2 + 1);
                if (enc.isEmpty()) {
                    if (field1.getType() == DataMessage.Record.Field.Type.STRING) {
                        field1.encoding = "binary";
                        field2.encoding = "binary";
                        continue;
                    }
                    if (field1.getType() == DataMessage.Record.Field.Type.JSON) {
                        field1.encoding = "utf8mb4";
                        field2.encoding = "utf8mb4";
                        continue;
                    }
                    field1.encoding = "";
                    field2.encoding = "";
                    continue;
                }
                if (field1.getType() == DataMessage.Record.Field.Type.BLOB) {
                    field1.type = 15;
                    field2.type = 15;
                }
                field1.encoding = enc;
                field2.encoding = enc;
            }
        }
    }
}

