/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.utils;

import com.aliyun.drc.client.DataFilterBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataFilterUtil {
    public static void putColNames(String db, String tb, List<String> cols, DataFilterBase dataFilterBase) {
        if (tb == null) {
            return;
        }
        Map<String, Map<String, List<String>>> dbAndTablePair = dataFilterBase.getRequireMap();
        boolean founded = false;
        for (Map.Entry<String, Map<String, List<String>>> dbEntry : dbAndTablePair.entrySet()) {
            if (db != null && !db.equalsIgnoreCase(dbEntry.getKey())) continue;
            for (Map.Entry<String, List<String>> entry : dbEntry.getValue().entrySet()) {
                if (!tb.equalsIgnoreCase(entry.getKey())) continue;
                founded = true;
                entry.getValue().addAll(cols);
            }
            if (founded) continue;
            Map<String, List<String>> tabMap = dbEntry.getValue();
            tabMap.put(tb, cols);
            founded = true;
        }
        if (!founded) {
            HashMap<String, List<String>> tabMap = new HashMap<String, List<String>>();
            tabMap.put(tb, cols);
            dbAndTablePair.put(db, tabMap);
        }
    }

    public static List<String> getColNamesWithMapping(String db, String tb, DataFilterBase dataFilterBase) {
        if (tb == null) {
            return null;
        }
        Map<String, Map<String, List<String>>> dbAndTablePair = dataFilterBase.getReflectionMap();
        Map<String, List<String>> tableAndCols = dbAndTablePair.get(db);
        if (tableAndCols == null) {
            tableAndCols = new HashMap<String, List<String>>();
            List<String> cols = DataFilterUtil.getColNames(db, tb, dataFilterBase);
            tableAndCols.put(tb, cols);
            dbAndTablePair.put(db, tableAndCols);
            return cols;
        }
        List<String> needCols = tableAndCols.get(tb);
        if (needCols == null) {
            List<String> cols = DataFilterUtil.getColNames(db, tb, dataFilterBase);
            tableAndCols.put(tb, cols);
            return cols;
        }
        return needCols;
    }

    public static List<String> getColNames(String db, String tb, DataFilterBase dataFilterBase) {
        if (tb == null) {
            return null;
        }
        Map<String, Map<String, List<String>>> requireMap = dataFilterBase.getRequireMap();
        for (Map.Entry<String, Map<String, List<String>>> dbEntry : requireMap.entrySet()) {
            StringBuffer buf = new StringBuffer(dbEntry.getKey());
            DataFilterUtil.processStringToRegularExpress(buf);
            if (db != null && !db.toLowerCase().matches(buf.toString().toLowerCase())) continue;
            for (Map.Entry<String, List<String>> entry : dbEntry.getValue().entrySet()) {
                buf = new StringBuffer(entry.getKey());
                DataFilterUtil.processStringToRegularExpress(buf);
                if (!tb.toLowerCase().matches(buf.toString().toLowerCase())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static void processStringToRegularExpress(StringBuffer stringBuffer) {
        int index = 0;
        int beginIndex = 0;
        while (-1 != (index = stringBuffer.indexOf(".", beginIndex))) {
            stringBuffer.insert(index, '\\');
            beginIndex = index + 2;
        }
        index = 0;
        beginIndex = 0;
        while (-1 != (index = stringBuffer.indexOf("*", beginIndex))) {
            stringBuffer.insert(index, '.');
            beginIndex = index + 2;
        }
    }

    public static boolean isColInArray(String col, List<String> s) {
        for (int i = 0; i < s.size(); ++i) {
            if (!s.get(i).equals("*") && !col.equalsIgnoreCase(s.get(i))) continue;
            return true;
        }
        return false;
    }
}

