/*
 * Decompiled with CFR 0.152.
 */
package alibaba.drcnet.buffer;

import alibaba.drcnet.util.MessageBox;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBuff {
    private static final Logger log = LoggerFactory.getLogger(CacheBuff.class);
    BatchBuf[] cacheBuf = null;
    public BatchBuf writeBuf = null;
    public BatchBuf readBuf = null;
    int readIndex = 0;
    int writeIndex = 0;
    MessageBox messageBox = null;
    private volatile boolean stoped = false;
    static final int waitSlot = 1000000;

    public CacheBuff(MessageBox msgBox) {
        this.messageBox = msgBox;
    }

    public void setStop() {
        this.stoped = true;
    }

    public void initBuf(int length) {
        this.cacheBuf = new BatchBuf[2];
        this.cacheBuf[0] = new BatchBuf();
        this.cacheBuf[0].init(length);
        this.cacheBuf[1] = new BatchBuf();
        this.cacheBuf[1].init(length);
        this.writeBuf = this.cacheBuf[0];
        this.readBuf = this.cacheBuf[0];
        this.readIndex = 0;
        this.writeIndex = 0;
        this.stoped = false;
    }

    public int detectWriteable(int len) {
        if (this.stoped) {
            return -1;
        }
        if (this.writeBuf.leftLen >= len) {
            return this.writeBuf.writePos;
        }
        this.writeBuf.bufStat = BufStatus.FULL;
        int nextBufIndex = this.writeIndex ^ 1;
        while (true) {
            if (this.stoped) {
                return -1;
            }
            this.messageBox.Signal();
            this.cacheBuf[nextBufIndex].lock.lock();
            if (this.cacheBuf[nextBufIndex].bufStat == BufStatus.AVAILABLE) break;
            try {
                this.cacheBuf[nextBufIndex].cond.awaitNanos(1000000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.cacheBuf[nextBufIndex].lock.unlock();
        }
        this.cacheBuf[nextBufIndex].bufStat = BufStatus.WORKING;
        this.cacheBuf[nextBufIndex].lock.unlock();
        this.writeBuf = this.cacheBuf[nextBufIndex];
        this.cacheBuf[this.writeIndex].lock.lock();
        this.cacheBuf[this.writeIndex].cond.signal();
        this.cacheBuf[this.writeIndex].lock.unlock();
        this.writeIndex = nextBufIndex;
        return this.writeBuf.writePos;
    }

    public void putData(int len) {
        this.writeBuf.writePos += len;
        this.writeBuf.leftLen -= len;
        this.messageBox.Signal();
    }

    public int readData(byte[] buf, int len) {
        while (true) {
            int leftData;
            if ((leftData = this.readBuf.writePos - this.readBuf.readPos) >= len) {
                System.arraycopy(this.readBuf.buff, this.readBuf.readPos, buf, 0, len);
                this.readBuf.readPos += len;
                return len;
            }
            if (leftData != 0) {
                return -1;
            }
            if (this.readBuf.bufStat != BufStatus.FULL || this.readBuf.writePos != this.readBuf.readPos) break;
            this.readBuf.lock.lock();
            this.readBuf.reinitBatchBuf();
            this.readBuf.lock.unlock();
            int nextIndex = this.readIndex ^ 1;
            while (true) {
                if (this.stoped) {
                    return -1;
                }
                this.cacheBuf[nextIndex].lock.lock();
                if (this.cacheBuf[nextIndex].bufStat != BufStatus.AVAILABLE) break;
                try {
                    this.cacheBuf[nextIndex].cond.awaitNanos(1000000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.cacheBuf[nextIndex].lock.unlock();
            }
            this.readBuf = this.cacheBuf[nextIndex];
            this.cacheBuf[nextIndex].lock.unlock();
            this.cacheBuf[this.readIndex].lock.lock();
            this.cacheBuf[this.readIndex].cond.signal();
            this.cacheBuf[this.readIndex].lock.unlock();
            this.readIndex = nextIndex;
        }
        return 0;
    }

    public class BatchBuf {
        public Lock lock = null;
        public Condition cond = null;
        public int totalLen = 0;
        public volatile int leftLen = 0;
        public volatile int readPos = 0;
        public volatile int writePos = 0;
        public byte[] buff = null;
        public volatile BufStatus bufStat = BufStatus.AVAILABLE;

        void init(int length) {
            this.lock = new ReentrantLock();
            this.cond = this.lock.newCondition();
            this.totalLen = length;
            this.leftLen = length;
            this.readPos = 0;
            this.writePos = 0;
            log.warn("cache buf size is: " + length);
            this.buff = new byte[length];
            this.bufStat = BufStatus.AVAILABLE;
        }

        void reinitBatchBuf() {
            this.leftLen = this.totalLen;
            this.readPos = 0;
            this.writePos = 0;
            this.bufStat = BufStatus.AVAILABLE;
        }
    }

    public static enum BufStatus {
        AVAILABLE,
        WORKING,
        FULL;

    }
}

