/*
 * Decompiled with CFR 0.152.
 */
package alibaba.drcnet.decoder;

import alibaba.drcnet.decoder.Decoder;
import alibaba.drcnet.util.AesCrypto;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class lz4Decoder
implements Decoder {
    private static final Logger log = LoggerFactory.getLogger(lz4Decoder.class);
    private LZ4Factory lz4Factory = null;
    LZ4FastDecompressor lz4Decompressor = null;
    LZ4Compressor compressor = null;

    @Override
    public int initDecoder() {
        this.lz4Factory = LZ4Factory.fastestInstance();
        if (this.lz4Factory == null) {
            log.error("get lz4 factory failed");
            return -1;
        }
        this.lz4Decompressor = this.lz4Factory.fastDecompressor();
        if (this.lz4Decompressor == null) {
            log.error("get lz4 decompressor failed");
            return -1;
        }
        this.compressor = this.lz4Factory.fastCompressor();
        return 0;
    }

    @Override
    public int decoder(byte[] srcBuf, int srcBufOffset, byte[] dstBuf, int dstBufOffset, int totalLen) {
        System.arraycopy(srcBuf, srcBufOffset, dstBuf, dstBufOffset, totalLen);
        return totalLen;
    }

    @Override
    public int decoderWithCompress(byte[] srcBuf, int srcBufOffset, byte[] dstBuf, int dstBufOffset, int totalLen, int orgLen) {
        int decompressRet = this.lz4Decompressor.decompress(srcBuf, srcBufOffset, dstBuf, dstBufOffset, orgLen);
        if (decompressRet != totalLen) {
            log.error("decomprss failed, orglen: " + orgLen + ", decompress size len: " + totalLen + ", decomress ret: " + decompressRet);
            return -1;
        }
        return orgLen;
    }

    @Override
    public int decoderWithDecrypt(byte[] srcBuf, int srcBufOffset, byte[] dstBuf, int dstBufOffset, int totalLen, AesCrypto aesCrypto) {
        int decryptRet = aesCrypto.decrypt(srcBuf, srcBufOffset, totalLen);
        if (decryptRet != 0) {
            log.error("aes decrypt failed");
            return -1;
        }
        System.arraycopy(srcBuf, srcBufOffset, dstBuf, dstBufOffset, totalLen);
        return totalLen;
    }

    @Override
    public int decoderWithCompressAndDecrypt(byte[] srcBuf, int srcBufOffset, byte[] dstBuf, int dstBufOffset, int totalLen, int orgLen, AesCrypto aesCrypto) {
        int decryptRet = aesCrypto.decrypt(srcBuf, srcBufOffset, totalLen);
        if (decryptRet != 0) {
            log.error("aes decrypt failed");
            return -1;
        }
        int decompressRet = this.lz4Decompressor.decompress(srcBuf, srcBufOffset, dstBuf, dstBufOffset, orgLen);
        if (decompressRet != totalLen) {
            log.error("decomprss failed, orglen: " + orgLen + ", decompress size len: " + totalLen + ", decomress ret: " + decompressRet);
            return -1;
        }
        return orgLen;
    }

    @Override
    public int maxDecoderSize(int len) {
        if (this.compressor == null) {
            return len * 2;
        }
        return this.compressor.maxCompressedLength(len);
    }
}

