/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record;

import com.aliyun.dts.subscribe.clients.common.NullableOptional;
import com.aliyun.dts.subscribe.clients.record.DatabaseInfo;
import com.aliyun.dts.subscribe.clients.record.ForeignKeyIndexInfo;
import com.aliyun.dts.subscribe.clients.record.RecordField;
import com.aliyun.dts.subscribe.clients.record.RecordIndexInfo;
import com.aliyun.dts.subscribe.clients.record.RecordSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecordSchema
implements RecordSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRecordSchema.class);
    protected final List<RecordField> recordFields;
    protected final Map<String, RecordField> nameIndex;
    private final String schemaId;
    private final String databaseName;
    private final String tableName;
    private String fullQualifiedName;
    private String charset;
    protected RecordIndexInfo primaryIndexInfo;
    protected List<RecordIndexInfo> uniqueIndexInfo;
    private List<ForeignKeyIndexInfo> foreignIndexInfo;
    protected List<RecordIndexInfo> normalIndexInfo;
    private DatabaseInfo databaseInfo;
    private long totalRows;
    private String condition;
    private List<RecordField> partitionFields;

    public DefaultRecordSchema(String schemaId, String databaseName, String tableName, List<RecordField> recordFields) {
        if (null == recordFields) {
            recordFields = Collections.emptyList();
        }
        this.schemaId = schemaId;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.recordFields = new ArrayList<RecordField>(recordFields.size());
        this.recordFields.addAll(recordFields);
        this.nameIndex = new TreeMap<String, RecordField>();
        this.recordFields.forEach(recordField -> this.nameIndex.put(recordField.getFieldName(), (RecordField)recordField));
        this.primaryIndexInfo = null;
        this.uniqueIndexInfo = new ArrayList<RecordIndexInfo>(2);
        this.foreignIndexInfo = new ArrayList<ForeignKeyIndexInfo>(1);
        this.normalIndexInfo = new ArrayList<RecordIndexInfo>(2);
    }

    @Override
    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public void setDatabaseInfo(DatabaseInfo databaseInfo) {
        this.databaseInfo = databaseInfo;
    }

    @Override
    public List<RecordField> getFields() {
        return this.recordFields;
    }

    @Override
    public int getFieldCount() {
        return this.recordFields.size();
    }

    @Override
    public RecordField getField(int index) {
        return this.recordFields.get(index);
    }

    @Override
    public NullableOptional<RecordField> getField(String fieldName) {
        RecordField recordField = this.nameIndex.getOrDefault(fieldName, null);
        if (null != recordField) {
            return NullableOptional.of(recordField);
        }
        return NullableOptional.empty();
    }

    protected List<RecordIndexInfo> removeFiledFromIndexInfoList(List<RecordIndexInfo> indexInfoList, RecordField field) {
        ArrayList<RecordIndexInfo> rs = new ArrayList<RecordIndexInfo>();
        for (RecordIndexInfo indexInfo : indexInfoList) {
            if (null == indexInfo) continue;
            indexInfo.removeField(field);
            if (indexInfo.getIndexFields().isEmpty()) continue;
            rs.add(indexInfo);
        }
        return rs;
    }

    @Override
    public void ignoreField(RecordField field) {
        String fieldName = field.getFieldName();
        LOGGER.info("The field {} is ignored.", (Object)fieldName);
        if (null != this.nameIndex.remove(fieldName)) {
            this.recordFields.remove(field);
        }
        if (field.isPrimary()) {
            List<RecordIndexInfo> newIndexInfo = this.removeFiledFromIndexInfoList(Arrays.asList(this.primaryIndexInfo), field);
            this.primaryIndexInfo = null != newIndexInfo && !newIndexInfo.isEmpty() ? newIndexInfo.get(0) : null;
        }
        if (field.isUnique()) {
            this.uniqueIndexInfo = this.removeFiledFromIndexInfoList(this.uniqueIndexInfo, field);
        }
        if (field.isIndexed()) {
            this.normalIndexInfo = this.removeFiledFromIndexInfoList(this.normalIndexInfo, field);
        }
    }

    @Override
    public List<Integer> getRawDataTypes() {
        return this.recordFields.stream().map(RecordField::getRawDataTypeNum).collect(Collectors.toList());
    }

    @Override
    public List<String> getFieldNames() {
        return this.recordFields.stream().map(RecordField::getFieldName).collect(Collectors.toList());
    }

    @Override
    public NullableOptional<Integer> getRawDataType(String fieldName) {
        return this.getField(fieldName).map(RecordField::getRawDataTypeNum);
    }

    @Override
    public NullableOptional<String> getDatabaseName() {
        if (StringUtils.isEmpty((CharSequence)this.databaseName)) {
            return NullableOptional.empty();
        }
        return NullableOptional.of(this.databaseName);
    }

    @Override
    public NullableOptional<String> getTableName() {
        if (StringUtils.isEmpty((CharSequence)this.tableName)) {
            return NullableOptional.empty();
        }
        return NullableOptional.of(this.tableName);
    }

    public void setFullQualifiedName(String fullQualifiedName) {
        this.fullQualifiedName = fullQualifiedName;
    }

    @Override
    public NullableOptional<String> getFullQualifiedName() {
        if (StringUtils.isEmpty((CharSequence)this.fullQualifiedName)) {
            if (!StringUtils.isEmpty((CharSequence)this.databaseName) && !StringUtils.isEmpty((CharSequence)this.tableName)) {
                return NullableOptional.of(this.databaseName + "." + this.tableName);
            }
            return NullableOptional.empty();
        }
        return NullableOptional.of(this.fullQualifiedName);
    }

    @Override
    public String getSchemaIdentifier() {
        return this.schemaId;
    }

    public void setPrimaryIndexInfo(RecordIndexInfo indexInfo) {
        this.primaryIndexInfo = indexInfo;
    }

    @Override
    public void addUniqueIndexInfo(RecordIndexInfo indexInfo) {
        this.uniqueIndexInfo.add(indexInfo);
    }

    public void addNormalIndexInfo(RecordIndexInfo indexInfo) {
        this.normalIndexInfo.add(indexInfo);
    }

    @Override
    public void addForeignIndexInfo(ForeignKeyIndexInfo indexInfo) {
        this.foreignIndexInfo.add(indexInfo);
    }

    @Override
    public RecordIndexInfo getPrimaryIndexInfo() {
        return this.primaryIndexInfo;
    }

    @Override
    public List<RecordIndexInfo> getUniqueIndexInfo() {
        return this.uniqueIndexInfo;
    }

    @Override
    public List<RecordIndexInfo> getNormalIndexInfo() {
        return this.normalIndexInfo;
    }

    @Override
    public List<ForeignKeyIndexInfo> getForeignIndexInfo() {
        return this.foreignIndexInfo;
    }

    @Override
    public NullableOptional<String> getSchemaName() {
        return this.getDatabaseName();
    }

    @Override
    public long getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    @Override
    public String getFilterCondition() {
        return this.condition;
    }

    @Override
    public void initFilterCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public List<RecordField> getPartitionFields() {
        return this.partitionFields;
    }

    public void setPartitionFields(List<RecordField> partitionFields) {
        this.partitionFields = partitionFields;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String toString() {
        return "{, \nrecordFields= " + this.recordFields + ", \ndatabaseName='" + this.databaseName + '\'' + ", \ntableName='" + this.tableName + '\'' + ", \nprimaryIndexInfo [" + this.primaryIndexInfo + "], \nuniqueIndexInfo [" + this.uniqueIndexInfo + "], \npartitionFields = " + this.partitionFields + '}';
    }
}

