/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record.value;

import com.aliyun.dts.subscribe.clients.record.value.Value;
import com.aliyun.dts.subscribe.clients.record.value.ValueType;
import java.sql.Timestamp;
import java.text.DateFormat;

public class UnixTimestamp
implements Value<String> {
    private long timestampSec;
    private Integer micro;

    public UnixTimestamp() {
        this(0L, null);
    }

    public UnixTimestamp(long timestampSec, Integer micro) {
        this.timestampSec = timestampSec;
        this.micro = micro;
    }

    public void setTimestampSec(long second) {
        this.timestampSec = second;
    }

    public long getTimestampSec() {
        return this.timestampSec;
    }

    public void setMicro(Integer micro) {
        this.micro = micro;
    }

    public Integer getMicro() {
        return this.micro;
    }

    @Override
    public ValueType getType() {
        return ValueType.UNIX_TIMESTAMP;
    }

    @Override
    public String getData() {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(DateFormat dateFormat) {
        Timestamp timestamp = this.toJdbcTimestamp();
        if (null == dateFormat) {
            return timestamp.toString();
        }
        return dateFormat.format(timestamp);
    }

    public Timestamp toJdbcTimestamp() {
        Timestamp timestamp = new Timestamp(this.timestampSec * 1000L);
        if (null != this.micro) {
            timestamp.setNanos(this.micro * 1000);
        }
        return timestamp;
    }

    @Override
    public long size() {
        return 12L;
    }
}

