/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueueGroup;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.QueuePair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueueGroup;
import com.aliyun.openservices.shade.com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueueGroup {
    private String topic;
    private int queueGroupId;
    private ProcessQueueGroup processQueueGroup;
    private MessageQueueGroup messageQueueGroup;
    private Set<QueuePair> queuePairs = new HashSet<QueuePair>();

    public QueueGroup(String topic, int queueGroupId) {
        this.topic = topic;
        this.queueGroupId = queueGroupId;
        this.processQueueGroup = new ProcessQueueGroup();
        this.messageQueueGroup = new MessageQueueGroup(topic);
    }

    public boolean isNormalMsgClean() {
        List<ProcessQueue> pqList = this.processQueueGroup.getProcessQueueList();
        for (ProcessQueue pq : pqList) {
            if (pq.isNormalMsgClean()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllQueueGroupEmpty() {
        List<ProcessQueue> pqList = this.processQueueGroup.getProcessQueueList();
        for (ProcessQueue pq : pqList) {
            boolean hasMessage = pq.hasTempMessage();
            long unmergedMessageSize = pq.unmergedMessageSize();
            if (!hasMessage || unmergedMessageSize <= 0L) continue;
            return false;
        }
        return true;
    }

    public Set<QueuePair> getQueuePairs() {
        return this.queuePairs;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQueueGroupId() {
        return this.queueGroupId;
    }

    public ProcessQueueGroup getProcessQueueGroup() {
        return this.processQueueGroup;
    }

    public void setProcessQueueGroup(ProcessQueueGroup processQueueGroup) {
        this.processQueueGroup = processQueueGroup;
    }

    public MessageQueueGroup getMessageQueueGroup() {
        return this.messageQueueGroup;
    }

    public void setMessageQueueGroup(MessageQueueGroup messageQueueGroup) {
        this.messageQueueGroup = messageQueueGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueGroup meta = (QueueGroup)o;
        return Objects.equal(this.topic, meta.topic) && this.queueGroupId == meta.queueGroupId;
    }

    public int hashCode() {
        return Objects.hashCode(this.topic, this.queueGroupId);
    }
}

