/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.IConfigBuilder;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PackageConfig {
    private String parent = "com.baomidou";
    private String moduleName = "";
    private String entity = "entity";
    private String service = "service";
    private String serviceImpl = "service.impl";
    private String mapper = "mapper";
    private String xml = "mapper.xml";
    private String controller = "controller";
    private Map<OutputFile, String> pathInfo;
    private final Map<String, String> packageInfo = new HashMap<String, String>();

    private PackageConfig() {
    }

    @NotNull
    public String getParent() {
        if (StringUtils.isNotBlank((CharSequence)this.moduleName)) {
            return this.parent + "." + this.moduleName;
        }
        return this.parent;
    }

    @NotNull
    public String joinPackage(String subPackage) {
        String parent = this.getParent();
        return StringUtils.isBlank((CharSequence)parent) ? subPackage : parent + "." + subPackage;
    }

    @NotNull
    public Map<String, String> getPackageInfo() {
        if (this.packageInfo.isEmpty()) {
            this.packageInfo.put("ModuleName", this.getModuleName());
            this.packageInfo.put("Entity", this.joinPackage(this.getEntity()));
            this.packageInfo.put("Mapper", this.joinPackage(this.getMapper()));
            this.packageInfo.put("Xml", this.joinPackage(this.getXml()));
            this.packageInfo.put("Service", this.joinPackage(this.getService()));
            this.packageInfo.put("ServiceImpl", this.joinPackage(this.getServiceImpl()));
            this.packageInfo.put("Controller", this.joinPackage(this.getController()));
            this.packageInfo.put("Parent", this.getParent());
        }
        return Collections.unmodifiableMap(this.packageInfo);
    }

    public String getPackageInfo(String module) {
        return this.getPackageInfo().get(module);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getEntity() {
        return this.entity;
    }

    public String getService() {
        return this.service;
    }

    public String getServiceImpl() {
        return this.serviceImpl;
    }

    public String getMapper() {
        return this.mapper;
    }

    public String getXml() {
        return this.xml;
    }

    public String getController() {
        return this.controller;
    }

    public Map<OutputFile, String> getPathInfo() {
        return this.pathInfo;
    }

    public static class Builder
    implements IConfigBuilder<PackageConfig> {
        private final PackageConfig packageConfig = new PackageConfig();

        public Builder() {
        }

        public Builder(@NotNull String parent, @NotNull String moduleName) {
            this();
            this.packageConfig.parent = parent;
            this.packageConfig.moduleName = moduleName;
        }

        public Builder parent(@NotNull String parent) {
            this.packageConfig.parent = parent;
            return this;
        }

        public Builder moduleName(@NotNull String moduleName) {
            this.packageConfig.moduleName = moduleName;
            return this;
        }

        public Builder entity(@NotNull String entity) {
            this.packageConfig.entity = entity;
            return this;
        }

        public Builder service(@NotNull String service) {
            this.packageConfig.service = service;
            return this;
        }

        public Builder serviceImpl(@NotNull String serviceImpl) {
            this.packageConfig.serviceImpl = serviceImpl;
            return this;
        }

        public Builder mapper(@NotNull String mapper) {
            this.packageConfig.mapper = mapper;
            return this;
        }

        public Builder xml(@NotNull String xml) {
            this.packageConfig.xml = xml;
            return this;
        }

        public Builder controller(@NotNull String controller) {
            this.packageConfig.controller = controller;
            return this;
        }

        public Builder pathInfo(@NotNull Map<OutputFile, String> pathInfo) {
            this.packageConfig.pathInfo = pathInfo;
            return this;
        }

        @NotNull
        public String joinPackage(@NotNull String subPackage) {
            return this.packageConfig.joinPackage(subPackage);
        }

        @Override
        public PackageConfig build() {
            return this.packageConfig;
        }
    }
}

