/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.algorithm;

import com.lsy.baselib.crypto.exception.DESException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DES {
    public static String SECURITY_PROVIDER = "BC";

    static {
        if (Security.getProvider(SECURITY_PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static byte[] createKey() throws DESException {
        byte[] data = null;
        try {
            KeyGenerator kg = null;
            SecretKey sk = null;
            SecureRandom sr = new SecureRandom();
            kg = KeyGenerator.getInstance("DES");
            kg.init(sr);
            sk = kg.generateKey();
            data = sk.getEncoded();
        }
        catch (Exception e) {
            throw new DESException("fail to generate 64 bits DES key", e);
        }
        return data;
    }

    public static byte[] encrypt(byte[] message, byte[] key) throws DESException {
        byte[] data = null;
        if (message == null) {
            throw new DESException("parameter messgage cann't be null");
        }
        if (key == null) {
            throw new DESException("parameter key cann't be null");
        }
        try {
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, (Key)secretKey, sr);
            data = cipher.doFinal(message);
        }
        catch (Exception e) {
            throw new DESException("fail to encrypt message", e);
        }
        return data;
    }

    public static byte[] decrypt(byte[] cryptograph, byte[] key) throws DESException {
        byte[] data = null;
        if (cryptograph == null) {
            throw new DESException("parameter cryptograph cann't be null");
        }
        if (key == null) {
            throw new DESException("parameter key cann't be null");
        }
        try {
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES", "BC");
            SecretKey secretKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding", "BC");
            cipher.init(2, (Key)secretKey, sr);
            data = cipher.doFinal(cryptograph);
        }
        catch (Exception e) {
            throw new DESException("fail to decrypt cryptograph", e);
        }
        return data;
    }
}

