/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.algorithm;

import com.lsy.baselib.crypto.exception.DESedeException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DESede {
    public static String SECURITY_PROVIDER = "BC";
    public static int DESEDE_KEY_112_BIT;
    public static int DESEDE_KEY_168_BIT;

    static {
        if (Security.getProvider(SECURITY_PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        DESEDE_KEY_112_BIT = 112;
        DESEDE_KEY_168_BIT = 168;
    }

    public static byte[] createKey() throws DESedeException {
        return DESede.createKey(DESEDE_KEY_168_BIT);
    }

    public static byte[] createKey(int keySize) throws DESedeException {
        byte[] data = null;
        if (keySize != DESEDE_KEY_112_BIT && keySize != DESEDE_KEY_168_BIT) {
            throw new DESedeException("parameter keySize can only be " + DESEDE_KEY_112_BIT + " or " + DESEDE_KEY_168_BIT + " bits");
        }
        try {
            KeyGenerator kg = null;
            SecretKey sk = null;
            kg = KeyGenerator.getInstance("DESede");
            kg.init(keySize);
            sk = kg.generateKey();
            data = sk.getEncoded();
        }
        catch (Exception e) {
            throw new DESedeException("fail to generate " + keySize + " bits DESede key", e);
        }
        return data;
    }

    public static byte[] encrypt(byte[] message, byte[] key) throws DESedeException {
        byte[] data = null;
        if (message == null) {
            throw new DESedeException("parameter messgage cann't be null");
        }
        if (key == null) {
            throw new DESedeException("parameter key cann't be null");
        }
        try {
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = keyFactory.generateSecret(keyspec);
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            data = cipher.doFinal(message);
        }
        catch (Exception e) {
            throw new DESedeException("fail to encrypt message", e);
        }
        return data;
    }

    public static byte[] decrypt(byte[] cryptograph, byte[] key) throws DESedeException {
        byte[] data = null;
        if (cryptograph == null) {
            throw new DESedeException("parameter cryptograph cann't be null");
        }
        if (key == null) {
            throw new DESedeException("parameter key cann't be null");
        }
        try {
            SecretKeySpec sks = new SecretKeySpec(key, "DESede");
            Cipher cpr = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cpr.init(2, sks);
            data = cpr.doFinal(cryptograph);
        }
        catch (Exception e) {
            throw new DESedeException("fail to decrypt cryptograph", e);
        }
        return data;
    }

    public static byte[] encrypt(byte[] message, byte[] key, byte[] salt) throws DESedeException {
        byte[] data = null;
        if (message == null) {
            throw new DESedeException("parameter messgage cann't be null");
        }
        if (key == null) {
            throw new DESedeException("parameter key cann't be null");
        }
        try {
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = keyFactory.generateSecret(keyspec);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(salt);
            cipher.init(1, (Key)secretKey, iv);
            data = cipher.doFinal(message);
        }
        catch (Exception e) {
            throw new DESedeException("fail to encrypt message", e);
        }
        return data;
    }

    public static byte[] decrypt(byte[] cryptograph, byte[] key, byte[] salt) throws DESedeException {
        byte[] data = null;
        if (cryptograph == null) {
            throw new DESedeException("parameter cryptograph cann't be null");
        }
        if (key == null) {
            throw new DESedeException("parameter key cann't be null");
        }
        try {
            SecretKeySpec sks = new SecretKeySpec(key, "DESede");
            Cipher cpr = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(salt);
            cpr.init(2, (Key)sks, iv);
            data = cpr.doFinal(cryptograph);
        }
        catch (Exception e) {
            throw new DESedeException("fail to decrypt cryptograph", e);
        }
        return data;
    }
}

