/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.algorithm;

import com.lsy.baselib.crypto.exception.RSAException;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSA {
    public static String SECURITY_PROVIDER = "BC";
    public static int RSA_KEY_1024_BIT;
    public static int RSA_KEY_2048_BIT;

    static {
        if (Security.getProvider(SECURITY_PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        RSA_KEY_1024_BIT = 1024;
        RSA_KEY_2048_BIT = 2048;
    }

    public static KeyPair generateRSAKeyPair() throws RSAException {
        return RSA.generateRSAKeyPair(RSA_KEY_1024_BIT);
    }

    public static KeyPair generateRSAKeyPair(int keySize) throws RSAException {
        if (keySize != RSA_KEY_1024_BIT && keySize != RSA_KEY_2048_BIT) {
            throw new RSAException("parameter keySize can only be " + RSA_KEY_1024_BIT + " or " + RSA_KEY_2048_BIT + " bits");
        }
        KeyPair pair = null;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(keySize);
            pair = keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new RSAException("fail to generate RSA key pair", e);
        }
        return pair;
    }

    public static byte[] encrypt(byte[] message, byte[] key) throws RSAException {
        byte[] encryptedData = null;
        ByteArrayOutputStream output = null;
        ByteArrayOutputStream baos = null;
        if (message == null) {
            throw new RSAException("parameter message cann't be null");
        }
        if (key == null) {
            throw new RSAException("parameter key cann't be null");
        }
        PublicKey rsakey = null;
        try {
            X509EncodedKeySpec rsaKeySpec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            rsakey = keyFactory.generatePublic(rsaKeySpec);
        }
        catch (Exception e) {
            throw new RSAException("invalid rsa public key", e);
        }
        try {
            try {
                Cipher rsaPKenc = Cipher.getInstance("RSA/ECB/PKCS1Padding", SECURITY_PROVIDER);
                rsaPKenc.init(1, rsakey);
                output = new ByteArrayOutputStream();
                baos = new ByteArrayOutputStream();
                int blocksize = rsaPKenc.getBlockSize();
                int i = 0;
                while (i < message.length) {
                    if (i + blocksize > message.length) {
                        blocksize = message.length - i;
                    }
                    baos.write(message, i, blocksize);
                    output.write(rsaPKenc.doFinal(baos.toByteArray()));
                    baos.reset();
                    i += blocksize;
                }
                encryptedData = output.toByteArray();
            }
            catch (Exception e) {
                throw new RSAException("fail to encrypt with rsa public key", e);
            }
        }
        finally {
            block38: {
                try {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (baos != null) {
                                baos.close();
                            }
                            break block38;
                        }
                        catch (Exception exception2) {}
                        break block38;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (encryptedData == null) {
            throw new RSAException("unknown error inside encrypt function");
        }
        return encryptedData;
    }

    public static byte[] decrypt(byte[] cryptograph, byte[] key) throws RSAException {
        byte[] decryptedData = null;
        ByteArrayOutputStream output = null;
        ByteArrayOutputStream baos = null;
        if (cryptograph == null) {
            throw new RSAException("parameter cryptograph cann't be null");
        }
        if (key == null) {
            throw new RSAException("parameter key cann't be null");
        }
        PrivateKey rsakey = null;
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            rsakey = keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RSAException("invalid rsa private key", e);
        }
        try {
            try {
                Cipher rsaSKDec = Cipher.getInstance("RSA/ECB/PKCS1Padding", SECURITY_PROVIDER);
                rsaSKDec.init(2, rsakey);
                output = new ByteArrayOutputStream();
                baos = new ByteArrayOutputStream();
                int blocksize = rsaSKDec.getBlockSize();
                int i = 0;
                while (i < cryptograph.length) {
                    baos.write(cryptograph, i, blocksize);
                    output.write(rsaSKDec.doFinal(baos.toByteArray()));
                    baos.reset();
                    i += blocksize;
                }
                decryptedData = output.toByteArray();
            }
            catch (Exception e) {
                throw new RSAException("fail to decrypt with rsa private key", e);
            }
        }
        finally {
            block37: {
                try {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (baos != null) {
                                baos.close();
                            }
                            break block37;
                        }
                        catch (Exception exception2) {}
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (decryptedData == null) {
            throw new RSAException("unknown error inside decrypt function");
        }
        return decryptedData;
    }

    public static byte[] sign(byte[] message, byte[] key) throws RSAException {
        byte[] signedData = null;
        if (message == null) {
            throw new RSAException("parameter message cann't be null");
        }
        if (key == null) {
            throw new RSAException("parameter key cann't be null");
        }
        PrivateKey rsakey = null;
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            rsakey = keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RSAException("invalid rsa private key", e);
        }
        try {
            Cipher rsaPKenc = Cipher.getInstance("RSA/ECB/PKCS1Padding", SECURITY_PROVIDER);
            rsaPKenc.init(1, rsakey);
            signedData = rsaPKenc.doFinal(message);
        }
        catch (Exception e) {
            throw new RSAException("fail to sign with rsa private key", e);
        }
        if (signedData == null) {
            throw new RSAException("unknown error inside sign function");
        }
        return signedData;
    }

    public static byte[] verify(byte[] cryptograph, byte[] key) throws RSAException {
        byte[] verifiedData = null;
        PublicKey rsakey = null;
        try {
            X509EncodedKeySpec rsaKeySpec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            rsakey = keyFactory.generatePublic(rsaKeySpec);
        }
        catch (Exception e) {
            throw new RSAException("invalid rsa public key", e);
        }
        try {
            Cipher rsaSKDec = Cipher.getInstance("RSA/ECB/PKCS1Padding", SECURITY_PROVIDER);
            rsaSKDec.init(2, rsakey);
            verifiedData = rsaSKDec.doFinal(cryptograph);
        }
        catch (Exception e) {
            throw new RSAException("fail to verify with rsa public key", e);
        }
        if (verifiedData == null) {
            throw new RSAException("unknown error inside verify function");
        }
        return verifiedData;
    }
}

