/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.demo;

import com.lsy.baselib.crypto.algorithm.DESede;
import com.lsy.baselib.crypto.util.BytesUtil;

public class DESedeTest {
    public static void main(String[] args) throws Exception {
        byte[] salt = new byte[]{18, 52, 86, 120, -112, -85, -51, -17};
        byte[] message = "123456789\u6211\u7231\u4e2d\u534e.2".getBytes();
        byte[] key = DESede.createKey(DESede.DESEDE_KEY_112_BIT);
        System.out.println("key length:" + key.length);
        System.out.println("key hex value:" + BytesUtil.binary2hex(key).toUpperCase());
        System.out.println("message size(byte):" + message.length);
        long beginTime = System.currentTimeMillis();
        byte[] encryptedData = DESede.encrypt(message, key, salt);
        long endTime = System.currentTimeMillis();
        System.out.println("first encrypt time(ms):" + (endTime - beginTime));
        beginTime = System.currentTimeMillis();
        encryptedData = DESede.encrypt(message, key, salt);
        endTime = System.currentTimeMillis();
        System.out.println("second encrypt time(ms):" + (endTime - beginTime));
        System.out.println("encryptedData size(byte):" + encryptedData.length);
        System.out.println("encryptedData:" + new String(BytesUtil.binary2hex(encryptedData)).toUpperCase());
        byte[] decryptedData = DESede.decrypt(encryptedData, key, salt);
        System.out.println("decryptedData size(byte):" + decryptedData.length);
        System.out.println("decryptedData:" + new String(decryptedData));
    }
}

