/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.demo;

import com.lsy.baselib.crypto.util.CryptUtil;
import com.lsy.baselib.crypto.util.HexUtil;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;

public class DigestTest {
    public static void main(String[] args) throws Exception {
        byte[] password = "dsfw32342342".getBytes();
        byte[] salt = new byte[14];
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.nextBytes(salt);
        ByteArrayOutputStream baos = null;
        try {
            try {
                long starttime = System.currentTimeMillis();
                baos = new ByteArrayOutputStream();
                baos.write(password);
                baos.write(salt);
                byte[] result = CryptUtil.digest(baos.toByteArray(), "MD5");
                long endtime = System.currentTimeMillis();
                System.out.println("password:" + new String(password));
                System.out.println("salt:" + HexUtil.binary2hex(salt));
                System.out.println("password+salt:" + HexUtil.binary2hex(baos.toByteArray()));
                System.out.println("hash result:" + HexUtil.binary2hex(result));
                System.out.println("expended time:" + (endtime - starttime));
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

