/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.demo;

import com.lsy.baselib.crypto.algorithm.RSA;
import com.lsy.baselib.crypto.protocol.DigitalEnvelope;
import com.lsy.baselib.crypto.util.Base64;
import java.security.KeyPair;

public class DigitalEnvelopeTest {
    public static void main(String[] args) throws Exception {
        String message = "hello,\u4e16\u754c\uff01";
        System.out.println("message size:" + message.getBytes().length);
        KeyPair kp = RSA.generateRSAKeyPair();
        byte[] encodedData = DigitalEnvelope.encode(message.getBytes(), kp.getPublic().getEncoded());
        System.out.println("encodedData size:" + encodedData.length);
        System.out.println("encodedData:" + new String(Base64.encode(encodedData)));
        byte[] decodedData = DigitalEnvelope.decode(encodedData, kp.getPrivate().getEncoded());
        System.out.println("decodedData size:" + decodedData.length);
        System.out.println("decodedData:" + new String(decodedData));
    }
}

