/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.demo;

import com.lsy.baselib.crypto.processor.ECCryptoProcessor;

public class ECCryptoProcessorTest {
    public static void main(String[] args) {
        try {
            ECCryptoProcessor processor = new ECCryptoProcessor();
            String signercrt = "MIIDrDCCAxWgAwIBAgIQE/tf6esqTcS2jfVMlOzz4DANBgkqhkiG9w0BAQUFADAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMB4XDTA5MDUyMTAwMjIwMVoXDTEwMDUyMTAwMjIwMVowfTELMAkGA1UEBhMCQ04xFTATBgNVBAoTDENGQ0EgVEVTVCBDQTENMAsGA1UECxMEdGNjYjEUMBIGA1UECxMLRW50ZXJwcmlzZXMxMjAwBgNVBAMUKTA0MUAwMzUwNTgyMTk3OTA1MzEyMDExQGVjY2xpZW50QDAwMDAwMDE4MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCDNlCOg097j3E/V7LHqtkKhs2FH8EHTz2mZPLw+wJnhg+DudOyermP9yeqe29uXwfLQgkT8NSNf82AnXEUGQP/nYvIXj8hbtIhtjB+XLdaoRwZoCQxyFFxiueTztx0JQFKiLFCMv3YuHaep6ymwawNC3nfZpUSebGAdUt5UwC6sQIDAQABo4IBhDCCAYAwHwYDVR0jBBgwFoAURnLcJXKfAk5Vg7WA+Qvb6ZOz9EUwHQYDVR0OBBYEFP8Lm9Whc3ALnXIyuJZqmSYWAVkDMAsGA1UdDwQEAwIFoDAMBgNVHRMEBTADAQEAMDsGA1UdJQQ0MDIGCCsGAQUFBwMBBggrBgEFBQcDAgYIKwYBBQUHAwMGCCsGAQUFBwMEBggrBgEFBQcDCDCB5QYDVR0fBIHdMIHaME6gTKBKpEgwRjELMAkGA1UEBhMCQ04xFTATBgNVBAoTDENGQ0EgVEVTVCBDQTEMMAoGA1UECxMDQ1JMMRIwEAYDVQQDEwljcmwxMjdfNDEwgYeggYSggYGGf2xkYXA6Ly8yMTAuNzQuNDEuODc6Mzg5L0NOPWNybDEyN180MSxPVT1DUkwsTz1DRkNBIFRFU1QgQ0EsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwDQYJKoZIhvcNAQEFBQADgYEAb3W+O3FA9tckuzcLSX6vJTN7rYlPWB/nOkR0Svs56GaU4YaW2MQzIMCiwS0SCR3dyRMtVAMMa39n8IiJYCW34j5oPtk0Gh6kXslcNu/OCMR/+o7M9YDCw95IMm2nNa+/6q2otL51CNZzuurx878trIZGMOWZ3fovn1SAf4I4dV8=";
            String signerkey = "A1JTQY0y/p3ns1bYN0lYRhs3SJfwvzljJRMy0RxGmJup05Rimy/ijMZ8GahHF/a0pZaG/PcfONODA836mAbLqg1AjrlTOHucoOzFXvQ3m11yvJ9+v17P45w8sMBeaatBdBqJ6x12+X+Nk9Vqi5hPBsup+Qdaz886SkprdeknvqR+MsBVp8tE65okUnGG9fB2b7exd/hVFNQSPA1a4tS5GPCdR/leITpA8W1ojlSWgU9blJWnHMZ4snHRyC1qowMJg8c+4twRKsSPXmwsqkJ6vTUPixdYFYKZ28rrMFVtFGt2lC3FDPo93A5SkdS3JszyK4B90VVRi0FJmLB/XzCMwn2UImdSlG3SaRHEmFm++3RSTkfpllG+OmNxFoih5phcf0XLHn2QdwqTYtVXjJNH3X4RlcMrWPBNS7UVQVv6EZhXd5xOrNvmAW3BC/7R13SKPUY0TzJcg4OeU2Lba0gzivKodA8my1/NXCeM6avmPFdf72SwwpG0/v5FiTxsJ81vPQ5jXOg4fkiMBrPGd/EPqCUf7/CMDVJwIzH3v9AzEhSbJCCxFAgTEFmE98iDsz7J7LbzRPvdr7VkOdipzGYD+tIrzSwzsKpbGNa9yOypv3VNhb0VaB8I0XHAyKBlqWAIEAw3t2s+BZcwzRp3ZdlnJLOi5N6ezt33Va0xqWqOBjNjTEDf61CFkOWeuUX2QdEYIhv9W81Pl7Dq+25s674FgWLNOO2abvXo3fKgn0M5XPq1T2RxFYeHCYhMh4j+UIci7FBz5ZhXN+EG2AFz/GL45OIFXYPgsmMxP0O+CU48tVokaD/x0P9/dxQQ2Fn6tWEpRGO207C2ZA4M3W7DCZ1Tlerc47ONVARi6AU19g==";
            String keypasswd = "jsfhfP7";
            processor.setSignerCertificate(signercrt.getBytes());
            processor.setSignerPrivatekey(signerkey.getBytes(), keypasswd);
            String message = "hello, \u4e16\u754c!";
            System.out.println("source message\uff1a" + message);
            System.out.print("do signing ...");
            long starttime = System.currentTimeMillis();
            byte[] signedMessage = processor.sign(message.getBytes());
            long endtime = System.currentTimeMillis();
            System.out.println("ok. Spend " + (endtime - starttime) + " ms");
            System.out.println("signed messge size(bytes):" + signedMessage.length);
            System.out.println("signed messge:" + new String(signedMessage));
            signedMessage = "MIIE1gYJKoZIhvcNAQcCoIIExzCCBMMCAQExDjAMBggqhkiG9w0CBQUAMAsGCSqGSIb3DQEHAaCCA7YwggOyMIIDG6ADAgECAhB1UCREozjkiC1mAq/2m9+MMA0GCSqGSIb3DQEBBQUAMCoxCzAJBgNVBAYTAkNOMRswGQYDVQQKExJDRkNBIE9wZXJhdGlvbiBDQTIwHhcNMTAwOTA2MDkwMzQwWhcNMTUwOTA2MDkwMzQwWjCBgjELMAkGA1UEBhMCQ04xGzAZBgNVBAoTEkNGQ0EgT3BlcmF0aW9uIENBMjENMAsGA1UECxMEQ05DQjESMBAGA1UECxMJQ3VzdG9tZXJzMTMwMQYDVQQDFCowNDFAMDQ0NTI4MTE5NzgxMjA3MzcxM0BDQUlIQUlUQU9AMDAwMDAwMDEwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMGmFzata+zoLK33sWyMajZFcMeshx8erROSJoi2OzVyWn09Dqj2sEX/fG0Hj0Stq++R1Awvj0dndGQSVZWQwJ5clPePq6YRRiwA8TdD+ub7NhmJEKnGN3zt5Wwkl2nmEOSbIqyeI3DEem2Ycq2QkyOu9VuNmtTZ0h06ENuUzT7hAgMBAAGjggF+MIIBejAfBgNVHSMEGDAWgBTwje2zQbv77wgeVQLDMTfvPBROzTAdBgNVHQ4EFgQU+XtNNY/aync3JXw5GYpdCFLSq0kwCwYDVR0PBAQDAgXgMAwGA1UdEwQFMAMBAQAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMIH9BgNVHR8EgfUwgfIwVqBUoFKkUDBOMQswCQYDVQQGEwJDTjEbMBkGA1UEChMSQ0ZDQSBPcGVyYXRpb24gQ0EyMQwwCgYDVQQLEwNDUkwxFDASBgNVBAMTC2NybDEwMV82MTY5MIGXoIGUoIGRhoGObGRhcDovL2NlcnQ4NjMuY2ZjYS5jb20uY246Mzg5L0NOPWNybDEwMV82MTY5LE9VPUNSTCxPPUNGQ0EgT3BlcmF0aW9uIENBMixDPUNOP2NlcnRpZmljYXRlUmV2b2NhdGlvbkxpc3Q/YmFzZT9vYmplY3RjbGFzcz1jUkxEaXN0cmlidXRpb25Qb2ludDANBgkqhkiG9w0BAQUFAAOBgQAuMIND5GgaElt5pvZPln870O7t5HPcOIDgoHT0liUY+/chmJ6coRuAhcTniEJg+ehWoN5WyRaQijwmn0GPV46n5NdQSx7OkB8n0e0wFyC0UKxcIhQ9WB4Ki7GwaEjHmxTZJ/6hIaEyInaVCjT6PZvsxylwirhRBumb2W0C3vnEZTGB5jCB4wIBATA+MCoxCzAJBgNVBAYTAkNOMRswGQYDVQQKExJDRkNBIE9wZXJhdGlvbiBDQTICEHVQJESjOOSILWYCr/ab34wwDAYIKoZIhvcNAgUFADANBgkqhkiG9w0BAQEFAASBgLIVv1II8OernjF66kLBDnku35kbJFSYI2jfAflkgEbIdJ0XnFJQ09BS25RGcO2NBRcbUyqP8rDpFnF22PcVz6cZRx9kfMnfCctLVcN5yTndPoPWMatz9dyavCsUNAH8aavO30CURnDtjQUXG1Mqj/Kw6RZxA+bBu0Y0Gyj9I19C".getBytes();
            String trustedcrt = "MIICezCCAeSgAwIBAgIEPPyMXjANBgkqhkiG9w0BAQUFADAgMQswCQYDVQQGEwJDTjERMA8GA1UEChMIQ0ZDQSBSQ0EwHhcNMDQwODEwMDgzNjM3WhcNMTQwNzI1MTYwMDAwWjAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYrs50M7hq8y0LzFjfN3UPQzGiBg1kLinPqJcSx7oRXey15WpLLMLthcfp9Gn/7uXmtNL6athr91YXzrB3Rcp53U3zqScGE9h2ktFQ3SNdZP6c/VSQ+27pAVxWRUC+F6pmUsno+jd1mftYjhKRV8yvCRpSV6HDzhLK83xbkoCfiQIDAQABo4G9MIG6MEIGA1UdHwQ7MDkwN6A1oDOkMTAvMQswCQYDVQQGEwJDTjERMA8GA1UEChMIQ0ZDQSBSQ0ExDTALBgNVBAMTBENSTDEwCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFACaNPJR+VMUYXRucqEG3seBcBu8MB0GA1UdDgQWBBRGctwlcp8CTlWDtYD5C9vpk7P0RTAMBgNVHRMEBTADAQH/MBkGCSqGSIb2fQdBAAQMMAobBFY2LjADAgSQMA0GCSqGSIb3DQEBBQUAA4GBAJ69l0Y1K+ayEvojzBHfzozMf0a0aQMaEbiil+RJQ8lvwWHZOeaRTcJOxyiPoQ5DZqhEusXavFPX4J/mE3H5PCnV5tF7tSO7vEguhs8m2IXxrOZCpKmCJVevNdV9x0m9eD629NVJGf683raMx39Ft4HQFaLT+EXbnSAWvYemPyOW";
            processor.addTrustedCertificate(trustedcrt.getBytes());
            String trustedcrt_cfca_ca2 = "MIICiTCCAfKgAwIBAgIEOUSYdzANBgkqhkiG9w0BAQUFADAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBSb290IENBMB4XDTA0MTIwNjA2MjkzN1oXDTE5MTEyMDE2MDAwMFowKjELMAkGA1UEBhMCQ04xGzAZBgNVBAoTEkNGQ0EgT3BlcmF0aW9uIENBMjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAsb+Mf+YTYJUO7JvPqHM3sL4pN6dbSMDKMaVSXgjdhNMAf9bbwz6uPQ1GaOz2fd0HjWGe9lV9czuouGL5PRwNBKVUUYXvuRkhszmNEPt5IVXNrk94bt2rlCTFQTMUrDQGkpoeT3BlMRShFOQZyiKqkhuGt1g4HZ9urfzKFT+5Z2sCAwEAAaOBwTCBvjBGBgNVHR8EPzA9MDugOaA3pDUwMzELMAkGA1UEBhMCQ04xFTATBgNVBAoTDENGQ0EgUm9vdCBDQTENMAsGA1UEAxMEQ1JMMTALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAUfxqihn9JCd+XoKYCmug8dPvtzsMwHQYDVR0OBBYEFPCN7bNBu/vvCB5VAsMxN+88FE7NMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjYuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAd2ZprRt4V2QXuxt0bkJ4DWeOw6OBHu/R5GGDe4LOxzgWU6epZe3gkehhgDxAaVa+XJmSJa3mZr5/j9QZqXHFtLznVWMERkvd3AK2K7pCe9Glc9wjSl8GLJN+tj4CfuGl25dE3ZFVPU/rQgsUI0FOdnFxuwPJKNrB2fMquu7Vsxs=";
            processor.addTrustedCertificate(trustedcrt_cfca_ca2.getBytes());
            System.out.print("do verifying ...");
            starttime = System.currentTimeMillis();
            processor.verify(signedMessage);
            endtime = System.currentTimeMillis();
            System.out.println("ok. Spend " + (endtime - starttime) + " ms");
            System.out.println("source messge:" + new String(processor.getOrderMessage(signedMessage)));
            System.out.println("signer certificate:" + processor.getSignerCertificate(signedMessage).getSubjectDN());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

