/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.demo;

import com.lsy.baselib.crypto.demo.DESede;
import com.lsy.baselib.crypto.util.BytesUtil;
import com.lsy.baselib.crypto.util.CryptUtil;
import java.security.SecureRandom;
import java.util.Arrays;

public class PINTest {
    public static void main(String[] args) throws Exception {
        String salt = "100000000000000001";
        String random = "1234567890123456";
        String oldpin = "5201314#w";
        String newPin = "dfwefasdf";
        byte[] holdpin = CryptUtil.digest((String.valueOf(oldpin) + salt).getBytes(), "SHA1");
        byte[] akey = new byte[24];
        System.arraycopy(holdpin, 0, akey, 0, 16);
        System.arraycopy(holdpin, 0, akey, 16, 8);
        byte[] ekey = new byte[24];
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG", "SUN");
        sr.nextBytes(ekey);
        System.out.println("\u52a0\u5bc6\u524d\u7684\u8ba1\u7b97\u7684\u52a0\u5bc6\u5bc6\u94a5:" + BytesUtil.binary2hex(ekey));
        byte[] source = new byte[40];
        System.arraycopy(random.getBytes(), 0, source, 0, 16);
        System.arraycopy(ekey, 0, source, 16, 24);
        byte[] data = DESede.encrypt(source, akey);
        String arc = BytesUtil.binary2hex(data);
        System.out.println("\u52a0\u5bc6\u524d\u7684\u968f\u673a\u6570:" + random);
        System.out.println("\u65e7PIN\u7801\u8ba1\u7b97\u5f97\u5230\u7684\u8ba4\u8bc1\u6570\u636e:" + arc);
        byte[] hnewpin = CryptUtil.digest((String.valueOf(newPin) + salt).getBytes(), "SHA1");
        byte[] chk = CryptUtil.digest(hnewpin, "SHA1");
        byte[] hpinchk = new byte[40];
        System.arraycopy(hnewpin, 0, hpinchk, 0, 20);
        System.arraycopy(chk, 0, hpinchk, 20, 20);
        byte[] data2 = DESede.encrypt(hpinchk, ekey);
        String utc = BytesUtil.binary2hex(data2);
        System.out.println("\u52a0\u5bc6\u524d\u8ba1\u7b97\u7684\u65b0PIN\u7801\u548c\u76d0\u7684\u54c8\u5e0c\u503c:" + BytesUtil.binary2hex(hnewpin));
        byte[] akey2 = new byte[24];
        System.arraycopy(CryptUtil.digest((String.valueOf(oldpin) + salt).getBytes(), "SHA1"), 0, akey2, 0, 16);
        System.arraycopy(holdpin, 0, akey2, 16, 8);
        byte[] data3 = DESede.decrypt(BytesUtil.hex2binary(arc), akey2);
        byte[] random2 = new byte[16];
        byte[] ekey2 = new byte[24];
        System.arraycopy(data3, 0, random2, 0, 16);
        System.arraycopy(data3, 16, ekey2, 0, 24);
        System.out.println("\u89e3\u5bc6\u540e\u5f97\u5230\u7684\u968f\u673a\u6570:" + new String(random2));
        System.out.println("\u89e3\u5bc6\u540e\u5f97\u5230\u7684\u52a0\u5bc6\u5bc6\u94a5:" + BytesUtil.binary2hex(ekey2));
        byte[] hnewpinchk = DESede.decrypt(BytesUtil.hex2binary(utc), ekey2);
        byte[] hnewpin2 = new byte[20];
        byte[] chk2 = new byte[20];
        System.arraycopy(hnewpinchk, 0, hnewpin2, 0, 20);
        System.arraycopy(hnewpinchk, 20, chk2, 0, 20);
        System.out.println("\u89e3\u5bc6\u540e\u5f97\u5230\u7684\u65b0PIN\u7801\u548c\u76d0\u7684\u54c8\u5e0c\u503c:" + BytesUtil.binary2hex(hnewpin2));
        System.out.println("\u89e3\u5bc6\u540e\u5f97\u5230\u7684\u65b0PIN\u7801\u548c\u76d0\u7684\u54c8\u5e0c\u503c\u7684\u6821\u9a8c\u503c:" + BytesUtil.binary2hex(chk2));
        if (Arrays.equals(chk2, CryptUtil.digest(hnewpin2, "SHA1"))) {
            System.out.println("\u6821\u9a8c\u503c\u9a8c\u8bc1\u901a\u8fc7");
        }
    }
}

