/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.demo;

import com.lsy.baselib.crypto.algorithm.RSA;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.BytesUtil;
import com.lsy.baselib.crypto.util.CryptUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class RSATest {
    public static void main(String[] args) throws Exception {
        String serverCrtString = "MIIDkTCCAvqgAwIBAgIQeJqZH00CV9WVE7JePBxFZzANBgkqhkiG9w0BAQUFADAqMQswCQYDVQQGEwJDTjEbMBkGA1UEChMSQ0ZDQSBPcGVyYXRpb24gQ0EyMB4XDTA5MDQxMDA0MzEzOVoXDTE0MDQxMDA0MzEzOVowgYAxCzAJBgNVBAYTAkNOMRswGQYDVQQKExJDRkNBIE9wZXJhdGlvbiBDQTIxDTALBgNVBAsTBENOQ0IxEjAQBgNVBAsTCUN1c3RvbWVyczExMC8GA1UEAxQoMDQxQDAzNTA1ODIxOTc5MDUzMTIwMTFAV1VMSVVZSUAwMDAwMDAwMjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAvgOgEX5poRzs1KcZWloZ1KtfQePJxaiunb2UpQIp6NxkNvrmDMFFhp+CrfMK08O1a4jE3yWmq1TAOTXN/tsT/nh7x5AZGc22qbN87cFRHxNOXMcwya/oWKcDmd6NIogRsjXwt3YOYiddi08J+Xr6Yt3fiU+tMvaW8fDWgwfDUasCAwEAAaOCAV8wggFbMB8GA1UdIwQYMBaAFPCN7bNBu/vvCB5VAsMxN+88FE7NMB0GA1UdDgQWBBT5HPUG+84yNP0lKRR6baofARKU3TALBgNVHQ8EBAMCBaAwDAYDVR0TBAUwAwEBADCB/QYDVR0fBIH1MIHyMFagVKBSpFAwTjELMAkGA1UEBhMCQ04xGzAZBgNVBAoTEkNGQ0EgT3BlcmF0aW9uIENBMjEMMAoGA1UECxMDQ1JMMRQwEgYDVQQDEwtjcmwxMDFfMjMwMzCBl6CBlKCBkYaBjmxkYXA6Ly9jZXJ0ODYzLmNmY2EuY29tLmNuOjM4OS9DTj1jcmwxMDFfMjMwMyxPVT1DUkwsTz1DRkNBIE9wZXJhdGlvbiBDQTIsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwDQYJKoZIhvcNAQEFBQADgYEAkLiZTJqC942akgyYwXyYd6l2oHO24npAxtbGz/SVAPM4CqkYMAdutDKiF5z2ZDe8/kDz8W7HfkeB1QGxsJQMNi2/m2wsD9vJXKEfLedzTHSNToR4Go3EF60Tf5hlfp2RE9SnACCcuoqG1aAjLwu//g1j8Ooa/hIwPHPZGDEm5sY=";
        String serverKeyString = "MIICXQIBAAKBgQDHCWx4fw78Mc3vauCwt8nYRZFjgfYa2gNtPY5dfRLhbr7nf77fE+xXyGvqjHVAVsP9y/MOhwVas3Fau8VOE6EjtnKTeSgCaHgNXu3og4Uf6uaI7VZBp51pL8Bxjl23p4rx96esDGWXdOc3ceXKTN1lxtQagQJhS9o9GVxA8xWxtQIDAQABAoGBALiYht+ih9Vio6p/J3D+o9dPfi4Z5JS2yiLQym7uh0pJGgk+s1nV8obfvSbFqiFH13JVa1F37IFYl7MdHzrwfassm97HPP1esUmRD2onzryuxTayqpcL1MlUjftqd8B/iyHKPqnh4QP+99D1KW52LZoThCLRWG62HE32K8cRZqvBAkEA6erGUNyZgD9kCnbfvmLEsWdU4viLgtdjRw+mSg2qi9XRt8i/x23KqfGCOg90ZOr2O9Jlew9JadeJfRJ+Dy5zeQJBANnTrMOiWL5g+bbhrf4mQR9CCsp30Tk8KrbVo4Ok+Swzz3y2T/5VLxZVoIrom5qm/CTlQmf+kOBa8kVxRVuLRR0CQCoe3XEIGBfw0jnUJ/vnWxW6zp1ENhLsZ/MOzVm+Vjxx1x6p5mapzXmGhHWh/MqDSK2C+EUNfqGxbw93ef2P1rkCQQCwTAO96r2MiAxTmeAqnGeElv0I1WS+wBWKGOrYd0M8JUq/Ewc3P1Z26yKeipi12ISmj+7pID29d54x2fVanCN5AkBqmVtUdGxGNji1TffWFyVZL8P17tHv6eXH1jBU5MF28gzFvR/2U/eMqB9clCZhaQUAFkNIzjUfLRnJN725Ll9c";
        X509Certificate xcrt = CryptUtil.generateX509Certificate(Base64.decode(serverCrtString.getBytes()));
        PrivateKey prk = CryptUtil.generatePrivateKey(Base64.decode(serverKeyString.getBytes()), "RSA");
        byte[] message = "hello".getBytes();
        System.out.println("message size(byte):" + message.length);
        byte[] encryptedData = RSA.encrypt(message, xcrt.getPublicKey().getEncoded());
        System.out.println("encryptedData size(byte):" + encryptedData.length);
        System.out.println("encryptedData:" + new String(Base64.encode(encryptedData)));
        System.out.println("encryptedData size(byte):" + BytesUtil.binary2hex(encryptedData).length());
    }
}

