/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.demo;

import com.lsy.baselib.crypto.manager.TrustManager;
import com.lsy.baselib.crypto.protocol.PKCS7Signature;
import com.lsy.baselib.crypto.protocol.TimeStamp;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.BytesUtil;
import com.lsy.baselib.crypto.util.CryptUtil;
import com.lsy.baselib.crypto.util.HexUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class SignatureDemo {
    public static void main(String[] args) throws Exception {
        TrustManager manager = TrustManager.getInstance();
        String serverCrtString = "MIIDJTCCAg2gAwIBAgIBMDANBgkqhkiG9w0BAQUFADAtMQswCQYDVQQGEwJDTjENMAsGA1UECwwEQ05DQjEPMA0GA1UEAwwGU0VSVkVSMB4XDTEwMDUwNzEwMzcxM1oXDTQwMDQyOTEwMzcxNFowLTELMAkGA1UEBhMCQ04xDTALBgNVBAsMBENOQ0IxDzANBgNVBAMMBlNFUlZFUjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALKuqUU+MUl1jR0pFqgWJ1pObBEW2D1tdnzTqRW/jPYATVTjI80QQ/LldE2+YD7WS8KRDO+Gs+AT/APxNrxfsLlliH4rofw4edcQX4l3rjOpsDuBw1NaVa5KlI8zPK8v7KkzSM5/6wG2s6MlOYCejBCwwCh1loWeRe7irzSgaxHpcJtzUwh6vIEvORBRDrrUyOqhpc13mjMEFSXqVEwK83P7MbnzJTIUFkEAwDk42vAYvUhJtg/rvq29aiBESAq7FKQEtEXI0fjSP6ZNv/7/hv3BTecATCVa+aebzGTr/6RtsoWDSdmHMsQCPdyFq93RCSmDkUKNI/L9p7glIJXMjKUCAwEAAaNQME4wHQYDVR0OBBYEFDr9AQi3d0gMba2lOUtpU81HHTvhMB8GA1UdIwQYMBaAFDr9AQi3d0gMba2lOUtpU81HHTvhMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBABqcgXuPocI8b1mkHuuFaHSBser9eNE5Gr0RABxwi1UMmoqZ0tjLMIEv7LzRAeGcnMiQ5++cmNfa8lHvp88v3kjDsLvkgzY2NZekxDAG8QmjthvElLGK0BRWrBwa77GbdieJydC+lqqglVA6Ix1Df0dHCG4AK3DC3Z9h8KxqjrcNZO4EKYmNbytYj8XWmzzfuw/mVPqEkgpAIVm/Q0O7XhM7lYm8GfZCpGNwQ44jmaea7QNWxvaIUpffqWC6spqz5SWwtcOGkSUTpOJ1YC2QHqhseQJMMmFpNY9+xOCPc79QjK0+qYf6zkfJmW6des+yy0V4uftCIsaULPAEOytCMo0=";
        String serverKeyString = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCyrqlFPjFJdY0dKRaoFidaTmwRFtg9bXZ806kVv4z2AE1U4yPNEEPy5XRNvmA+1kvCkQzvhrPgE/wD8Ta8X7C5ZYh+K6H8OHnXEF+Jd64zqbA7gcNTWlWuSpSPMzyvL+ypM0jOf+sBtrOjJTmAnowQsMAodZaFnkXu4q80oGsR6XCbc1MIeryBLzkQUQ661MjqoaXNd5ozBBUl6lRMCvNz+zG58yUyFBZBAMA5ONrwGL1ISbYP676tvWogREgKuxSkBLRFyNH40j+mTb/+/4b9wU3nAEwlWvmnm8xk6/+kbbKFg0nZhzLEAj3chavd0Qkpg5FCjSPy/ae4JSCVzIylAgMBAAECggEBAJxIKiM3D1LJ7x/nNTrVDZxt5RVZXs7zc+QgGM692GO9xeWOOVz9cgD78iqhbXroYiEOTzsdHSzLLeygyJggNekiRizcqvR4zRBu8LDCrenf7BVQHPBFnZUxBBjv3o73os4m3fJHbdv02c/DGjVF9woOHjQFDR9XXKFhQY8NFDj39zcec5FiBnxeq+srnsbGEc0VbJnfc7FW+g3/jeOq+ZZ9FQh55XqcG6Kq8xCXQ7/0XahlQJ9UCSzykDisdY3Sgij3gs7ptX7kxovP9KkR2P+xu2lBybP/u3M+PtM1SvCVx92vZCyFF+TOj2ulPiLxHE8dtG3uYYzvXVgV5pYp4M0CgYEA3bd70Sl3pksooGs9fE3ZD2CIryO3KTeBlt35fhzJg6Zx3/cM/6hFwE1nceuGupwmG2TQkFGBzHAa5Ws4uMpoocnG0Hs1UXjBK0GCfpo9C/lS6CUaJYpvkHlWFPg+PRFHvxg1OMbkbg5UxzdZ72tUBrTpgi1fqVzQx0PW0yYrK2MCgYEAzk+vhR+JCK+dL8cPlqYcDVg932JzWGuC8U4QxQU9RxVlpYCS2HcHKl0YCnqvgxlEeZebvv18PdRFtmngxyt0zmaG9LGKoEPIS0ZUIAy8Sk2qy9atxW7mZLlFesA3WIhmTzvp2BYHYf8Vn/AIYRDk/f0G6H4z6GkXM5/CfAagWlcCgYAvdu5M0sHImeJypUKeb9P+FL5uMAkwC6/0akTVGLiTNHjAZ5UizhVQm8F/g9pt7KvDxYtYufo9l+pKHvAfr0VDDX1AeH/rlxxTdEzJaZ+UBqYXCIpWaxKDLVaeWp6IWECxyi7qnrmcTfkcRN8+AA4W+Xfb5HbMPRB8+CrvPQaU3QKBgQCaulqZzYfZctPBZFqFknjRbU+h/FUjiCZBUVn0WTSW3i5IjIAVRleiZwVDvrVo7gdT5edRuwx11oCeCRQia64DqhMm6wxbm9pY0hr/mm2QkGU60Pusabry6Zx5LjWT+WA5pmZ/wC2zSjruo3e1TJVhA2Yt8ZB+impzNisHF3UlqwKBgALDzcN+Mr0S3VyjQbQyNC8K1Zvj391t2gfXvP4zQPdt8hbZU58wSazUACCAxTJHvW2SqT5vyowmKyXoCPlMlhb+2c7oN/elrLWPajLgRdFYb2O+Mcjn3bacUvNkkiElroi+6jVanzNthH6SrvSFZuO1oIaihfJ7iDfpF1XLvQSm";
        String clientCrtString = "MIIDtDCCAx2gAwIBAgIQJCsz+kYB9xdN7YB3oFjVkTANBgkqhkiG9w0BAQUFADAqMQswCQYDVQQGEwJDTjEbMBkGA1UEChMSQ0ZDQSBPcGVyYXRpb24gQ0EyMB4XDTEwMDcxNDA2MzcyMloXDTEzMDcxNDA2MzcyMlowgYQxCzAJBgNVBAYTAkNOMRswGQYDVQQKExJDRkNBIE9wZXJhdGlvbiBDQTIxDTALBgNVBAsTBENOQ0IxFDASBgNVBAsTC0VudGVycHJpc2VzMTMwMQYDVQQDFCowNDFAMDMzMDIyNjE5NjIxMjA4MjQwNkBsdnBlaXJvbmdAMDAwMDAwMDIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAM3h3fQiejlEW0DxXKEN6UpA4K7JUN8uNTknxgFacxB110hMzn9zuCANuYGMUcbPO4vvUYKEc2sUP/BfrmrSSCIFiv/RfCWbCNoINGDc2exSOba4oJoLS6A228TDfH1H7C8vs48tPtkWyZHV+2Cg7ZxX5buVNDeNf+0UpWWsca/JAgMBAAGjggF+MIIBejAfBgNVHSMEGDAWgBTwje2zQbv77wgeVQLDMTfvPBROzTAdBgNVHQ4EFgQU8utHCOlYsNfO4xz4rP6FOMXpiUgwCwYDVR0PBAQDAgXgMAwGA1UdEwQFMAMBAQAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMIH9BgNVHR8EgfUwgfIwVqBUoFKkUDBOMQswCQYDVQQGEwJDTjEbMBkGA1UEChMSQ0ZDQSBPcGVyYXRpb24gQ0EyMQwwCgYDVQQLEwNDUkwxFDASBgNVBAMTC2NybDEwNF8xOTkxMIGXoIGUoIGRhoGObGRhcDovL2NlcnQ4NjMuY2ZjYS5jb20uY246Mzg5L0NOPWNybDEwNF8xOTkxLE9VPUNSTCxPPUNGQ0EgT3BlcmF0aW9uIENBMixDPUNOP2NlcnRpZmljYXRlUmV2b2NhdGlvbkxpc3Q/YmFzZT9vYmplY3RjbGFzcz1jUkxEaXN0cmlidXRpb25Qb2ludDANBgkqhkiG9w0BAQUFAAOBgQCMGHfpOF0XerT59eajpFrktU83dJuD96a2GI6GGqPoQWs7stw5lJqDwNS+gx2cmge5xGPlh/Nn0UUYNz6UA2grRjo49Ch49luMmhAhfvBlY9MghfM9M5frtQIi2GIRAcd8a6iHMADjjkUjISgCqAvewBX1pIVZItYoG9hkT3NfEg==";
        X509Certificate serverCrt = null;
        X509Certificate clientCrt = null;
        PrivateKey serverKey = null;
        try {
            serverKey = CryptUtil.generatePrivateKey(Base64.decode(serverKeyString.getBytes()), "RSA");
            serverCrt = CryptUtil.generateX509Certificate(Base64.decode(serverCrtString.getBytes()));
            clientCrt = CryptUtil.generateX509Certificate(Base64.decode(clientCrtString.getBytes()));
            String trustDirectory = "C:\\b_Cert";
            manager.addTrustAuthority(trustDirectory);
            boolean ret = TrustManager.getInstance().addTrust(BytesUtil.bytesToString(serverCrtString.getBytes()));
            if (!ret) {
                System.out.println("\u6dfb\u52a0\u53ef\u4fe1\u8bc1\u4e66\u51fa\u9519");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        byte[] timeStamp = TimeStamp.makeTimeStamp("TIMESTAMP CNCB".getBytes(), serverCrt, serverKey);
        System.out.println("timestamp:" + Base64.encode(timeStamp));
        if (TimeStamp.verifyTimeStamp(timeStamp, serverCrt, serverKey)) {
            System.out.println("verify timestamp ok");
        } else {
            System.out.println("verify timestamp failure");
        }
        String message = "hello, \u4e16\u754c\uff01";
        CryptUtil.digest(message.getBytes(), "SHA-1");
        String signedMessage = null;
        try {
            signedMessage = new String(Base64.encode(PKCS7Signature.sign(message.getBytes(), serverKey, serverCrt, new X509Certificate[]{serverCrt}, true)));
            System.out.println("\u5bc6\u6587\u6570\u636e\u5927\u5c0f:" + signedMessage.getBytes().length);
            System.out.println("\u5bc6\u6587\u6570\u636e:" + signedMessage);
            signedMessage = "MIIE1gYJKoZIhvcNAQcCoIIExzCCBMMCAQExDjAMBggqhkiG9w0CBQUAMAsGCSqGSIb3DQEHAaCCA7YwggOyMIIDG6ADAgECAhB1UCREozjkiC1mAq/2m9+MMA0GCSqGSIb3DQEBBQUAMCoxCzAJBgNVBAYTAkNOMRswGQYDVQQKExJDRkNBIE9wZXJhdGlvbiBDQTIwHhcNMTAwOTA2MDkwMzQwWhcNMTUwOTA2MDkwMzQwWjCBgjELMAkGA1UEBhMCQ04xGzAZBgNVBAoTEkNGQ0EgT3BlcmF0aW9uIENBMjENMAsGA1UECxMEQ05DQjESMBAGA1UECxMJQ3VzdG9tZXJzMTMwMQYDVQQDFCowNDFAMDQ0NTI4MTE5NzgxMjA3MzcxM0BDQUlIQUlUQU9AMDAwMDAwMDEwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMGmFzata+zoLK33sWyMajZFcMeshx8erROSJoi2OzVyWn09Dqj2sEX/fG0Hj0Stq++R1Awvj0dndGQSVZWQwJ5clPePq6YRRiwA8TdD+ub7NhmJEKnGN3zt5Wwkl2nmEOSbIqyeI3DEem2Ycq2QkyOu9VuNmtTZ0h06ENuUzT7hAgMBAAGjggF+MIIBejAfBgNVHSMEGDAWgBTwje2zQbv77wgeVQLDMTfvPBROzTAdBgNVHQ4EFgQU+XtNNY/aync3JXw5GYpdCFLSq0kwCwYDVR0PBAQDAgXgMAwGA1UdEwQFMAMBAQAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMIH9BgNVHR8EgfUwgfIwVqBUoFKkUDBOMQswCQYDVQQGEwJDTjEbMBkGA1UEChMSQ0ZDQSBPcGVyYXRpb24gQ0EyMQwwCgYDVQQLEwNDUkwxFDASBgNVBAMTC2NybDEwMV82MTY5MIGXoIGUoIGRhoGObGRhcDovL2NlcnQ4NjMuY2ZjYS5jb20uY246Mzg5L0NOPWNybDEwMV82MTY5LE9VPUNSTCxPPUNGQ0EgT3BlcmF0aW9uIENBMixDPUNOP2NlcnRpZmljYXRlUmV2b2NhdGlvbkxpc3Q/YmFzZT9vYmplY3RjbGFzcz1jUkxEaXN0cmlidXRpb25Qb2ludDANBgkqhkiG9w0BAQUFAAOBgQAuMIND5GgaElt5pvZPln870O7t5HPcOIDgoHT0liUY+/chmJ6coRuAhcTniEJg+ehWoN5WyRaQijwmn0GPV46n5NdQSx7OkB8n0e0wFyC0UKxcIhQ9WB4Ki7GwaEjHmxTZJ/6hIaEyInaVCjT6PZvsxylwirhRBumb2W0C3vnEZTGB5jCB4wIBATA+MCoxCzAJBgNVBAYTAkNOMRswGQYDVQQKExJDRkNBIE9wZXJhdGlvbiBDQTICEHVQJESjOOSILWYCr/ab34wwDAYIKoZIhvcNAgUFADANBgkqhkiG9w0BAQEFAASBgLIVv1II8OernjF66kLBDnku35kbJFSYI2jfAflkgEbIdJ0XnFJQ09BS25RGcO2NBRcbUyqP8rDpFnF22PcVz6cZRx9kfMnfCctLVcN5yTndPoPWMatz9dyavCsUNAH8aavO30CURnDtjQUXG1Mqj/Kw6RZxA+bBu0Y0Gyj9I19C";
            X509Certificate certificate = null;
            certificate = PKCS7Signature.getCertification(Base64.decode(signedMessage.getBytes()));
            if (certificate == null) {
                System.out.println("\u4ece\u7b7e\u540d\u6570\u636e\u4e2d\u53d6\u8bc1\u4e66\u5931\u8d25");
                certificate = serverCrt;
            }
            PKCS7Signature.verifyDetachedSignature("dfe".getBytes(), Base64.decode(signedMessage.getBytes()), null);
            String crtDN = certificate.getSubjectX500Principal().getName();
            String crtSerial = HexUtil.binary2hex(certificate.getSerialNumber().toByteArray());
            String content = new String(PKCS7Signature.getSourceMessage(Base64.decode(signedMessage.getBytes())));
            System.out.println("\u8bc1\u4e66DN\t\t\uff1a\u3010" + crtDN + "\u3011");
            System.out.println("\u8bc1\u4e66\u5e8f\u5217\u53f7\t\uff1a\u3010" + crtSerial + "\u3011");
            System.out.println("\u660e\u6587\u6570\u636e\t\uff1a\u3010" + content + "\u3011");
        }
        catch (Exception se) {
            se.printStackTrace();
        }
    }
}

