/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.manager;

import com.lsy.baselib.crypto.exception.TrustManagerException;
import com.lsy.baselib.crypto.util.CryptUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import org.bouncycastle.util.encoders.Base64;

public class TrustManager {
    private HashMap hmTrustStore = null;
    private X509CRL crl = null;
    private String crlPath = null;
    private static TrustManager trustMan = null;

    private TrustManager() {
        if (this.hmTrustStore == null) {
            this.hmTrustStore = new HashMap();
        }
    }

    public static synchronized TrustManager getInstance() {
        if (trustMan == null) {
            trustMan = new TrustManager();
        }
        return trustMan;
    }

    public void addTrustedChain(X509Certificate[] trustedChain) throws TrustManagerException, CertificateExpiredException, CertificateNotYetValidException {
        if (trustedChain == null) {
            return;
        }
        int i = 0;
        while (i < trustedChain.length - 1) {
            this.checkValidity(trustedChain[i], trustedChain[i + 1]);
            ++i;
        }
        String subjectDN = trustedChain[trustedChain.length - 1].getSubjectDN().getName();
        try {
            trustedChain[trustedChain.length - 1].checkValidity(new Date());
        }
        catch (CertificateExpiredException e) {
            throw new TrustManagerException("\u8bc1\u4e66\u3010" + subjectDN + "\u3011\u5df2\u7ecf\u8fc7\u671f!");
        }
        catch (CertificateNotYetValidException e) {
            throw new TrustManagerException("\u8bc1\u4e66\u3010" + subjectDN + "\u3011\u5c1a\u672a\u751f\u6548!");
        }
        catch (Exception e) {
            throw new TrustManagerException("\u8bc1\u4e66\u3010" + subjectDN + "\u3011\u4e0d\u53ef\u4f7f\u7528!");
        }
        int i2 = 0;
        while (i2 < trustedChain.length) {
            this.hmTrustStore.put(trustedChain[i2].getSubjectX500Principal().getName(), trustedChain[i2]);
            ++i2;
        }
    }

    public void addTrustPath(X509Certificate[] trustPath) throws TrustManagerException, CertificateExpiredException, CertificateNotYetValidException {
        this.addTrustedChain(trustPath);
    }

    public void addTrustedDirectory(String trustedDirectory) throws TrustManagerException {
        if (trustedDirectory == null) {
            throw new TrustManagerException("\u8bbe\u7f6e\u4fe1\u4efb\u8bc1\u4e66\u94fe\u76ee\u5f55\u5931\u8d25\uff0c\u65e0\u6548\u7684\u53c2\u6570\u3002");
        }
        ByteArrayOutputStream baos = null;
        BufferedReader br = null;
        try {
            try {
                File file = new File(trustedDirectory);
                File[] files = file.listFiles(new CertFilenameFilter());
                int i = 0;
                while (i < files.length) {
                    br = new BufferedReader(new FileReader(files[i]));
                    baos = new ByteArrayOutputStream();
                    String line = br.readLine();
                    if (line.startsWith("-----BEGIN")) {
                        line = br.readLine();
                    }
                    do {
                        baos.write(line.getBytes());
                    } while ((line = br.readLine()) != null && !line.startsWith("-----END"));
                    X509Certificate[] certList = new X509Certificate[]{CryptUtil.generateX509Certificate(Base64.decode((byte[])baos.toByteArray()))};
                    this.addTrustedChain(certList);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new TrustManagerException("\u8bbe\u7f6e\u4fe1\u4efb\u8bc1\u4e66\u94fe\u76ee\u5f55\u5931\u8d25", e);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean addTrustAuthority(String trustDirectory) {
        boolean result = false;
        try {
            this.addTrustedDirectory(trustDirectory);
            result = true;
        }
        catch (TrustManagerException trustManagerException) {
            // empty catch block
        }
        return result;
    }

    public void addTrustedCertificate(byte[] base64EncodedCertificate) throws TrustManagerException {
        if (base64EncodedCertificate == null) {
            throw new TrustManagerException("\u6dfb\u52a0\u4fe1\u4efb\u8bc1\u4e66\u5931\u8d25\uff0c\u65e0\u6548\u7684\u53c2\u6570\u3002");
        }
        try {
            X509Certificate[] chain = new X509Certificate[]{CryptUtil.generateX509Certificate(Base64.decode((byte[])base64EncodedCertificate))};
            this.addTrustedChain(chain);
        }
        catch (Exception ex) {
            throw new TrustManagerException("\u6dfb\u52a0\u4fe1\u4efb\u8bc1\u4e66\u5931\u8d25", ex);
        }
    }

    public boolean addTrust(String trustContent) {
        boolean result = false;
        try {
            this.addTrustedCertificate(trustContent.getBytes());
            result = true;
        }
        catch (TrustManagerException trustManagerException) {
            // empty catch block
        }
        return result;
    }

    public void setCrlPath(String crlPath) {
        this.crlPath = crlPath;
        this.loadCrl();
    }

    public void verify(X509Certificate[] chain) throws TrustManagerException, CertificateExpiredException, CertificateNotYetValidException {
        if (chain == null || chain.length == 0) {
            throw new TrustManagerException("\u8bc1\u4e66\u94fe\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        int i = 0;
        while (i < chain.length - 1) {
            this.checkValidity(chain[i], chain[i + 1]);
            ++i;
        }
        String issuerPrincipal = chain[chain.length - 1].getIssuerX500Principal().getName();
        X509Certificate cert = (X509Certificate)this.hmTrustStore.get(issuerPrincipal);
        if (cert == null) {
            throw new TrustManagerException("\u8bc1\u4e66\u3010" + issuerPrincipal + "\u3011\u4e0d\u53ef\u4fe1\u4efb!");
        }
        this.checkValidity(chain[chain.length - 1], cert);
    }

    public void verify(X509Certificate certificate) throws TrustManagerException, CertificateExpiredException, CertificateNotYetValidException {
        X509Certificate[] chain = new X509Certificate[]{certificate};
        this.verify(chain);
    }

    private void checkValidity(X509Certificate userCert, X509Certificate issuerCert) throws TrustManagerException, CertificateExpiredException, CertificateNotYetValidException {
        Date datenow = new Date();
        String userSubjectDN = userCert.getSubjectDN().getName();
        try {
            userCert.checkValidity(datenow);
        }
        catch (CertificateExpiredException e) {
            throw new CertificateExpiredException("\u8bc1\u4e66\u3010" + userSubjectDN + "\u3011\u5df2\u7ecf\u8fc7\u671f!");
        }
        catch (CertificateNotYetValidException e) {
            throw new CertificateNotYetValidException("\u8bc1\u4e66\u3010" + userSubjectDN + "\u3011\u5c1a\u672a\u751f\u6548!");
        }
        catch (Exception e) {
            throw new TrustManagerException("\u8bc1\u4e66\u3010" + userSubjectDN + "\u3011\u4e0d\u53ef\u4f7f\u7528!");
        }
        try {
            userCert.verify(issuerCert.getPublicKey());
        }
        catch (Exception e) {
            throw new TrustManagerException("\u8bc1\u4e66\u3010" + userSubjectDN + "\u3011\u4e0d\u53ef\u4fe1\u4efb!");
        }
        if (this.crl != null) {
            if (this.crl.getNextUpdate().before(datenow)) {
                this.loadCrl();
            }
            if (this.crl.isRevoked(userCert)) {
                throw new TrustManagerException("\u8bc1\u4e66\u3010" + userSubjectDN + "\u3011\u5df2\u88ab\u540a\u9500!");
            }
        }
    }

    private void loadCrl() {
        FileInputStream fis = null;
        try {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                fis = new FileInputStream(this.crlPath);
                if (fis != null) {
                    this.crl = (X509CRL)factory.generateCRL(fis);
                }
            }
            catch (Exception exception) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class CertFilenameFilter
    implements FilenameFilter {
        private CertFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".crt");
        }
    }
}

