/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.processor;

import com.lsy.baselib.crypto.exception.EBCryptoProcessorException;
import com.lsy.baselib.crypto.exception.PKCS7SignatureException;
import com.lsy.baselib.crypto.exception.TrustManagerException;
import com.lsy.baselib.crypto.manager.TrustManager;
import com.lsy.baselib.crypto.protocol.PKCS7Signature;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import com.lsy.baselib.crypto.util.FileUtil;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;

public class EBCryptoProcessor {
    public static final String SERVER_PRIVATE_KEY_FILE_NAME = "ecserver.key";
    public static final String SERVER_PRIVATE_KEY_PASSWORD_FILE_NAME = "ecserver.pwd";
    public static final String SERVER_CERTIFICATE_REQUEST_FILE_NAME = "ecserver.csq";
    public static final String SERVER_CERTIFICATE_FILE_NAME = "ecserver.cer";
    public static final String SERVER_CERTIFICATE_PFX_FILE_NAME = "ecserver.pfx";
    public static final String SERVER_PRIVATE_KEY_STORE_PASSWORD = "cncbpwd";
    public static final String SERVER_PRIVATE_KEY_STORE_ALIAS = "ecserver";
    public static final String CLIENT_PRIVATE_KEY_FILE_NAME = "ecclient.key";
    public static final String CLIENT_PRIVATE_KEY_PASSWORD_FILE_NAME = "ecclient.pwd";
    public static final String CLIENT_CERTIFICATE_REQUEST_FILE_NAME = "ecclient.csq";
    public static final String CLIENT_CERTIFICATE_FILE_NAME = "ecclient.cer";
    public static final String CLIENT_CERTIFICATE_PFX_FILE_NAME = "ecclient.pfx";
    public static final String CLIENT_PRIVATE_KEY_STORE_PASSWORD = "cncbpwd";
    public static final String CLIENT_PRIVATE_KEY_STORE_ALIAS = "ecclient";
    public static final String CLIENT_CERTIFICATE_PFX_ENCODE_BASE64 = "BASE64";
    public static final String CLIENT_CERTIFICATE_PFX_ENCODE_DER = "DER";
    private PrivateKey signerPrivatekey = null;
    private X509Certificate signerCertificate = null;
    private TrustManager manager = TrustManager.getInstance();
    private char[] keyPassword = null;

    public void setSignerPrivatekey(byte[] base64EncodedPrivatekey, String keyPassword) throws EBCryptoProcessorException {
        try {
            this.signerPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), keyPassword.toCharArray());
        }
        catch (Exception e) {
            throw new EBCryptoProcessorException("\u8bbe\u7f6e\u7b7e\u540d\u79c1\u94a5\u5931\u8d25", e);
        }
    }

    public void setPrivatekeyPassword(String keyPassword) throws EBCryptoProcessorException {
        if (keyPassword == null) {
            throw new EBCryptoProcessorException("\u8bbe\u7f6e\u79c1\u94a5\u89e3\u5bc6\u5bc6\u7801\u5931\u8d25");
        }
        this.keyPassword = keyPassword.toCharArray();
    }

    public void setSignerCertificate(byte[] base64EncodedCertificate) throws EBCryptoProcessorException {
        try {
            this.signerCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCertificate));
        }
        catch (Exception e) {
            throw new EBCryptoProcessorException("\u8bbe\u7f6e\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
        }
    }

    public void addTrustedCertificate(byte[] base64EncodedCertificate) throws EBCryptoProcessorException {
        try {
            this.manager.addTrustedCertificate(base64EncodedCertificate);
        }
        catch (TrustManagerException tme) {
            throw new EBCryptoProcessorException("\u6dfb\u52a0\u4fe1\u4efb\u8bc1\u4e66\u5931\u8d25", tme);
        }
    }

    public void setCertificateDirectory(String certificateDirectory) throws EBCryptoProcessorException {
        if (certificateDirectory == null || "".equals(certificateDirectory)) {
            throw new EBCryptoProcessorException("\u65e0\u6548\u7684\u8bc1\u4e66\u76ee\u5f55\u53c2\u6570");
        }
        try {
            if (this.keyPassword == null) {
                this.keyPassword = new String(FileUtil.read4file(String.valueOf(certificateDirectory) + File.separator + SERVER_PRIVATE_KEY_PASSWORD_FILE_NAME)).toCharArray();
            }
            byte[] base64EncodedPrivatekey = FileUtil.read4file(String.valueOf(certificateDirectory) + File.separator + SERVER_PRIVATE_KEY_FILE_NAME);
            this.signerPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), this.keyPassword);
            int i = 0;
            while (i < this.keyPassword.length) {
                this.keyPassword[0] = '\u0000';
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6\u7b7e\u540d\u79c1\u94a5\u5931\u8d25");
            e.printStackTrace();
        }
        try {
            byte[] base64EncodedCertificate = FileUtil.read4file(String.valueOf(certificateDirectory) + File.separator + SERVER_CERTIFICATE_FILE_NAME);
            this.signerCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCertificate));
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25");
            e.printStackTrace();
        }
        try {
            this.manager.addTrustedDirectory(certificateDirectory);
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6\u4fe1\u4efb\u8bc1\u4e66\u94fe\u5931\u8d25");
            e.printStackTrace();
        }
    }

    public byte[] sign(byte[] orderMessage, boolean attachCertificatChain, boolean attachSourceMessage) throws EBCryptoProcessorException {
        byte[] base64EncodedOrderSignature = null;
        try {
            byte[] orderSignature = null;
            orderSignature = attachCertificatChain ? (attachSourceMessage ? PKCS7Signature.sign(orderMessage, this.signerPrivatekey, this.signerCertificate, new X509Certificate[]{this.signerCertificate}, true) : PKCS7Signature.sign(orderMessage, this.signerPrivatekey, this.signerCertificate, new X509Certificate[]{this.signerCertificate}, false)) : (attachSourceMessage ? PKCS7Signature.sign(orderMessage, this.signerPrivatekey, this.signerCertificate, null, true) : PKCS7Signature.sign(orderMessage, this.signerPrivatekey, this.signerCertificate, null, false));
            base64EncodedOrderSignature = Base64.encode(orderSignature);
        }
        catch (PKCS7SignatureException se) {
            throw new EBCryptoProcessorException("\u8ba2\u5355\u7b7e\u540d\u5931\u8d25", se);
        }
        return base64EncodedOrderSignature;
    }

    public byte[] verify(byte[] base64EncodedOrderSignature, byte[] message, byte[] base64EncodedCertificate) throws EBCryptoProcessorException {
        byte[] orderMessage = null;
        PublicKey publickey = null;
        try {
            if (base64EncodedCertificate != null) {
                X509Certificate cert = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCertificate));
                publickey = cert.getPublicKey();
            }
        }
        catch (Exception e) {
            throw new EBCryptoProcessorException("\u65e0\u6548\u7684\u9a8c\u8bc1\u8bc1\u4e66", e);
        }
        try {
            if (message == null) {
                if (base64EncodedCertificate == null) {
                    PKCS7Signature.verifyAttachedSignature(Base64.decode(base64EncodedOrderSignature), null);
                } else {
                    PKCS7Signature.verifyAttachedSignature(Base64.decode(base64EncodedOrderSignature), publickey);
                }
            } else if (base64EncodedCertificate == null) {
                PKCS7Signature.verifyDetachedSignature(message, Base64.decode(base64EncodedOrderSignature), null);
            } else {
                PKCS7Signature.verifyDetachedSignature(message, Base64.decode(base64EncodedOrderSignature), publickey);
            }
        }
        catch (Exception pe) {
            throw new EBCryptoProcessorException("\u65e0\u6548\u7684\u8ba2\u5355\u7b7e\u540d", pe);
        }
        try {
            if (base64EncodedCertificate == null) {
                this.manager.verify(PKCS7Signature.getSingerCertificate(Base64.decode(base64EncodedOrderSignature)));
            }
        }
        catch (Exception e) {
            throw new EBCryptoProcessorException("\u65e0\u6548\u7684\u8ba2\u5355\u7b7e\u540d\u8bc1\u4e66", e);
        }
        return orderMessage;
    }

    public byte[] getOrderMessage(byte[] orderSignature) throws EBCryptoProcessorException {
        byte[] orderMessage = null;
        try {
            orderMessage = PKCS7Signature.getSourceMessage(Base64.decode(orderSignature));
        }
        catch (PKCS7SignatureException pe) {
            throw new EBCryptoProcessorException("\u4ece\u8ba2\u5355\u7b7e\u540d\u4e2d\u83b7\u53d6\u8ba2\u5355\u539f\u6587\u5931\u8d25", pe);
        }
        return orderMessage;
    }

    public X509Certificate getSignerCertificate(byte[] orderSignature) throws EBCryptoProcessorException {
        X509Certificate singerCertificate = null;
        try {
            singerCertificate = PKCS7Signature.getSingerCertificate(Base64.decode(orderSignature));
        }
        catch (PKCS7SignatureException pe) {
            throw new EBCryptoProcessorException("\u4ece\u8ba2\u5355\u7b7e\u540d\u4e2d\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", pe);
        }
        return singerCertificate;
    }

    public static void main(String[] args) throws Exception {
        try {
            Date startime = new Date();
            EBCryptoProcessor processor = new EBCryptoProcessor();
            System.out.println("\u3010" + new Date(new Date().getTime() - startime.getTime()).getTime() + " ms" + "\u3011");
            String signercrt = "MIIDrDCCAxWgAwIBAgIQE/tf6esqTcS2jfVMlOzz4DANBgkqhkiG9w0BAQUFADAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMB4XDTA5MDUyMTAwMjIwMVoXDTEwMDUyMTAwMjIwMVowfTELMAkGA1UEBhMCQ04xFTATBgNVBAoTDENGQ0EgVEVTVCBDQTENMAsGA1UECxMEdGNjYjEUMBIGA1UECxMLRW50ZXJwcmlzZXMxMjAwBgNVBAMUKTA0MUAwMzUwNTgyMTk3OTA1MzEyMDExQGVjY2xpZW50QDAwMDAwMDE4MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCDNlCOg097j3E/V7LHqtkKhs2FH8EHTz2mZPLw+wJnhg+DudOyermP9yeqe29uXwfLQgkT8NSNf82AnXEUGQP/nYvIXj8hbtIhtjB+XLdaoRwZoCQxyFFxiueTztx0JQFKiLFCMv3YuHaep6ymwawNC3nfZpUSebGAdUt5UwC6sQIDAQABo4IBhDCCAYAwHwYDVR0jBBgwFoAURnLcJXKfAk5Vg7WA+Qvb6ZOz9EUwHQYDVR0OBBYEFP8Lm9Whc3ALnXIyuJZqmSYWAVkDMAsGA1UdDwQEAwIFoDAMBgNVHRMEBTADAQEAMDsGA1UdJQQ0MDIGCCsGAQUFBwMBBggrBgEFBQcDAgYIKwYBBQUHAwMGCCsGAQUFBwMEBggrBgEFBQcDCDCB5QYDVR0fBIHdMIHaME6gTKBKpEgwRjELMAkGA1UEBhMCQ04xFTATBgNVBAoTDENGQ0EgVEVTVCBDQTEMMAoGA1UECxMDQ1JMMRIwEAYDVQQDEwljcmwxMjdfNDEwgYeggYSggYGGf2xkYXA6Ly8yMTAuNzQuNDEuODc6Mzg5L0NOPWNybDEyN180MSxPVT1DUkwsTz1DRkNBIFRFU1QgQ0EsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwDQYJKoZIhvcNAQEFBQADgYEAb3W+O3FA9tckuzcLSX6vJTN7rYlPWB/nOkR0Svs56GaU4YaW2MQzIMCiwS0SCR3dyRMtVAMMa39n8IiJYCW34j5oPtk0Gh6kXslcNu/OCMR/+o7M9YDCw95IMm2nNa+/6q2otL51CNZzuurx878trIZGMOWZ3fovn1SAf4I4dV8=";
            String signerkey = "A1JTQY0y/p3ns1bYN0lYRhs3SJfwvzljJRMy0RxGmJup05Rimy/ijMZ8GahHF/a0pZaG/PcfONODA836mAbLqg1AjrlTOHucoOzFXvQ3m11yvJ9+v17P45w8sMBeaatBdBqJ6x12+X+Nk9Vqi5hPBsup+Qdaz886SkprdeknvqR+MsBVp8tE65okUnGG9fB2b7exd/hVFNQSPA1a4tS5GPCdR/leITpA8W1ojlSWgU9blJWnHMZ4snHRyC1qowMJg8c+4twRKsSPXmwsqkJ6vTUPixdYFYKZ28rrMFVtFGt2lC3FDPo93A5SkdS3JszyK4B90VVRi0FJmLB/XzCMwn2UImdSlG3SaRHEmFm++3RSTkfpllG+OmNxFoih5phcf0XLHn2QdwqTYtVXjJNH3X4RlcMrWPBNS7UVQVv6EZhXd5xOrNvmAW3BC/7R13SKPUY0TzJcg4OeU2Lba0gzivKodA8my1/NXCeM6avmPFdf72SwwpG0/v5FiTxsJ81vPQ5jXOg4fkiMBrPGd/EPqCUf7/CMDVJwIzH3v9AzEhSbJCCxFAgTEFmE98iDsz7J7LbzRPvdr7VkOdipzGYD+tIrzSwzsKpbGNa9yOypv3VNhb0VaB8I0XHAyKBlqWAIEAw3t2s+BZcwzRp3ZdlnJLOi5N6ezt33Va0xqWqOBjNjTEDf61CFkOWeuUX2QdEYIhv9W81Pl7Dq+25s674FgWLNOO2abvXo3fKgn0M5XPq1T2RxFYeHCYhMh4j+UIci7FBz5ZhXN+EG2AFz/GL45OIFXYPgsmMxP0O+CU48tVokaD/x0P9/dxQQ2Fn6tWEpRGO207C2ZA4M3W7DCZ1Tlerc47ONVARi6AU19g==";
            String keypasswd = "jsfhfP7";
            processor.setSignerCertificate(signercrt.getBytes());
            processor.setSignerPrivatekey(signerkey.getBytes(), keypasswd);
            System.out.println("\u3010" + new Date(new Date().getTime() - startime.getTime()).getTime() + " ms" + "\u3011");
            String message = "hello, \u4e16\u754c!";
            System.out.println(message);
            byte[] signedMessage = processor.sign(message.getBytes(), false, true);
            System.out.println("\u3010" + new Date(new Date().getTime() - startime.getTime()).getTime() + " ms" + "\u3011");
            System.out.println("signed messge size:" + signedMessage.length);
            System.out.println("signed messge:\n" + new String(signedMessage));
            String trustedcrt = "MIICezCCAeSgAwIBAgIEPPyMXjANBgkqhkiG9w0BAQUFADAgMQswCQYDVQQGEwJDTjERMA8GA1UEChMIQ0ZDQSBSQ0EwHhcNMDQwODEwMDgzNjM3WhcNMTQwNzI1MTYwMDAwWjAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYrs50M7hq8y0LzFjfN3UPQzGiBg1kLinPqJcSx7oRXey15WpLLMLthcfp9Gn/7uXmtNL6athr91YXzrB3Rcp53U3zqScGE9h2ktFQ3SNdZP6c/VSQ+27pAVxWRUC+F6pmUsno+jd1mftYjhKRV8yvCRpSV6HDzhLK83xbkoCfiQIDAQABo4G9MIG6MEIGA1UdHwQ7MDkwN6A1oDOkMTAvMQswCQYDVQQGEwJDTjERMA8GA1UEChMIQ0ZDQSBSQ0ExDTALBgNVBAMTBENSTDEwCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFACaNPJR+VMUYXRucqEG3seBcBu8MB0GA1UdDgQWBBRGctwlcp8CTlWDtYD5C9vpk7P0RTAMBgNVHRMEBTADAQH/MBkGCSqGSIb2fQdBAAQMMAobBFY2LjADAgSQMA0GCSqGSIb3DQEBBQUAA4GBAJ69l0Y1K+ayEvojzBHfzozMf0a0aQMaEbiil+RJQ8lvwWHZOeaRTcJOxyiPoQ5DZqhEusXavFPX4J/mE3H5PCnV5tF7tSO7vEguhs8m2IXxrOZCpKmCJVevNdV9x0m9eD629NVJGf683raMx39Ft4HQFaLT+EXbnSAWvYemPyOW";
            processor.addTrustedCertificate(trustedcrt.getBytes());
            processor.verify(signedMessage, null, signercrt.getBytes());
            System.out.println("verify signed messge ok");
            System.out.println("source messge:\n" + new String(processor.getOrderMessage(signedMessage)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

