/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.processor;

import com.lsy.baselib.crypto.exception.ECCryptoProcessorException;
import com.lsy.baselib.crypto.exception.PKCS7SignatureException;
import com.lsy.baselib.crypto.exception.TrustManagerException;
import com.lsy.baselib.crypto.manager.TrustManager;
import com.lsy.baselib.crypto.protocol.PKCS7Signature;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import com.lsy.baselib.crypto.util.FileUtil;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class ECCryptoProcessor {
    public static final String SERVER_PRIVATE_KEY_FILE_NAME = "ecserver.key";
    public static final String SERVER_PRIVATE_KEY_PASSWORD_FILE_NAME = "ecserver.pwd";
    public static final String SERVER_CERTIFICATE_REQUEST_FILE_NAME = "ecserver.csq";
    public static final String SERVER_CERTIFICATE_FILE_NAME = "ecserver.cer";
    public static final String SERVER_CERTIFICATE_PFX_FILE_NAME = "ecserver.pfx";
    public static final String SERVER_PRIVATE_KEY_STORE_PASSWORD = "cncbpwd";
    public static final String SERVER_PRIVATE_KEY_STORE_ALIAS = "ecserver";
    public static final String CLIENT_PRIVATE_KEY_FILE_NAME = "ecclient.key";
    public static final String CLIENT_PRIVATE_KEY_PASSWORD_FILE_NAME = "ecclient.pwd";
    public static final String CLIENT_CERTIFICATE_REQUEST_FILE_NAME = "ecclient.csq";
    public static final String CLIENT_CERTIFICATE_FILE_NAME = "ecclient.cer";
    public static final String CLIENT_CERTIFICATE_PFX_FILE_NAME = "ecclient.pfx";
    public static final String CLIENT_PRIVATE_KEY_STORE_PASSWORD = "cncbpwd";
    public static final String CLIENT_PRIVATE_KEY_STORE_ALIAS = "ecclient";
    public static final String CLIENT_CERTIFICATE_PFX_ENCODE_BASE64 = "BASE64";
    public static final String CLIENT_CERTIFICATE_PFX_ENCODE_DER = "DER";
    private PrivateKey signerPrivatekey = null;
    private X509Certificate signerCertificate = null;
    private TrustManager manager = TrustManager.getInstance();
    private char[] keyPassword = null;

    public void setSignerPrivatekey(byte[] base64EncodedPrivatekey, String keyPassword) throws ECCryptoProcessorException {
        try {
            this.signerPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), keyPassword.toCharArray());
        }
        catch (Exception e) {
            throw new ECCryptoProcessorException("\u8bbe\u7f6e\u7b7e\u540d\u79c1\u94a5\u5931\u8d25", e);
        }
    }

    public void setPrivatekeyPassword(String keyPassword) throws ECCryptoProcessorException {
        if (keyPassword == null) {
            throw new ECCryptoProcessorException("\u8bbe\u7f6e\u79c1\u94a5\u89e3\u5bc6\u5bc6\u7801\u5931\u8d25");
        }
        this.keyPassword = keyPassword.toCharArray();
    }

    public void setSignerCertificate(byte[] base64EncodedCertificate) throws ECCryptoProcessorException {
        try {
            this.signerCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCertificate));
        }
        catch (Exception e) {
            throw new ECCryptoProcessorException("\u8bbe\u7f6e\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
        }
    }

    public void addTrustedCertificate(byte[] base64EncodedCertificate) throws ECCryptoProcessorException {
        try {
            this.manager.addTrustedCertificate(base64EncodedCertificate);
        }
        catch (TrustManagerException tme) {
            throw new ECCryptoProcessorException("\u6dfb\u52a0\u4fe1\u4efb\u8bc1\u4e66\u5931\u8d25", tme);
        }
    }

    public void setCertificateDirectory(String certificateDirectory) throws ECCryptoProcessorException {
        if (certificateDirectory == null || "".equals(certificateDirectory)) {
            throw new ECCryptoProcessorException("\u65e0\u6548\u7684\u8bc1\u4e66\u76ee\u5f55\u53c2\u6570");
        }
        try {
            if (this.keyPassword == null) {
                this.keyPassword = new String(FileUtil.read4file(String.valueOf(certificateDirectory) + File.separator + SERVER_PRIVATE_KEY_PASSWORD_FILE_NAME)).toCharArray();
            }
            byte[] base64EncodedPrivatekey = FileUtil.read4file(String.valueOf(certificateDirectory) + File.separator + SERVER_PRIVATE_KEY_FILE_NAME);
            this.signerPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), this.keyPassword);
            int i = 0;
            while (i < this.keyPassword.length) {
                this.keyPassword[0] = '\u0000';
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6\u7b7e\u540d\u79c1\u94a5\u5931\u8d25");
            e.printStackTrace();
        }
        try {
            byte[] base64EncodedCertificate = FileUtil.read4file(String.valueOf(certificateDirectory) + File.separator + SERVER_CERTIFICATE_FILE_NAME);
            this.signerCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCertificate));
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25");
            e.printStackTrace();
        }
        try {
            this.manager.addTrustedDirectory(certificateDirectory);
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6\u4fe1\u4efb\u8bc1\u4e66\u94fe\u5931\u8d25");
            e.printStackTrace();
        }
    }

    public byte[] sign(byte[] orderMessage) throws ECCryptoProcessorException {
        byte[] base64EncodedOrderSignature = null;
        try {
            byte[] orderSignature = PKCS7Signature.sign(orderMessage, this.signerPrivatekey, this.signerCertificate, new X509Certificate[]{this.signerCertificate}, true);
            base64EncodedOrderSignature = Base64.encode(orderSignature);
        }
        catch (PKCS7SignatureException se) {
            throw new ECCryptoProcessorException("\u8ba2\u5355\u7b7e\u540d\u5931\u8d25", se);
        }
        return base64EncodedOrderSignature;
    }

    public byte[] verify(byte[] base64EncodedOrderSignature) throws ECCryptoProcessorException {
        byte[] orderMessage = null;
        try {
            PKCS7Signature.verifyAttachedSignature(Base64.decode(base64EncodedOrderSignature), null);
        }
        catch (PKCS7SignatureException pe) {
            throw new ECCryptoProcessorException("\u65e0\u6548\u7684\u8ba2\u5355\u7b7e\u540d", pe);
        }
        try {
            this.manager.verify(PKCS7Signature.getSingerCertificate(Base64.decode(base64EncodedOrderSignature)));
        }
        catch (Exception e) {
            throw new ECCryptoProcessorException("\u65e0\u6548\u7684\u8ba2\u5355\u7b7e\u540d\u8bc1\u4e66", e);
        }
        return orderMessage;
    }

    public byte[] getOrderMessage(byte[] orderSignature) throws ECCryptoProcessorException {
        byte[] orderMessage = null;
        try {
            orderMessage = PKCS7Signature.getSourceMessage(Base64.decode(orderSignature));
        }
        catch (PKCS7SignatureException pe) {
            throw new ECCryptoProcessorException("\u4ece\u8ba2\u5355\u7b7e\u540d\u4e2d\u83b7\u53d6\u8ba2\u5355\u539f\u6587\u5931\u8d25", pe);
        }
        return orderMessage;
    }

    public X509Certificate getSignerCertificate(byte[] orderSignature) throws ECCryptoProcessorException {
        X509Certificate singerCertificate = null;
        try {
            singerCertificate = PKCS7Signature.getSingerCertificate(Base64.decode(orderSignature));
        }
        catch (PKCS7SignatureException pe) {
            throw new ECCryptoProcessorException("\u4ece\u8ba2\u5355\u7b7e\u540d\u4e2d\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", pe);
        }
        return singerCertificate;
    }
}

