/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.processor;

import com.lsy.baselib.crypto.exception.VoucherCryptoProcessorException;
import com.lsy.baselib.crypto.protocol.DigitalEnvelope;
import com.lsy.baselib.crypto.protocol.PKCS7Signature;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class VoucherCryptoProcessor {
    public static String SECURITY_PROVIDER = "BC";

    static {
        if (Security.getProvider(SECURITY_PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public byte[] encode(byte[] voucher, byte[] base64EncodedSenderPrivatekey, char[] password, byte[] base64EncodedSenderCertificate, byte[] base64EncodedReceiverCertificate) throws VoucherCryptoProcessorException {
        byte[] encodedData = null;
        try {
            PrivateKey senderPrivatekey = null;
            if (password != null) {
                senderPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedSenderPrivatekey), password);
                int i = 0;
                while (i < password.length) {
                    password[0] = '\u0000';
                    ++i;
                }
            } else {
                senderPrivatekey = CryptUtil.generatePrivateKey(Base64.decode(base64EncodedSenderPrivatekey), "RSA");
            }
            X509Certificate ssoCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedSenderCertificate));
            X509Certificate targetCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedReceiverCertificate));
            byte[] signedData = PKCS7Signature.sign(voucher, senderPrivatekey, ssoCertificate, new X509Certificate[]{ssoCertificate}, true);
            encodedData = Base64.encode(DigitalEnvelope.encode(signedData, targetCertificate.getPublicKey().getEncoded()));
        }
        catch (Exception e) {
            throw new VoucherCryptoProcessorException("fail to create voucher", e);
        }
        if (encodedData == null) {
            throw new VoucherCryptoProcessorException("unknown error inside encode function");
        }
        return encodedData;
    }

    public byte[] decode(byte[] voucher, byte[] base64EncodedReceiverPrivatekey, char[] password, byte[] base64EncodedSenderCertificate) throws VoucherCryptoProcessorException {
        byte[] decodedData = null;
        try {
            PrivateKey receiverPrivatekey = null;
            if (password != null) {
                receiverPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedReceiverPrivatekey), password);
                int i = 0;
                while (i < password.length) {
                    password[0] = '\u0000';
                    ++i;
                }
            } else {
                receiverPrivatekey = CryptUtil.generatePrivateKey(Base64.decode(base64EncodedReceiverPrivatekey), "RSA");
            }
            X509Certificate senderCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedSenderCertificate));
            byte[] signedData = DigitalEnvelope.decode(Base64.decode(voucher), receiverPrivatekey.getEncoded());
            PKCS7Signature.verifyAttachedSignature(signedData, senderCertificate.getPublicKey());
            decodedData = PKCS7Signature.getSourceMessage(signedData);
        }
        catch (Exception e) {
            throw new VoucherCryptoProcessorException("fail to verify voucher", e);
        }
        if (decodedData == null) {
            throw new VoucherCryptoProcessorException("unknown error inside decode function");
        }
        return decodedData;
    }
}

