/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.protocol;

import com.lsy.baselib.crypto.algorithm.DESede;
import com.lsy.baselib.crypto.algorithm.RSA;
import com.lsy.baselib.crypto.exception.DigitalEnvelopeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DigitalEnvelope {
    public static String SECURITY_PROVIDER = "BC";

    static {
        if (Security.getProvider(SECURITY_PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static byte[] encode(byte[] data, byte[] key) throws DigitalEnvelopeException {
        byte[] encodedData = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream dos = null;
        try {
            try {
                byte[] desedekey = DESede.createKey(DESede.DESEDE_KEY_168_BIT);
                byte[] encryptedData = DESede.encrypt(data, desedekey);
                byte[] encryptedKey = RSA.encrypt(desedekey, key);
                baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                ((DataOutputStream)dos).writeInt(encryptedData.length);
                dos.write(encryptedData);
                ((DataOutputStream)dos).writeInt(encryptedKey.length);
                dos.write(encryptedKey);
                ((DataOutputStream)dos).flush();
                encodedData = baos.toByteArray();
            }
            catch (Exception e) {
                throw new DigitalEnvelopeException("fail to encapsulate digital envelope", e);
            }
        }
        finally {
            block16: {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (Exception e1) {
                        if (baos == null) break block16;
                        try {
                            baos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (encodedData == null) {
            throw new DigitalEnvelopeException("unknown error inside encode function");
        }
        return encodedData;
    }

    public static byte[] decode(byte[] data, byte[] key) throws DigitalEnvelopeException {
        byte[] decodedData = null;
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        try {
            try {
                bais = new ByteArrayInputStream(data);
                dis = new DataInputStream(bais);
                int encryptedDataLength = ((DataInputStream)dis).readInt();
                byte[] encryptedData = new byte[encryptedDataLength];
                ((DataInputStream)dis).readFully(encryptedData);
                int encryptedKeyLength = ((DataInputStream)dis).readInt();
                byte[] encryptedKey = new byte[encryptedKeyLength];
                ((DataInputStream)dis).readFully(encryptedKey);
                byte[] decryptedKey = RSA.decrypt(encryptedKey, key);
                byte[] decryptedData = DESede.decrypt(encryptedData, decryptedKey);
                decodedData = decryptedData;
            }
            catch (Exception e) {
                throw new DigitalEnvelopeException("fail to decapsulate digital envelope", e);
            }
        }
        finally {
            block16: {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (Exception e1) {
                        if (bais == null) break block16;
                        try {
                            bais.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (decodedData == null) {
            throw new DigitalEnvelopeException("unknown error inside decode function");
        }
        return decodedData;
    }
}

