/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.protocol;

import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKCS1Signature {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static boolean verify(byte[] signData, byte[] signedData, String algorithm, byte[] cert) {
        boolean verifyRet = true;
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(new ByteArrayInputStream(cert));
            Signature oSign = Signature.getInstance(algorithm, "BC");
            oSign.initVerify(oCert.getPublicKey());
            oSign.update(signData);
            verifyRet = oSign.verify(signedData);
        }
        catch (Exception e) {
            verifyRet = false;
        }
        return verifyRet;
    }
}

