/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.protocol;

import com.lsy.baselib.crypto.exception.PKCS7SignatureException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKCS7Signature {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static byte[] sign(byte[] message, PrivateKey signerPrivatekey, X509Certificate signerCertificate, X509Certificate[] chain, boolean attach) throws PKCS7SignatureException {
        byte[] signedMessage = null;
        try {
            CMSSignedDataGenerator cms = new CMSSignedDataGenerator();
            cms.addSigner(signerPrivatekey, signerCertificate, CMSSignedDataGenerator.DIGEST_SHA1);
            ArrayList<X509Certificate> listchain = new ArrayList<X509Certificate>();
            if (chain != null) {
                int i = 0;
                while (i < chain.length) {
                    listchain.add(chain[i]);
                    ++i;
                }
            }
            CertStore cstore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(listchain), "BC");
            cms.addCertificatesAndCRLs(cstore);
            CMSProcessableByteArray msg = new CMSProcessableByteArray(message);
            CMSSignedData cmsSignedData = cms.generate((CMSProcessable)msg, attach, "BC");
            signedMessage = cmsSignedData.getEncoded();
        }
        catch (Exception e) {
            throw new PKCS7SignatureException("\u5bf9\u6d88\u606f\u8fdb\u884c\u7b7e\u540d\u5931\u8d25", e);
        }
        return signedMessage;
    }

    public static void verifyAttachedSignature(byte[] signedMessage, PublicKey signerPublickey) throws PKCS7SignatureException {
        if (signedMessage == null) {
            throw new PKCS7SignatureException("\u6d88\u606f\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            CMSSignedData cms = new CMSSignedData(signedMessage);
            CertStore certStore = cms.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInfoStore = cms.getSignerInfos();
            Collection signerCollection = signerInfoStore.getSigners();
            for (SignerInformation signerInfo : signerCollection) {
                if (signerPublickey == null) {
                    Collection<? extends Certificate> certCollection = certStore.getCertificates((CertSelector)signerInfo.getSID());
                    Iterator<? extends Certificate> certificateItertor = certCollection.iterator();
                    if (certificateItertor.hasNext()) {
                        X509Certificate signcert = (X509Certificate)certificateItertor.next();
                        if (signerInfo.verify(signcert.getPublicKey(), "BC")) continue;
                        throw new PKCS7SignatureException("\u4f7f\u7528\u6d88\u606f\u7b7e\u540d\u4e2d\u81ea\u5e26\u7684\u8bc1\u4e66\u94fe\u8fdb\u884c\u9a8c\u7b7e\u5931\u8d25\uff01");
                    }
                    throw new PKCS7SignatureException("\u6d88\u606f\u7b7e\u540d\u4e2d\u6ca1\u6709\u5305\u542b\u7b7e\u540d\u8bc1\u4e66\uff01");
                }
                if (signerInfo.verify(signerPublickey, "BC")) continue;
                throw new PKCS7SignatureException("\u4f7f\u7528\u4f20\u5165\u7684\u516c\u94a5\u9a8c\u7b7e\u5931\u8d25");
            }
        }
        catch (PKCS7SignatureException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PKCS7SignatureException("\u9a8c\u8bc1\u5e26\u539f\u6587\u7684\u6d88\u606f\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static boolean verifyDetachedSignature(byte[] message, byte[] signedMessage, PublicKey signerPublickey) {
        boolean result = false;
        if (message == null) {
            return result;
        }
        if (signedMessage == null) {
            return result;
        }
        try {
            CMSSignedDataParser parser = new CMSSignedDataParser(new CMSTypedStream((InputStream)new ByteArrayInputStream(message)), signedMessage);
            parser.getSignedContent().drain();
            CertStore certStore = parser.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersStore = parser.getSignerInfos();
            Collection signers = signersStore.getSigners();
            for (SignerInformation signerInfo : signers) {
                if (signerPublickey == null) {
                    Collection<? extends Certificate> certCollection = certStore.getCertificates((CertSelector)signerInfo.getSID());
                    Iterator<? extends Certificate> certificateItertor = certCollection.iterator();
                    if (certificateItertor.hasNext()) {
                        X509Certificate signcert = (X509Certificate)certificateItertor.next();
                        if (signerInfo.verify(signcert.getPublicKey(), "BC")) continue;
                        throw new PKCS7SignatureException("\u4f7f\u7528\u6d88\u606f\u7b7e\u540d\u4e2d\u81ea\u5e26\u7684\u8bc1\u4e66\u94fe\u8fdb\u884c\u9a8c\u7b7e\u5931\u8d25");
                    }
                    throw new PKCS7SignatureException("\u4f7f\u7528\u6d88\u606f\u7b7e\u540d\u4e2d\u81ea\u5e26\u7684\u8bc1\u4e66\u94fe\u8fdb\u884c\u9a8c\u7b7e\u5931\u8d25");
                }
                if (signerInfo.verify(signerPublickey, "BC")) continue;
                throw new PKCS7SignatureException("\u4f7f\u7528\u4f20\u5165\u7684\u516c\u94a5\u9a8c\u7b7e\u5931\u8d25");
            }
            result = true;
        }
        catch (PKCS7SignatureException pe) {
            pe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static X509Certificate getSingerCertificate(byte[] signedMessage) throws PKCS7SignatureException {
        X509Certificate signerCertificate = null;
        try {
            SignerInformation signerInfo;
            Collection<? extends Certificate> certCollection;
            Iterator<? extends Certificate> certificateItertor;
            CMSSignedData signedDataParser = new CMSSignedData(signedMessage);
            CertStore certStore = signedDataParser.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersStore = signedDataParser.getSignerInfos();
            Collection signers = signersStore.getSigners();
            Iterator signerIterator = signers.iterator();
            if (signerIterator.hasNext() && (certificateItertor = (certCollection = certStore.getCertificates((CertSelector)(signerInfo = (SignerInformation)signerIterator.next()).getSID())).iterator()).hasNext()) {
                signerCertificate = (X509Certificate)certificateItertor.next();
            }
        }
        catch (Exception e) {
            throw new PKCS7SignatureException("\u4ece\u6d88\u606f\u7b7e\u540d\u4e2d\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25", e);
        }
        return signerCertificate;
    }

    public static X509Certificate getCertification(byte[] signedMessage) {
        X509Certificate signcert = null;
        try {
            signcert = PKCS7Signature.getSingerCertificate(signedMessage);
        }
        catch (PKCS7SignatureException pse) {
            pse.printStackTrace();
        }
        return signcert;
    }

    public static byte[] getSourceMessage(byte[] signedMessage) throws PKCS7SignatureException {
        byte[] message = null;
        try {
            CMSSignedData signedDataParser = new CMSSignedData(signedMessage);
            message = (byte[])signedDataParser.getSignedContent().getContent();
        }
        catch (Exception e) {
            throw new PKCS7SignatureException("\u4ece\u6d88\u606f\u7b7e\u540d\u4e2d\u83b7\u53d6\u6d88\u606f\u539f\u6587\u5931\u8d25", e);
        }
        return message;
    }
}

