/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.protocol;

import com.lsy.baselib.crypto.exception.TimeStampException;
import com.lsy.baselib.crypto.util.BytesUtil;
import com.lsy.baselib.crypto.util.CryptUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class TimeStamp {
    private static long INTERVAL_TIME = 600000L;

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static byte[] makeTimeStamp(byte[] hash, String base64Crt, String base64Pvk, long intervalTime) throws TimeStampException {
        PrivateKey signerPvk = null;
        X509Certificate signerCrt = null;
        try {
            signerPvk = CryptUtil.generatePrivateKey(Base64.decode((byte[])base64Pvk.getBytes()), "RSA");
            signerCrt = CryptUtil.generateX509Certificate(Base64.decode((byte[])base64Crt.getBytes()));
        }
        catch (Exception e) {
            throw new TimeStampException("\u65e0\u6548\u6570\u5b57\u8bc1\u4e66", e);
        }
        return TimeStamp.makeTimeStamp(hash, signerCrt, signerPvk, intervalTime);
    }

    public static byte[] makeTimeStamp(byte[] hash, String base64Crt, String base64Pvk) throws TimeStampException {
        return TimeStamp.makeTimeStamp(hash, base64Crt, base64Pvk, INTERVAL_TIME);
    }

    public static byte[] makeTimeStamp(byte[] hash, X509Certificate signerCrt, PrivateKey signerPvk, long intervalTime) throws TimeStampException {
        if (signerPvk == null) {
            throw new TimeStampException("\u65e0\u6548\u7b7e\u540d\u79c1\u94a5");
        }
        if (hash == null) {
            hash = "".getBytes();
        }
        byte[] timestamp = null;
        String signdate = String.valueOf(new Date().getTime());
        String abatedate = String.valueOf(new Date().getTime() + intervalTime);
        ByteArrayOutputStream baos = null;
        try {
            try {
                CMSSignedDataGenerator cms = new CMSSignedDataGenerator();
                cms.addSigner(signerPvk, signerCrt, CMSSignedDataGenerator.DIGEST_SHA1);
                ArrayList listchain = new ArrayList();
                CertStore certstore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(listchain), "BC");
                cms.addCertificatesAndCRLs(certstore);
                baos = new ByteArrayOutputStream();
                baos.write(BytesUtil.intToBytes(hash.length));
                baos.write(hash);
                baos.write(BytesUtil.intToBytes(signdate.length()));
                baos.write(signdate.getBytes());
                baos.write(BytesUtil.intToBytes(abatedate.length()));
                baos.write(abatedate.getBytes());
                CMSProcessableByteArray msg = new CMSProcessableByteArray(baos.toByteArray());
                CMSSignedData signedData = cms.generate((CMSProcessable)msg, true, "BC");
                timestamp = signedData.getEncoded();
            }
            catch (Exception e) {
                throw new TimeStampException("\u7b7e\u540d\u5931\u8d25", e);
            }
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        return timestamp;
    }

    public static byte[] makeTimeStamp(byte[] hash, X509Certificate signerCrt, PrivateKey signerPvk) throws TimeStampException {
        return TimeStamp.makeTimeStamp(hash, signerCrt, signerPvk, INTERVAL_TIME);
    }

    public static boolean verifyTimeStamp(byte[] timeStamp, String base64Crt, String base64Pvk) throws TimeStampException {
        PrivateKey signerPvk = null;
        X509Certificate signerCrt = null;
        try {
            signerPvk = CryptUtil.generatePrivateKey(Base64.decode((byte[])base64Pvk.getBytes()), "RSA");
            signerCrt = CryptUtil.generateX509Certificate(Base64.decode((byte[])base64Crt.getBytes()));
        }
        catch (Exception e) {
            throw new TimeStampException("\u65e0\u6548\u6570\u5b57\u8bc1\u4e66", e);
        }
        return TimeStamp.verifyTimeStamp(timeStamp, signerCrt, signerPvk);
    }

    public static boolean verifyTimeStamp(byte[] timeStamp, X509Certificate signerCrt, PrivateKey signerPvk) throws TimeStampException {
        boolean ret = false;
        if (signerPvk == null || signerCrt == null) {
            throw new TimeStampException("\u65e0\u6548\u7b7e\u540d\u6570\u5b57\u8bc1\u4e66");
        }
        ByteArrayInputStream bais = null;
        try {
            try {
                CMSSignedData cms = new CMSSignedData(timeStamp);
                SignerInformationStore signerInfoStore = cms.getSignerInfos();
                Collection signerCollection = signerInfoStore.getSigners();
                for (SignerInformation signerInfo : signerCollection) {
                    if (!signerInfo.verify(signerCrt.getPublicKey(), "BC")) {
                        throw new TimeStampException("\u65f6\u95f4\u6233\u7b7e\u540d\u65e0\u6548!");
                    }
                    byte[] baContent = (byte[])cms.getSignedContent().getContent();
                    bais = new ByteArrayInputStream(baContent);
                    byte[] baLength = new byte[4];
                    bais.read(baLength);
                    byte[] baHashValue = new byte[BytesUtil.bytesToInt(baLength)];
                    bais.read(baHashValue);
                    bais.read(baLength);
                    byte[] baSigntime = new byte[BytesUtil.bytesToInt(baLength)];
                    bais.read(baSigntime);
                    bais.read(baLength);
                    byte[] baAbatetime = new byte[BytesUtil.bytesToInt(baLength)];
                    bais.read(baAbatetime);
                    if (new Date().getTime() <= Long.parseLong(new String(baAbatetime))) continue;
                    throw new TimeStampException("\u65f6\u95f4\u6233\u5df2\u7ecf\u8fc7\u671f!");
                }
                ret = true;
            }
            catch (TimeStampException tse) {
                throw tse;
            }
            catch (Exception e) {
                throw new TimeStampException("\u65e0\u6548\u7684\u65f6\u95f4\u6233!", e);
            }
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }
}

