/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class BytesUtil {
    private static long bytesToLong(byte[] ba) {
        if (8 != ba.length) {
            return -1L;
        }
        long a = (long)ba[0] << 56 | (long)ba[1] << 48 & 0xFFFFFFFFFFFFFFL | (long)ba[2] << 40 & 0xFFFFFFFFFFFFL | (long)ba[3] << 32 & 0xFFFFFFFFFFL | (long)ba[4] << 24 & 0xFFFFFFFFL | (long)ba[5] << 16 & 0xFFFFFFL | (long)ba[6] << 8 & 0xFFFFL | (long)ba[7] & 0xFFL;
        return a;
    }

    public static int bytesToInt(byte[] ba) {
        if (4 != ba.length) {
            return -1;
        }
        int a = ba[0] << 24 | ba[1] << 16 & 0xFFFFFF | ba[2] << 8 & 0xFFFF | ba[3] & 0xFF;
        return a;
    }

    private static short bytesToShort(byte[] ba) {
        if (2 != ba.length) {
            return -1;
        }
        short a = (short)((short)ba[0] << 8 | (short)ba[1] & 0xFF);
        return a;
    }

    public static String bytesToString(byte[] ba) {
        String stream = "";
        try {
            stream = new String(ba, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            stream = new String(ba);
        }
        return stream;
    }

    public static long getLongFromBytes(byte[] ba, int idx) {
        if (idx + 8 > ba.length) {
            return -1L;
        }
        byte[] baLong = new byte[8];
        System.arraycopy(ba, idx, baLong, 0, 8);
        return BytesUtil.bytesToLong(baLong);
    }

    public static int getIntFromBytes(byte[] ba, int idx) {
        if (idx + 4 > ba.length) {
            return -1;
        }
        byte[] baInt = new byte[4];
        System.arraycopy(ba, idx, baInt, 0, 4);
        return BytesUtil.bytesToInt(baInt);
    }

    public static short getShortFromBytes(byte[] ba, int idx) {
        if (idx + 2 > ba.length) {
            return -1;
        }
        byte[] baInt = new byte[2];
        System.arraycopy(ba, idx, baInt, 0, 2);
        return BytesUtil.bytesToShort(baInt);
    }

    public static String getStringFromBytes(byte[] ba, int idx, int length) {
        byte[] baRet = new byte[length];
        System.arraycopy(ba, idx, baRet, 0, length);
        return BytesUtil.bytesToString(baRet);
    }

    public static byte[] longToBytes(long value) {
        byte[] b = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return b;
    }

    public static byte[] intToBytes(int value) {
        byte[] b = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return b;
    }

    public static byte[] shortToBytes(short value) {
        byte[] b = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return b;
    }

    public static byte[] stringToBytes(String value) {
        byte[] baStream = null;
        try {
            baStream = value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            baStream = value.getBytes();
        }
        return baStream;
    }

    public static void setLongInBytes(long value, byte[] ba, int idx) {
        if (idx + 8 > ba.length) {
            return;
        }
        byte[] baLong = BytesUtil.longToBytes(value);
        System.arraycopy(baLong, 0, ba, idx, 8);
    }

    public static void setIntInBytes(int value, byte[] ba, int idx) {
        if (idx + 4 > ba.length) {
            return;
        }
        byte[] baInt = BytesUtil.intToBytes(value);
        System.arraycopy(baInt, 0, ba, idx, 4);
    }

    public static void setShortInBytes(short value, byte[] ba, int idx) {
        if (idx + 2 > ba.length) {
            return;
        }
        byte[] baShort = BytesUtil.shortToBytes(value);
        System.arraycopy(baShort, 0, ba, idx, 2);
    }

    public static void setStringInBytes(String value, byte[] ba, int idx) {
        if (value == null || "".equals(value) || idx + value.length() > ba.length) {
            return;
        }
        byte[] baString = BytesUtil.stringToBytes(value);
        System.arraycopy(baString, 0, ba, idx, value.length());
    }

    public static byte[] linkByteArray(byte[] bufDes, byte[] bufSrc, int pos, int srcLength) {
        int lenDes = bufDes.length;
        if (pos + srcLength > bufSrc.length) {
            srcLength = bufSrc.length - pos + 1;
        }
        byte[] bufRet = new byte[lenDes + srcLength];
        System.arraycopy(bufDes, 0, bufRet, 0, lenDes);
        System.arraycopy(bufSrc, pos, bufRet, lenDes, srcLength);
        return bufRet;
    }

    public static String binary2hex(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            sb.append(BytesUtil.byte2hex(data[i]));
            ++i;
        }
        return sb.toString();
    }

    public static String byte2hex(byte b) {
        return "" + "0123456789abcdef".charAt(0xF & b >> 4) + "0123456789abcdef".charAt(b & 0xF);
    }

    public static byte hex2byte(String hex) {
        byte r = 0;
        char c = hex.charAt(0);
        byte l = (byte)(c >= 'A' ? c - 65 + 10 : c - 48);
        c = hex.charAt(1);
        r = (byte)(c >= 'A' ? c - 65 + 10 : c - 48);
        return (byte)((l & 0xF) << 4 | r & 0xF);
    }

    public static byte[] hex2binary(String hex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < hex.length()) {
            baos.write(BytesUtil.hex2byte(hex.substring(i)));
            ++i;
            ++i;
        }
        return baos.toByteArray();
    }

    public static long ntohl(byte[] in) {
        long out = 0L;
        out |= (long)(in[3] & 0xFF);
        out |= (long)(in[2] << 8 & 0xFF00);
        out |= (long)(in[1] << 16 & 0xFF0000);
        return out |= (long)(in[0] << 24 & 0xFF000000);
    }

    public static byte[] htonl(long hl) {
        byte[] nbytes = new byte[]{(byte)((hl & 0xFFFFFFFFFF000000L) >> 24), (byte)((hl & 0xFF0000L) >> 16), (byte)((hl & 0xFF00L) >> 8), (byte)(hl & 0xFFL)};
        return nbytes;
    }
}

