/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.util;

import com.lsy.baselib.crypto.exception.CipherUtilException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.BasicOCSPRespGenerator;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.CertificateStatus;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.OCSPRespGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public class CryptUtil {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyPair generateKeyPair(String algorithm, String length, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyGen = null;
        keyGen = provider != null ? KeyPairGenerator.getInstance(algorithm, provider) : KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(Integer.valueOf(length));
        return keyGen.generateKeyPair();
    }

    public static SecretKey generateKey(String algorithm, String length, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyGenerator kg = null;
        kg = provider != null ? KeyGenerator.getInstance(algorithm, provider) : KeyGenerator.getInstance(algorithm);
        kg.init(Integer.valueOf(length));
        return kg.generateKey();
    }

    public static X509Certificate generateSelfSignedCertificate(KeyPair kp, String subject, byte[] serial, String algorithm, String validity, String provider) throws Exception {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.reset();
        certGen.setSerialNumber(new BigInteger(serial));
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(subject, ",");
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
        }
        while (st.hasMoreElements()) {
            sb.insert(0, ",");
            sb.insert(0, st.nextElement());
        }
        certGen.setIssuerDN(new X509Name(sb.toString()));
        certGen.setNotBefore(new Date(System.currentTimeMillis()));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 86400000L * (long)Integer.valueOf(validity).intValue()));
        certGen.setSubjectDN(new X509Name(sb.toString()));
        certGen.setPublicKey(kp.getPublic());
        certGen.setSignatureAlgorithm(algorithm);
        certGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(kp.getPublic()));
        certGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(kp.getPublic()));
        certGen.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(true));
        X509Certificate cert = null;
        cert = provider != null ? certGen.generate(kp.getPrivate(), provider, new SecureRandom()) : certGen.generate(kp.getPrivate(), new SecureRandom());
        cert.checkValidity(new Date());
        cert.verify(kp.getPublic());
        PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)cert;
        bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString("CITIC"));
        return CryptUtil.generateX509Certificate(cert.getEncoded());
    }

    public static PKCS10CertificationRequest generatePKCS10CertificateRequest(KeyPair kp, String userdn, String algorithm, String provider) throws Exception {
        PKCS10CertificationRequest certRequest = null;
        certRequest = provider != null ? new PKCS10CertificationRequest(algorithm, new X509Name(userdn), kp.getPublic(), null, kp.getPrivate(), provider) : new PKCS10CertificationRequest(algorithm, new X509Name(userdn), kp.getPublic(), null, kp.getPrivate());
        return certRequest;
    }

    public static PKCS10CertificationRequest generatePKCS10CertificateRequest(byte[] data) throws Exception {
        return new PKCS10CertificationRequest(data);
    }

    public static X509Certificate generateX509Certificate(String subject, PKCS10CertificationRequest request, X509Certificate cacer, PrivateKey caprk, String serial, int days, String provider) throws Exception {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.reset();
        certGen.setSerialNumber(new BigInteger(serial));
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(cacer.getSubjectDN().getName().toString(), ",");
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
        }
        while (st.hasMoreElements()) {
            sb.insert(0, ",");
            sb.insert(0, st.nextElement());
        }
        certGen.setIssuerDN(new X509Name(sb.toString()));
        certGen.setNotBefore(new Date(System.currentTimeMillis()));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 86400000L * (long)days));
        if (subject == null) {
            certGen.setSubjectDN(request.getCertificationRequestInfo().getSubject());
        } else {
            sb = new StringBuffer();
            st = new StringTokenizer(subject, ",");
            if (st.hasMoreElements()) {
                sb.append(st.nextElement());
            }
            while (st.hasMoreElements()) {
                sb.insert(0, ",");
                sb.insert(0, st.nextElement());
            }
            certGen.setSubjectDN(new X509Name(sb.toString()));
        }
        certGen.setPublicKey(request.getPublicKey());
        certGen.setSignatureAlgorithm(cacer.getSigAlgName());
        certGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(request.getPublicKey()));
        certGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(cacer));
        certGen.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(false));
        certGen.addExtension(X509Extensions.KeyUsage, false, (DEREncodable)new KeyUsage(184));
        X509Certificate cert = null;
        cert = provider != null ? certGen.generate(caprk, provider, new SecureRandom()) : certGen.generate(caprk, new SecureRandom());
        cert.checkValidity(new Date());
        cert.verify(cacer.getPublicKey());
        PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)cert;
        bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString("reserving ..."));
        return CryptUtil.generateX509Certificate(cert.getEncoded());
    }

    public static PublicKey generatePublicKey(byte[] bytes, String keypairAlgorithm) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance(keypairAlgorithm);
        PublicKey publickey = keyFactory.generatePublic(keySpec);
        return publickey;
    }

    public static PrivateKey generatePrivateKey(byte[] bytes, String keypairAlgorithm) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance(keypairAlgorithm);
        PrivateKey privatekey = keyFactory.generatePrivate(keySpec);
        return privatekey;
    }

    public static PrivateKey generatePrivateKey(InputStream is, String keypairAlgorithm) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[2048];
        while (is.read(data) > 0) {
            baos.write(data);
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(baos.toByteArray());
        KeyFactory keyFactory = KeyFactory.getInstance(keypairAlgorithm);
        PrivateKey privatekey = keyFactory.generatePrivate(keySpec);
        return privatekey;
    }

    public static X509Certificate generateX509Certificate(byte[] bytes) throws Exception {
        if (bytes == null) {
            throw new Exception("fail to generate X509 certificate");
        }
        X509Certificate cer = null;
        ByteArrayInputStream bais = null;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try {
            bais = new ByteArrayInputStream(bytes);
            cer = (X509Certificate)cf.generateCertificate(bais);
        }
        finally {
            if (bais != null) {
                bais.close();
            }
        }
        return cer;
    }

    public static X509Certificate generateX509Certificate(InputStream is) throws Exception {
        if (is == null) {
            throw new Exception("fail to generate X509 certificate");
        }
        X509Certificate cer = null;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try {
            cer = (X509Certificate)cf.generateCertificate(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return cer;
    }

    public static byte[] generatePKCS12(Certificate[] chain, PrivateKey privatekey, String alias, char[] keypassword, char[] keystorepassword, String provider) throws Exception {
        KeyStore store = KeyStore.getInstance("PKCS12", provider);
        store.load(null, null);
        if (privatekey == null) {
            store.setCertificateEntry(alias, chain[0]);
        } else {
            store.setKeyEntry(alias, privatekey, keypassword, chain);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        store.store(baos, keystorepassword);
        return baos.toByteArray();
    }

    public static byte[] generateJKS(Certificate[] chain, PrivateKey privatekey, String alias, char[] keypassword, char[] keystorepassword, String provider) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        store.load(null, null);
        if (privatekey == null) {
            store.setCertificateEntry(alias, chain[0]);
        } else {
            int i = 0;
            while (i < chain.length) {
                System.out.println("chain[" + i + "] [" + ((X509Certificate)chain[i]).getSubjectDN().getName() + "]");
                ++i;
            }
            store.setKeyEntry(alias, privatekey, keypassword, chain);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        store.store(baos, keystorepassword);
        return baos.toByteArray();
    }

    public static KeyStore generatePKCS12(byte[] bytes, char[] password, String alias, String provider) throws Exception {
        KeyStore store = KeyStore.getInstance("PKCS12", provider);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        store.load(bais, password);
        return store;
    }

    public static KeyStore generateJKS(byte[] bytes, char[] password, String alias, String provider) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        store.load(bais, password);
        return store;
    }

    public static OCSPReq generateOCSPRequest(X509Certificate reqcert, X509Certificate cacert, X509Certificate[] chain, PrivateKey privatekey, String requestorDN, boolean flag, String provider) throws Exception {
        OCSPReqGenerator gen = new OCSPReqGenerator();
        CertificateID id = new CertificateID("1.3.14.3.2.26", cacert, reqcert.getSerialNumber());
        gen.addRequest(id);
        if (requestorDN != null) {
            gen.setRequestorName(new GeneralName(4, (ASN1Encodable)new X509Principal(requestorDN)));
        }
        if (flag) {
            Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
            Vector<X509Extension> values = new Vector<X509Extension>();
            oids.addElement(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
            values.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(new byte[16])));
            gen.setRequestExtensions(new X509Extensions(oids, values));
        }
        OCSPReq req = null;
        req = privatekey != null ? gen.generate(chain[0].getSigAlgName(), privatekey, chain, provider) : gen.generate();
        return req;
    }

    public static OCSPReq generateOCSPRequest(byte[] bytes) throws Exception {
        return new OCSPReq(bytes);
    }

    public static OCSPResp generateOCSPResponse(int respstatus, CertificateID certID, CertificateStatus certstatus, X509Certificate[] chain, PrivateKey pk, String provider) throws Exception {
        BasicOCSPRespGenerator brespgen = new BasicOCSPRespGenerator(chain[0].getPublicKey());
        brespgen.addResponse(certID, null);
        BasicOCSPResp bresp = brespgen.generate(chain[0].getSigAlgName(), pk, chain, new Date(System.currentTimeMillis()), provider);
        OCSPRespGenerator ocspgen = new OCSPRespGenerator();
        return ocspgen.generate(respstatus, (Object)bresp);
    }

    public static OCSPResp generateOCSPResponse(byte[] bytes) throws Exception {
        return new OCSPResp(bytes);
    }

    public static X509CRL generateX509CRL(byte[] data) throws CRLException {
        X509CRL crl = null;
        ByteArrayInputStream bais = null;
        if (data != null) {
            CertificateFactory cf = null;
            try {
                try {
                    cf = CertificateFactory.getInstance("X.509");
                    bais = new ByteArrayInputStream(data);
                    crl = (X509CRL)cf.generateCRL(bais);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (bais != null) {
                            bais.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return crl;
    }

    public static boolean checkValidity(X509Certificate user, X509Certificate issuer) {
        boolean result = false;
        Date datenow = new Date();
        try {
            user.checkValidity(datenow);
            user.verify(issuer.getPublicKey());
            result = true;
        }
        catch (CertificateExpiredException e) {
            System.out.println("Expired");
        }
        catch (CertificateNotYetValidException e) {
            System.out.println("Too early");
        }
        catch (Exception e) {
            System.out.println("not valid");
        }
        return result;
    }

    public static byte[] digest(byte[] message, String algorithm) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, "BC");
        messageDigest.update(message);
        return messageDigest.digest();
    }

    public static byte[] encryptPrivateKey(PrivateKey privatekey, char[] password) throws CipherUtilException {
        byte[] encryptedData = null;
        ByteArrayOutputStream baos = null;
        int iterations = 1000;
        try {
            try {
                byte[] salt = new byte[8];
                Random random = new Random();
                random.nextBytes(salt);
                PBEKeySpec keySpec = new PBEKeySpec(password);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithSHAAndTwofish-CBC");
                SecretKey key = keyFactory.generateSecret(keySpec);
                PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterations);
                Cipher cipher = Cipher.getInstance("PBEWithSHAAndTwofish-CBC");
                cipher.init(1, (Key)key, paramSpec);
                byte[] encryptedPrivatekey = cipher.doFinal(privatekey.getEncoded());
                baos = new ByteArrayOutputStream();
                byte[] algorithm = privatekey.getAlgorithm().getBytes();
                baos.write((byte)algorithm.length);
                baos.write(algorithm);
                baos.write(salt);
                baos.write(encryptedPrivatekey);
                encryptedData = baos.toByteArray();
                baos.close();
            }
            catch (Exception e) {
                throw new CipherUtilException("\u4f7f\u7528\u57fa\u4e8e\u53e3\u4ee4\u7684\u52a0\u5bc6\u65b9\u6cd5\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25", e);
            }
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        return encryptedData;
    }

    public static PrivateKey decryptPrivateKey(byte[] encryptedPrivatekey, char[] password) throws CipherUtilException {
        return CryptUtil.decryptPrivateKey(new ByteArrayInputStream(encryptedPrivatekey), password);
    }

    public static PrivateKey decryptPrivateKey(InputStream isEncryptedPrivatekey, char[] password) throws CipherUtilException {
        PrivateKey privatekey = null;
        int iterations = 1000;
        try {
            try {
                byte[] salt = new byte[8];
                byte[] algorithm = null;
                byte l = 0;
                int size = 0;
                size = isEncryptedPrivatekey.available();
                isEncryptedPrivatekey.read(salt, 0, 1);
                l = salt[0];
                algorithm = new byte[l];
                isEncryptedPrivatekey.read(algorithm, 0, l);
                isEncryptedPrivatekey.read(salt, 0, 8);
                byte[] remainingCipherData = new byte[size - 8 - 1 - l];
                isEncryptedPrivatekey.read(remainingCipherData, 0, size - 8 - 1 - l);
                PBEKeySpec keySpec = new PBEKeySpec(password);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithSHAAndTwofish-CBC");
                SecretKey key = keyFactory.generateSecret(keySpec);
                PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterations);
                Cipher cipher = Cipher.getInstance("PBEWithSHAAndTwofish-CBC");
                cipher.init(2, (Key)key, paramSpec);
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(cipher.doFinal(remainingCipherData));
                KeyFactory factory = KeyFactory.getInstance(new String(algorithm));
                privatekey = factory.generatePrivate(spec);
            }
            catch (Exception e) {
                throw new CipherUtilException("\u4f7f\u7528\u57fa\u4e8e\u53e3\u4ee4\u7684\u52a0\u5bc6\u65b9\u6cd5\u89e3\u5bc6\u79c1\u94a5\u5931\u8d25", e);
            }
        }
        finally {
            try {
                if (isEncryptedPrivatekey != null) {
                    isEncryptedPrivatekey.close();
                }
            }
            catch (Exception exception) {}
        }
        return privatekey;
    }

    public static void encrypt(String infile, String outfile, PublicKey publickey, String provider) throws Exception {
        if (infile == null || infile.equals("") || outfile == null || outfile.equals("")) {
            return;
        }
        boolean flag = false;
        if (infile.equals(outfile)) {
            outfile = "~.tmp";
            flag = true;
        }
        DataOutputStream output = null;
        FileInputStream input = null;
        CipherOutputStream cos = null;
        try {
            output = new DataOutputStream(new FileOutputStream(outfile));
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            rsaCipher.init(1, publickey);
            KeyGenerator rijndaelKeyGenerator = KeyGenerator.getInstance("Rijndael", provider);
            rijndaelKeyGenerator.init(128);
            SecretKey rijndaelKey = rijndaelKeyGenerator.generateKey();
            byte[] encodedKeyBytes = rsaCipher.doFinal(rijndaelKey.getEncoded());
            output.writeInt(encodedKeyBytes.length);
            output.write(encodedKeyBytes);
            SecureRandom random = new SecureRandom();
            byte[] iv = new byte[16];
            random.nextBytes(iv);
            output.write(iv);
            IvParameterSpec spec = new IvParameterSpec(iv);
            Cipher symmetricCipher = Cipher.getInstance("Rijndael/CBC/PKCS5Padding", provider);
            symmetricCipher.init(1, (Key)rijndaelKey, spec);
            cos = new CipherOutputStream(output, symmetricCipher);
            input = new FileInputStream(infile);
            int theByte = 0;
            while ((theByte = input.read()) != -1) {
                cos.write(theByte);
            }
        }
        finally {
            block33: {
                try {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (cos != null) {
                                cos.close();
                            }
                            break block33;
                        }
                        catch (Exception exception2) {}
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (cos != null) {
                            cos.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (cos != null) {
                        cos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (flag) {
            File f = new File(infile);
            f.delete();
            f = new File(outfile);
            f.renameTo(new File(infile));
        }
    }

    public static byte[] encrypt(byte[] data, PublicKey publickey, String provider) throws Exception {
        ByteArrayOutputStream output = null;
        DataOutputStream dos = null;
        CipherOutputStream cos = null;
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            rsaCipher.init(1, publickey);
            KeyGenerator rijndaelKeyGenerator = KeyGenerator.getInstance("Rijndael", provider);
            rijndaelKeyGenerator.init(128);
            SecretKey rijndaelKey = rijndaelKeyGenerator.generateKey();
            byte[] encodedKeyBytes = rsaCipher.doFinal(rijndaelKey.getEncoded());
            output = new ByteArrayOutputStream();
            dos = new DataOutputStream(output);
            dos.writeInt(encodedKeyBytes.length);
            dos.write(encodedKeyBytes);
            SecureRandom random = new SecureRandom();
            byte[] iv = new byte[16];
            random.nextBytes(iv);
            dos.write(iv);
            IvParameterSpec spec = new IvParameterSpec(iv);
            Cipher symmetricCipher = Cipher.getInstance("Rijndael/CBC/PKCS5Padding", provider);
            symmetricCipher.init(1, (Key)rijndaelKey, spec);
            cos = new CipherOutputStream(dos, symmetricCipher);
            cos.write(data);
        }
        finally {
            try {
                if (cos != null) {
                    cos.close();
                }
            }
            catch (Exception exception) {}
        }
        return output.toByteArray();
    }

    public static void decrypt(String infile, String outfile, PrivateKey privatekey, String provider) throws Exception {
        if (infile == null || infile.equals("") || outfile == null || outfile.equals("")) {
            return;
        }
        boolean flag = false;
        if (infile.equals(outfile)) {
            outfile = "~.tmp";
            flag = true;
        }
        DataInputStream dis = null;
        CipherInputStream cis = null;
        FileOutputStream fos = null;
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            rsaCipher.init(2, privatekey);
            dis = new DataInputStream(new FileInputStream(infile));
            byte[] encryptedKeyBytes = new byte[dis.readInt()];
            dis.readFully(encryptedKeyBytes);
            byte[] rijdaelKeyBytes = rsaCipher.doFinal(encryptedKeyBytes);
            SecretKeySpec rijndaelKey = new SecretKeySpec(rijdaelKeyBytes, "Rijndael");
            byte[] iv = new byte[16];
            dis.read(iv);
            IvParameterSpec spec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("Rijndael/CBC/PKCS5Padding", provider);
            cipher.init(2, (Key)rijndaelKey, spec);
            cis = new CipherInputStream(dis, cipher);
            fos = new FileOutputStream(outfile);
            int theByte = 0;
            while ((theByte = cis.read()) != -1) {
                fos.write(theByte);
            }
        }
        finally {
            block33: {
                try {
                    try {
                        if (cis != null) {
                            cis.close();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            break block33;
                        }
                        catch (Exception exception2) {}
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (flag) {
            File f = new File(infile);
            f.delete();
            f = new File(outfile);
            f.renameTo(new File(infile));
        }
    }

    public static byte[] decrypt(byte[] data, PrivateKey privatekey, String provider) throws Exception {
        ByteArrayInputStream is = null;
        DataInputStream dis = null;
        CipherInputStream cis = null;
        ByteArrayOutputStream os = null;
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            rsaCipher.init(2, privatekey);
            is = new ByteArrayInputStream(data);
            dis = new DataInputStream(is);
            byte[] encryptedKeyBytes = new byte[dis.readInt()];
            dis.readFully(encryptedKeyBytes);
            byte[] rijdaelKeyBytes = rsaCipher.doFinal(encryptedKeyBytes);
            SecretKeySpec rijndaelKey = new SecretKeySpec(rijdaelKeyBytes, "Rijndael");
            byte[] iv = new byte[16];
            dis.read(iv);
            IvParameterSpec spec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("Rijndael/CBC/PKCS5Padding", provider);
            cipher.init(2, (Key)rijndaelKey, spec);
            cis = new CipherInputStream(dis, cipher);
            os = new ByteArrayOutputStream();
            int theByte = 0;
            while ((theByte = cis.read()) != -1) {
                os.write(theByte);
            }
        }
        finally {
            try {
                if (cis != null) {
                    cis.close();
                }
            }
            catch (Exception exception) {}
        }
        return os.toByteArray();
    }

    public static byte[] digest(byte[] message, String algorithm, String provider) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, provider);
        messageDigest.update(message);
        return messageDigest.digest();
    }

    public static byte[] sign(byte[] data, PrivateKey privatekey, String algorithm, boolean attach, String provider) throws Exception {
        Signature sign = Signature.getInstance(algorithm, provider);
        sign.initSign(privatekey);
        sign.update(data);
        byte[] signature = sign.sign();
        if (!attach) {
            return signature;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(algorithm.length());
        dos.write(algorithm.getBytes());
        dos.writeInt(signature.length);
        dos.write(signature);
        dos.writeInt(data.length);
        dos.write(data);
        dos.close();
        return baos.toByteArray();
    }

    public static boolean verify(byte[] data, PublicKey publickey, String provider) throws Exception {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        byte[] algorithm = new byte[dis.readInt()];
        dis.readFully(algorithm);
        byte[] signature = new byte[dis.readInt()];
        dis.readFully(signature);
        byte[] source = new byte[dis.readInt()];
        dis.readFully(source);
        return CryptUtil.verify(source, signature, publickey, new String(algorithm), provider);
    }

    public static boolean verify(byte[] source, byte[] signature, PublicKey publickey, String algorithm, String provider) throws Exception {
        Signature sign = Signature.getInstance(algorithm, provider);
        sign.initVerify(publickey);
        sign.update(source);
        return sign.verify(signature);
    }
}

