/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.util;

import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import com.lsy.baselib.crypto.util.FileUtil;
import com.lsy.baselib.crypto.util.StoreUtil;
import java.io.File;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ECClientUtil {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Integer> hmSwitch = new HashMap<String, Integer>();
        hmSwitch.put("pki", Integer.valueOf(String.valueOf(1)));
        hmSwitch.put("request", Integer.valueOf(String.valueOf(11)));
        hmSwitch.put("convert", Integer.valueOf(String.valueOf(12)));
        if (args.length > 0) {
            block0 : switch ((Integer)hmSwitch.get(args[0].toLowerCase())) {
                case 1: {
                    if (args.length > 1) {
                        switch ((Integer)hmSwitch.get(args[1].toLowerCase())) {
                            case 11: {
                                Vector<String> requestParameters = new Vector<String>();
                                int i = 2;
                                while (i < args.length) {
                                    requestParameters.add(args[i]);
                                    ++i;
                                }
                                ECClientUtil.request(requestParameters);
                                break block0;
                            }
                            case 12: {
                                Vector<String> convertParameters = new Vector<String>();
                                int i = 2;
                                while (i < args.length) {
                                    convertParameters.add(args[i]);
                                    ++i;
                                }
                                ECClientUtil.convert(convertParameters);
                                break block0;
                            }
                        }
                        ECClientUtil.usage();
                        break;
                    }
                    ECClientUtil.usage();
                    break;
                }
                default: {
                    ECClientUtil.usage();
                    break;
                }
            }
        } else {
            ECClientUtil.usage();
        }
    }

    public static void usage() {
        System.out.println("Usage: \uff08\u8bc1\u4e66\u5de5\u5177\uff09");
        System.out.println("    com.cncb.crypto.utils.ECUserUtil PKI REQUEST [-ATTRIBUTE=VALUE, [-ATTRIBUTE=VALUE]], \u5176\u4e2dATTRIBUTE\u5b9a\u4e49\u5982\u4e0b\uff1a");
        System.out.println("\t01\u3001keyAlgorithm: \u5bc6\u94a5\u7b97\u6cd5\u3002\u9ed8\u8ba4\u503c\u4e3a\"RSA\"\u3002");
        System.out.println("\t02\u3001strength: \u5bc6\u94a5\u5f3a\u5ea6\u3002\u9ed8\u8ba4\u503c\u4e3a1024\u4f4d\u3002");
        System.out.println("\t03\u3001signatureAlgorithm: \u7b7e\u540d\u7b97\u6cd5\u3002\u9ed8\u8ba4\u503c\u4e3a\"SHA1ithRSAEncryption\"\u3002");
        System.out.println("\t04\u3001privatekeyFile: \u79c1\u94a5\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.key\"\u3002");
        System.out.println("\t05\u3001crtrequestFile: \u8bc1\u4e66\u8bf7\u6c42\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.csq\"\u3002");
        System.out.println("\t06\u3001passwordFile: \u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.pwd\"\u3002");
        System.out.println("\n");
        System.out.println("\tExample: CNCB PKI REQUEST -strength=2048");
        System.out.println("    com.cncb.crypto.utils.ECUserUtil PKI CONVERT [-ATTRIBUTE=VALUE, [-ATTRIBUTE=VALUE]], \u5176\u4e2dATTRIBUTE\u5b9a\u4e49\u5982\u4e0b\uff1a");
        System.out.println("\t01\u3001privatekeyFile: \u79c1\u94a5\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.key\"\u3002");
        System.out.println("\t02\u3001certificateFile: \u8bc1\u4e66\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.cer\"\u3002");
        System.out.println("\t03\u3001passwordFile: \u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.pwd\"\u3002");
        System.out.println("\t04\u3001pfxFile: PFX\u8bc1\u4e66\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.pfx\"\u3002");
        System.out.println("\t05\u3001encodeType: PFX\u8bc1\u4e66\u6587\u4ef6\u7f16\u7801\u683c\u5f0f\uff0c\u5305\u62ecBASE64\u548cDER\u4e24\u79cd\u683c\u5f0f\u3002\u9ed8\u8ba4\u503c\u4e3aBASE64\u7f16\u7801\u3002");
        System.out.println("\n");
        System.out.println("\tExample: CNCB PKI CONVERT");
        System.exit(0);
    }

    public static void request(Vector parameters) {
        String subject = "CN=ECSERVER";
        String keyAlgorithm = "RSA";
        String strength = "1024";
        String signatureAlgorithm = "SHA1WithRSAEncryption";
        String privatekeyFile = "ecclient.key";
        String crtquestFile = "ecclient.csq";
        String passwordFile = "ecclient.pwd";
        String pfxAlias = "ecclient";
        String storePassword = "cncbpwd";
        HashMap<String, String> hmParameters = new HashMap<String, String>();
        int i = 0;
        while (i < parameters.size()) {
            String parameter = (String)parameters.get(i);
            if (parameter.charAt(0) == '-' && parameter.indexOf("=") > 1) {
                String attribute = parameter.substring(1, parameter.indexOf("=")).toLowerCase();
                String value = parameter.substring(parameter.indexOf("=") + 1);
                hmParameters.put(attribute, value);
                if ("subject".equalsIgnoreCase(attribute)) {
                    subject = value;
                } else if ("keyAlgorithm".equalsIgnoreCase(attribute)) {
                    keyAlgorithm = value;
                } else if ("strength".equalsIgnoreCase(attribute)) {
                    strength = value;
                } else if ("signatureAlgorithm".equalsIgnoreCase(attribute)) {
                    signatureAlgorithm = value;
                } else if ("privatekeyFile".equalsIgnoreCase(attribute)) {
                    privatekeyFile = value;
                } else if ("crtquestFile".equalsIgnoreCase(attribute)) {
                    crtquestFile = value;
                } else if ("passwordFile".equalsIgnoreCase(attribute)) {
                    passwordFile = value;
                } else if ("pfxAlias".equalsIgnoreCase(attribute)) {
                    pfxAlias = value;
                }
            } else {
                ECClientUtil.usage();
            }
            ++i;
        }
        System.out.print("Operating ...");
        try {
            KeyPair kp = CryptUtil.generateKeyPair(keyAlgorithm, strength, "BC");
            X509Certificate selfSignedCrt = CryptUtil.generateSelfSignedCertificate(kp, subject, "0".getBytes(), signatureAlgorithm, "365", "BC");
            PKCS10CertificationRequest request = CryptUtil.generatePKCS10CertificateRequest(kp, subject, signatureAlgorithm, "BC");
            Random r = new Random();
            String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            String pwd = "";
            int j = 0;
            while (j < 7) {
                pwd = String.valueOf(pwd) + chars.charAt(r.nextInt(chars.length()));
                ++j;
            }
            byte[] encryptedPrivatekey = CryptUtil.encryptPrivateKey(kp.getPrivate(), pwd.toCharArray());
            String datetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            File oldFile = new File(passwordFile);
            File newFile = new File(String.valueOf(passwordFile) + "." + datetime);
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
            }
            FileUtil.save2file(pwd.getBytes(), passwordFile);
            oldFile = new File(crtquestFile);
            newFile = new File(String.valueOf(crtquestFile) + "." + datetime);
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
            }
            FileUtil.save2file(Base64.encode(request.getEncoded()), crtquestFile);
            oldFile = new File(privatekeyFile);
            newFile = new File(String.valueOf(privatekeyFile) + "." + datetime);
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
            }
            FileUtil.save2file(Base64.encode(encryptedPrivatekey), privatekeyFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("ok");
    }

    public static void convert(Vector parameters) {
        String privatekeyFile = "ecclient.key";
        String certificateFile = "ecclient.cer";
        String passwordFile = "ecclient.pwd";
        String pfxAlias = "ecclient";
        String pfxFile = "ecclient.pfx";
        String encodeType = "BASE64";
        HashMap<String, String> hmParameters = new HashMap<String, String>();
        int i = 0;
        while (i < parameters.size()) {
            String parameter = (String)parameters.get(i);
            if (parameter.charAt(0) == '-' && parameter.indexOf("=") > 1) {
                String attribute = parameter.substring(1, parameter.indexOf("=")).toLowerCase();
                String value = parameter.substring(parameter.indexOf("=") + 1);
                hmParameters.put(attribute, value);
                if ("privatekeyFile".equalsIgnoreCase(attribute)) {
                    privatekeyFile = value;
                } else if ("certificateFile".equalsIgnoreCase(attribute)) {
                    certificateFile = value;
                } else if ("passwordFile".equalsIgnoreCase(attribute)) {
                    passwordFile = value;
                } else if ("pfxFile".equalsIgnoreCase(attribute)) {
                    pfxFile = value;
                } else if ("encodeType".equalsIgnoreCase(attribute)) {
                    encodeType = value;
                }
            } else {
                ECClientUtil.usage();
            }
            ++i;
        }
        System.out.print("Operating ...");
        try {
            byte[] privatekeyBytes = FileUtil.read4file(privatekeyFile);
            byte[] privatekeyPwd = FileUtil.read4file(passwordFile);
            byte[] certificateBytes = FileUtil.read4file(certificateFile);
            PrivateKey privatekey = CryptUtil.decryptPrivateKey(Base64.decode(privatekeyBytes), new String(privatekeyPwd).toCharArray());
            X509Certificate certificate = CryptUtil.generateX509Certificate(Base64.decode(certificateBytes));
            byte[] pfxStoreBytes = StoreUtil.create(new X509Certificate[]{certificate}, privatekey, pfxAlias, new String(privatekeyPwd).toCharArray(), new String(privatekeyPwd).toCharArray(), "PKCS12", "BC");
            String datetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            File oldFile = new File(pfxFile);
            File newFile = new File(String.valueOf(pfxFile) + "." + datetime);
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
            }
            if ("BASE64".equalsIgnoreCase(encodeType)) {
                FileUtil.save2file(Base64.encode(pfxStoreBytes), pfxFile);
            } else if ("DER".equalsIgnoreCase(encodeType)) {
                FileUtil.save2file(pfxStoreBytes, pfxFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("ok");
    }
}

