/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.util;

import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import com.lsy.baselib.crypto.util.FileUtil;
import com.lsy.baselib.crypto.util.StoreUtil;
import java.io.File;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.bouncycastle.jce.PKCS10CertificationRequest;

public class ECServerUtil {
    public static void main(String[] args) {
        HashMap<String, Integer> hmSwitch = new HashMap<String, Integer>();
        hmSwitch.put("pki", Integer.valueOf(String.valueOf(1)));
        hmSwitch.put("selfsign", Integer.valueOf(String.valueOf(11)));
        if (args.length > 0) {
            block0 : switch ((Integer)hmSwitch.get(args[0].toLowerCase())) {
                case 1: {
                    if (args.length > 1) {
                        switch ((Integer)hmSwitch.get(args[1].toLowerCase())) {
                            case 11: {
                                Vector<String> parameters = new Vector<String>();
                                int i = 2;
                                while (i < args.length) {
                                    parameters.add(args[i]);
                                    ++i;
                                }
                                ECServerUtil.sign(parameters);
                                break block0;
                            }
                        }
                        ECServerUtil.usage();
                        break;
                    }
                    ECServerUtil.usage();
                    break;
                }
                default: {
                    ECServerUtil.usage();
                    break;
                }
            }
        } else {
            ECServerUtil.usage();
        }
    }

    public static void usage() {
        System.out.println("Usage: \uff08\u8bc1\u4e66\u751f\u6210\u5de5\u5177\uff09");
        System.out.println("     com.cncb.crypto.utils.ECServerUtil PKI SELFSIGN [-ATTRIBUTE=VALUE, [-ATTRIBUTE=VALUE]], \u5176\u4e2dATTRIBUTE\u5b9a\u4e49\u5982\u4e0b\uff1a");
        System.out.println("\t01\u3001subject: \u8bc1\u4e66\u4e3b\u9898\u3002\u9ed8\u8ba4\u503c\u4e3a\"CN=CNCB\"\u3002");
        System.out.println("\t02\u3001keyAlgorithm: \u5bc6\u94a5\u7b97\u6cd5\u3002\u9ed8\u8ba4\u503c\u4e3a\"RSA\"\u3002");
        System.out.println("\t03\u3001strength: \u5bc6\u94a5\u5f3a\u5ea6\u3002\u9ed8\u8ba4\u503c\u4e3a1024\u4f4d\u3002");
        System.out.println("\t04\u3001signatureAlgorithm: \u7b7e\u540d\u7b97\u6cd5\u3002\u9ed8\u8ba4\u503c\u4e3a\"SHA1WithRSAEncryption\"\u3002");
        System.out.println("\t05\u3001validity: \u8bc1\u4e66\u6709\u6548\u671f\u3002\u9ed8\u8ba4\u503c\u4e3a7300\u5929\uff0820\u5e74\uff09\u3002");
        System.out.println("\t06\u3001serial: \u8bc1\u4e66\u5e8f\u5217\u53f7\u3002\u9ed8\u8ba4\u503c\u4e3a0\u3002");
        System.out.println("\t07\u3001privatekeyFile: \u79c1\u94a5\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.key\"\u3002");
        System.out.println("\t08\u3001certificateFile: \u8bc1\u4e66\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.cer\"\u3002");
        System.out.println("\t09\u3001crtrequestFile: \u8bc1\u4e66\u8bf7\u6c42\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.csq\"\u3002");
        System.out.println("\t10\u3001passwordFile: \u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.pwd\"\u3002");
        System.out.println("\t11\u3001password:\u8bbe\u7f6e\u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801\uff0c\u82e5\u4e3a\u7a7a\u4e32\u5219\u4f7f\u7528\u968f\u673a\u5bc6\u7801\u3002");
        System.out.println("\t12\u3001pfxfile:PFX\u683c\u5f0f\u8bc1\u4e66\u6587\u4ef6\u3002\u9ed8\u8ba4\u503c\u4e3a\"ecserver.pfx\"\u3002");
        System.out.println("\n");
        System.out.println("\tExample: CNCB PKI SELFSIGN -subject=\"CN=wuyuyi,OU=CNCB,C=CN\" -validity=36500");
        System.exit(0);
    }

    public static void sign(Vector parameters) {
        String subject = "CN=CNCB EC SERVER, O=CHINA CITIC BANK CORPORATION LIMITED";
        String keyAlgorithm = "RSA";
        String strength = "2048";
        String signatureAlgorithm = "SHA1WithRSAEncryption";
        String validity = "7300";
        String serial = "0";
        String privatekeyFile = "ecserver.key";
        String crtquestFile = "ecserver.csq";
        String certificateFile = "ecserver.cer";
        String passwordFile = "ecserver.pwd";
        String password = null;
        String pfxfile = "ecserver.pfx";
        String pfxAlias = "ecserver";
        HashMap<String, String> hmParameters = new HashMap<String, String>();
        int i = 0;
        while (i < parameters.size()) {
            String parameter = (String)parameters.get(i);
            if (parameter.charAt(0) == '-' && parameter.indexOf("=") > 1) {
                String attribute = parameter.substring(1, parameter.indexOf("=")).toLowerCase();
                String value = parameter.substring(parameter.indexOf("=") + 1);
                hmParameters.put(attribute, value);
                if ("subject".equalsIgnoreCase(attribute)) {
                    subject = value;
                } else if ("keyAlgorithm".equalsIgnoreCase(attribute)) {
                    keyAlgorithm = value;
                } else if ("strength".equalsIgnoreCase(attribute)) {
                    strength = value;
                } else if ("signatureAlgorithm".equalsIgnoreCase(attribute)) {
                    signatureAlgorithm = value;
                } else if ("validity".equalsIgnoreCase(attribute)) {
                    validity = value;
                } else if ("serial".equalsIgnoreCase(attribute)) {
                    serial = value;
                } else if ("privatekeyFile".equalsIgnoreCase(attribute)) {
                    privatekeyFile = value;
                } else if ("certificateFile".equalsIgnoreCase(attribute)) {
                    certificateFile = value;
                } else if ("passwordFile".equalsIgnoreCase(attribute)) {
                    passwordFile = value;
                } else if ("password".equalsIgnoreCase(attribute)) {
                    password = value;
                } else if ("pfxfile".equalsIgnoreCase(attribute)) {
                    pfxfile = value;
                } else if ("crtquestFile".equalsIgnoreCase(attribute)) {
                    crtquestFile = value;
                }
            } else {
                ECServerUtil.usage();
            }
            ++i;
        }
        System.out.print("Operating ...");
        if (!hmParameters.containsKey("signer")) {
            try {
                File newFile;
                File oldFile;
                KeyPair cakp = CryptUtil.generateKeyPair(keyAlgorithm, strength, "BC");
                PKCS10CertificationRequest request = CryptUtil.generatePKCS10CertificateRequest(cakp, subject, signatureAlgorithm, "BC");
                X509Certificate cacert = CryptUtil.generateSelfSignedCertificate(cakp, subject, serial.getBytes(), signatureAlgorithm, validity, "BC");
                Random r = new Random();
                String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                String pwd = "";
                int j = 0;
                while (j < 7) {
                    pwd = String.valueOf(pwd) + chars.charAt(r.nextInt(chars.length()));
                    ++j;
                }
                if ("".equals(password)) {
                    password = pwd;
                }
                byte[] bytePfxStore = password == null ? StoreUtil.create(new X509Certificate[]{cacert}, cakp.getPrivate(), pfxAlias, null, "".toCharArray(), "PKCS12", "BC") : StoreUtil.create(new X509Certificate[]{cacert}, cakp.getPrivate(), pfxAlias, password.toCharArray(), password.toCharArray(), "PKCS12", "BC");
                byte[] bytesPrivatekey = password == null ? cakp.getPrivate().getEncoded() : CryptUtil.encryptPrivateKey(cakp.getPrivate(), password.toCharArray());
                String datetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                if (password != null) {
                    oldFile = new File(passwordFile);
                    newFile = new File(String.valueOf(passwordFile) + "." + datetime);
                    if (oldFile.exists()) {
                        oldFile.renameTo(newFile);
                    }
                    FileUtil.save2file(password.getBytes(), passwordFile);
                }
                oldFile = new File(crtquestFile);
                newFile = new File(String.valueOf(crtquestFile) + "." + datetime);
                if (oldFile.exists()) {
                    oldFile.renameTo(newFile);
                }
                FileUtil.save2file(Base64.encode(request.getEncoded()), crtquestFile);
                oldFile = new File(certificateFile);
                newFile = new File(String.valueOf(certificateFile) + "." + datetime);
                if (oldFile.exists()) {
                    oldFile.renameTo(newFile);
                }
                FileUtil.save2file(Base64.encode(cacert.getEncoded()), certificateFile);
                oldFile = new File(privatekeyFile);
                newFile = new File(String.valueOf(privatekeyFile) + "." + datetime);
                if (oldFile.exists()) {
                    oldFile.renameTo(newFile);
                }
                FileUtil.save2file(Base64.encode(bytesPrivatekey), privatekeyFile);
                oldFile = new File(pfxfile);
                newFile = new File(String.valueOf(pfxfile) + "." + datetime);
                if (oldFile.exists()) {
                    oldFile.renameTo(newFile);
                }
                FileUtil.save2file(bytePfxStore, pfxfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("ok");
    }
}

